/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.AbstractSourceInfoStructMaker;
import io.debezium.connector.mongodb.SourceInfo;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public class MongoDbSourceInfoStructMaker
extends AbstractSourceInfoStructMaker<SourceInfo> {
    private final Schema schema;

    public MongoDbSourceInfoStructMaker(String connector, String version, CommonConnectorConfig connectorConfig) {
        super(connector, version, connectorConfig);
        this.schema = this.commonSchemaBuilder().name(connectorConfig.schemaNameAdjustmentMode().createAdjuster().adjust("io.debezium.connector.mongo.Source")).field("rs", Schema.STRING_SCHEMA).field("collection", Schema.STRING_SCHEMA).field("ord", Schema.INT32_SCHEMA).field("lsid", Schema.OPTIONAL_STRING_SCHEMA).field("txnNumber", Schema.OPTIONAL_INT64_SCHEMA).build();
    }

    public Schema schema() {
        return this.schema;
    }

    public Struct struct(SourceInfo sourceInfo) {
        Struct struct = super.commonStruct((AbstractSourceInfo)sourceInfo).put("rs", (Object)sourceInfo.replicaSetName()).put("collection", (Object)sourceInfo.collectionId().name()).put("ord", (Object)sourceInfo.position().getInc());
        if (sourceInfo.position().getChangeStreamSessionTxnId() != null) {
            struct.put("lsid", (Object)sourceInfo.position().getChangeStreamSessionTxnId().lsid).put("txnNumber", (Object)sourceInfo.position().getChangeStreamSessionTxnId().txnNumber);
        }
        return struct;
    }
}

