/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.testing.testcontainers.MongoDbReplicaSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.data.Struct;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    protected static final Logger logger = LoggerFactory.getLogger(TestHelper.class);
    public static final List<Integer> MONGO_VERSION = TestHelper.getMongoVersion();
    private static final String TEST_PROPERTY_PREFIX = "debezium.test.";
    private static final ObjectMapper mapper = new ObjectMapper();

    private static List<Integer> getMongoVersion() {
        String prop = System.getProperty("version.mongo.server", "6.0");
        String[] parts = prop.split("\\.");
        return Stream.concat(Arrays.stream(parts), Stream.of("0", "0", "0")).limit(3L).map(Integer::parseInt).collect(Collectors.toList());
    }

    public static String hostsFor(MongoDbReplicaSet mongo) {
        ConnectionString connectionString = new ConnectionString(mongo.getConnectionString());
        String hosts = String.join((CharSequence)",", connectionString.getHosts());
        return mongo.getName() + "/" + hosts;
    }

    public static Configuration getConfiguration() {
        return TestHelper.getConfiguration("rs0/localhost:27017");
    }

    public static Configuration getConfiguration(MongoDbReplicaSet mongo) {
        String hosts = TestHelper.hostsFor(mongo);
        return TestHelper.getConfiguration(hosts);
    }

    public static Configuration getConfiguration(String hosts) {
        Configuration.Builder cfgBuilder = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.fromSystemProperties((String)"connector.").edit().withDefault(MongoDbConnectorConfig.HOSTS, hosts)).withDefault(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, true)).withDefault(CommonConnectorConfig.TOPIC_PREFIX, "mongo1");
        return cfgBuilder.build();
    }

    public static BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }

    public static MongoClient connect(MongoDbReplicaSet mongo) {
        return MongoClients.create((String)mongo.getConnectionString());
    }

    public static void cleanDatabase(MongoDbReplicaSet mongo, String dbName) {
        try (MongoClient client = TestHelper.connect(mongo);){
            MongoDatabase db1 = client.getDatabase(dbName);
            db1.listCollectionNames().forEach(x -> {
                logger.info("Removing collection '{}' from database '{}'", x, (Object)dbName);
                db1.getCollection(x).drop();
            });
        }
    }

    public static boolean transactionsSupported() {
        return MONGO_VERSION.get(0) >= 4;
    }

    public static boolean decimal128Supported() {
        return MONGO_VERSION.get(0) >= 4 || MONGO_VERSION.get(0) == 3 && MONGO_VERSION.get(1) >= 4;
    }

    public static String lines(String ... lines) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(lines).forEach(line -> sb.append((String)line).append(System.lineSeparator()));
        return sb.toString();
    }

    public static Document getDocumentWithoutLanguageVersion(String jsonString) {
        Document document = Document.parse((String)jsonString);
        document.remove((Object)"$v");
        return document;
    }

    public static int waitTimeForRecords() {
        return Integer.parseInt(System.getProperty("debezium.test.records.waittime", "2"));
    }

    public static String captureMode() {
        return System.getProperty("debezium.test.capture.mode", "changestreams");
    }

    public static void assertChangeStreamUpdate(ObjectId oid, Struct value, String after, List<String> removedFields, String updatedFields) {
        Assertions.assertThat((String)value.getString("after")).isEqualTo((Object)after.replace("<OID>", oid.toHexString()));
        Assertions.assertThat((String)value.getStruct("updateDescription").getString("updatedFields")).isEqualTo((Object)updatedFields);
        Assertions.assertThat((List)value.getStruct("updateDescription").getArray("removedFields")).isEqualTo(removedFields);
    }

    public static void assertChangeStreamUpdateAsDocs(ObjectId oid, Struct value, String after, List<String> removedFields, String updatedFields) {
        Document expectedAfter = TestHelper.getDocumentWithoutLanguageVersion(after.replace("<OID>", oid.toHexString()));
        Document actualAfter = TestHelper.getDocumentWithoutLanguageVersion(value.getString("after"));
        Assertions.assertThat((Map)actualAfter).isEqualTo((Object)expectedAfter);
        String actualUpdatedFields = value.getStruct("updateDescription").getString("updatedFields");
        if (actualUpdatedFields != null) {
            Assertions.assertThat((String)updatedFields).isNotNull();
            try {
                Assertions.assertThat((Object)mapper.readTree(actualUpdatedFields)).isEqualTo((Object)mapper.readTree(updatedFields));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)("Failed to parse JSON <" + actualUpdatedFields + "> or <" + updatedFields + ">"));
            }
        } else {
            Assertions.assertThat((String)updatedFields).isNull();
        }
        List actualRemovedFields = value.getStruct("updateDescription").getArray("removedFields");
        if (actualRemovedFields != null) {
            Assertions.assertThat(removedFields).isNotNull();
            Assertions.assertThat((actualRemovedFields.containsAll(removedFields) && removedFields.containsAll(actualRemovedFields) ? 1 : 0) != 0);
        } else {
            Assertions.assertThat(removedFields).isNull();
        }
    }
}

