/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.CursorType;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoIT;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.util.Testing;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.errors.ConnectException;
import org.assertj.core.api.Assertions;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.Before;
import org.junit.Test;

public class ConnectionIT
extends AbstractMongoIT {
    @Before
    public void setUp() {
        TestHelper.cleanDatabase(mongo, "dbA");
        TestHelper.cleanDatabase(mongo, "dbB");
        TestHelper.cleanDatabase(mongo, "dbC");
    }

    @Test(expected=ConnectException.class)
    public void shouldUseSSL() throws InterruptedException, IOException {
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).with(CommonConnectorConfig.TOPIC_PREFIX, "mongo")).with(MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS, 0)).with(MongoDbConnectorConfig.SSL_ENABLED, true)).with(MongoDbConnectorConfig.SERVER_SELECTION_TIMEOUT_MS, 2000)).build());
        this.primary.executeBlocking("Try SSL connection", mongo -> {
            this.primary.stop();
            mongo.getDatabase("dbit").listCollectionNames().first();
        });
    }

    @Test
    public void shouldCreateMovieDatabase() {
        MongoDatabase db;
        this.useConfiguration(((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, "dbA,dbB")).with(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, "dbB.moviesB")).build());
        Testing.print((Object)("Configuration: " + this.config));
        List<String> dbNames = Arrays.asList("A", "B", "C");
        try (MongoClient client2 = this.connect();){
            Testing.debug((Object)"Getting or creating 'movies' collections");
            for (String dbName : dbNames) {
                db = client2.getDatabase("db" + dbName);
                db.getCollection("movies" + dbName);
            }
            Testing.debug((Object)"Completed getting 'movies' collections");
        }
        client2 = this.connect();
        try {
            Testing.debug((Object)"Adding document to 'movies' collections");
            for (String dbName : dbNames) {
                MongoCollection collection;
                db = client2.getDatabase("db" + dbName);
                MongoCollection movies = collection = db.getCollection("movies" + dbName);
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                movies.insertOne((Object)Document.parse((String)"{ \"name\":\"Starter Wars\"}"), insertOptions);
                Assertions.assertThat((long)collection.countDocuments()).isEqualTo(1L);
            }
            Testing.debug((Object)"Completed adding documents to 'movies' collections");
        }
        finally {
            if (client2 != null) {
                client2.close();
            }
        }
        this.primary.execute("Add document to movies collections", client -> {
            for (String dbName : dbNames) {
                MongoDatabase db = client.getDatabase("db" + dbName);
                MongoCollection collection = db.getCollection("movies" + dbName);
                Bson filter = Filters.eq((String)"name", (Object)"Starter Wars");
                FindIterable movieResults = collection.find(filter);
                MongoCursor cursor = movieResults.iterator();
                try {
                    Assertions.assertThat((String)((Document)cursor.tryNext()).getString((Object)"name")).isEqualTo((Object)"Starter Wars");
                    Assertions.assertThat((Map)((Map)cursor.tryNext())).isNull();
                }
                finally {
                    if (cursor == null) continue;
                    cursor.close();
                }
            }
        });
        Assertions.assertThat((Iterable)this.primary.databaseNames()).containsOnly((Object[])new String[]{"dbA", "dbB"});
        Assertions.assertThat((List)this.primary.collections()).containsOnly((Object[])new CollectionId[]{new CollectionId(this.replicaSet.replicaSetName(), "dbA", "moviesA")});
        LinkedList eventQueue = new LinkedList();
        int minimumEventsExpected = 1;
        long maxSeconds = 5L;
        this.primary.execute("read oplog from beginning", mongo -> {
            Testing.debug((Object)"Getting local.oplog.rs");
            BsonTimestamp oplogStart = new BsonTimestamp(1, 1);
            Bson filter = Filters.and((Bson[])new Bson[]{Filters.gt((String)"ts", (Object)oplogStart), Filters.exists((String)"fromMigrate", (boolean)false)});
            FindIterable results = mongo.getDatabase("local").getCollection("oplog.rs").find(filter).sort((Bson)new Document("$natural", (Object)1)).oplogReplay(true).noCursorTimeout(true).cursorType(CursorType.TailableAwait);
            Testing.debug((Object)"Reading local.oplog.rs");
            try (MongoCursor cursor = results.iterator();){
                Document event = null;
                long stopTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(maxSeconds);
                while (System.currentTimeMillis() < stopTime && eventQueue.size() < minimumEventsExpected) {
                    while ((event = (Document)cursor.tryNext()) != null) {
                        eventQueue.add(event);
                    }
                }
                Assertions.assertThat((int)eventQueue.size()).isGreaterThanOrEqualTo(1);
            }
            Testing.debug((Object)"Completed local.oplog.rs");
        });
        eventQueue.forEach(event -> {
            Testing.print((Object)("Found: " + event));
            BsonTimestamp position = (BsonTimestamp)event.get((Object)"ts", BsonTimestamp.class);
            assert (position != null);
        });
    }
}

