/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractBaseMongoIT;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.util.Testing;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMongoIT
extends AbstractBaseMongoIT {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractMongoIT.class);
    protected Configuration config;
    protected MongoDbTaskContext context;
    protected ConnectionContext.MongoPrimary primary;
    protected ReplicaSet replicaSet;

    @Before
    public void beforeEach() {
        Testing.Print.disable();
        Testing.Debug.disable();
        this.useConfiguration(TestHelper.getConfiguration(mongo));
    }

    protected void useConfiguration(Configuration config) {
        this.config = config;
        this.initialize(true);
    }

    protected void reuseConfiguration(Configuration config) {
        this.config = config;
        this.initialize(false);
    }

    private void initialize(boolean restartFromBeginning) {
        Map partition = null;
        Map offsetForPartition = null;
        if (!restartFromBeginning && this.context != null && this.replicaSet != null && this.context.source().hasOffset(this.replicaSet.replicaSetName())) {
            partition = this.context.source().partition(this.replicaSet.replicaSetName());
            offsetForPartition = this.context.source().lastOffset(this.replicaSet.replicaSetName());
        }
        this.context = new MongoDbTaskContext(this.config);
        Assertions.assertThat((String)this.context.getConnectionContext().hosts()).isNotEmpty();
        this.replicaSet = ReplicaSet.parse((String)this.context.getConnectionContext().hosts());
        this.context.configureLoggingContext(this.replicaSet.replicaSetName());
        if (partition != null) {
            this.context.source().setOffsetFor(partition, offsetForPartition);
        }
        this.primary = this.context.getConnectionContext().primaryFor(this.replicaSet, this.context.filters(), TestHelper.connectionErrorHandler(3));
    }

    @After
    public void afterEach() {
        if (this.context != null) {
            this.context.getConnectionContext().shutdown();
        }
    }
}

