/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.spi.topic.TopicNamingStrategy;
import java.util.Collections;

public class MongoDbTaskContext
extends CdcSourceTaskContext {
    private final Filters filters;
    private final SourceInfo source;
    private final TopicNamingStrategy topicNamingStrategy;
    private final String serverName;
    private final ConnectionContext connectionContext;
    private final MongoDbConnectorConfig connectorConfig;

    public MongoDbTaskContext(Configuration config) {
        super(Module.contextName(), config.getString(CommonConnectorConfig.TOPIC_PREFIX), Collections::emptySet);
        this.filters = new Filters(config);
        this.connectorConfig = new MongoDbConnectorConfig(config);
        this.source = new SourceInfo(this.connectorConfig);
        this.topicNamingStrategy = this.connectorConfig.getTopicNamingStrategy(MongoDbConnectorConfig.TOPIC_NAMING_STRATEGY);
        this.serverName = config.getString(CommonConnectorConfig.TOPIC_PREFIX);
        this.connectionContext = new ConnectionContext(config);
    }

    public TopicNamingStrategy<CollectionId> topicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public Filters filters() {
        return this.filters;
    }

    public SourceInfo source() {
        return this.source;
    }

    public String serverName() {
        return this.serverName;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public MongoDbConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public MongoDbConnectorConfig.CaptureMode getCaptureMode() {
        return this.connectorConfig.getCaptureMode();
    }
}

