/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ConnectionString;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.schema.DefaultTopicNamingStrategy;
import io.debezium.spi.schema.DataCollectionId;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnectorConfig
extends CommonConnectorConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnectorConfig.class);
    protected static final String COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"collection.include.list\" is already specified";
    protected static final String DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"database.include.list\" is already specified";
    protected static final Pattern PATTERN_SPILT = Pattern.compile(",");
    protected static final Pattern FIELD_EXCLUDE_LIST_PATTERN = Pattern.compile("^[*|\\w|\\-|\\s*]+(?:\\.[\\w|\\-]+\\.[\\w|\\-]+)+(\\.[\\w|\\-]+)*\\s*$");
    protected static final String QUALIFIED_FIELD_EXCLUDE_LIST_PATTERN = "<databaseName>.<collectionName>.<fieldName>.<nestedFieldName>";
    protected static final Pattern FIELD_RENAMES_PATTERN = Pattern.compile("^[*|\\w|\\-|\\s*]+(?:\\.[\\w|\\-]+\\.[\\w|\\-]+)+(\\.[\\w|\\-]+)*:(?:[\\w|\\-]+)+\\s*$");
    protected static final String QUALIFIED_FIELD_RENAMES_PATTERN = "<databaseName>.<collectionName>.<fieldName>.<nestedFieldName>:<newNestedFieldName>";
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 0;
    public static final Field CONNECTION_STRING = Field.create((String)"mongodb.connection.string").withDisplayName("Connection String").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateConnectionString}).withDescription("Database connection string.");
    public static final Field HOSTS = Field.create((String)"mongodb.hosts").withDisplayName("Hosts").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateHosts}).withDescription("The hostname and port pairs (in the form 'host' or 'host:port') of the MongoDB server(s) in the replica set.");
    public static final Field AUTO_DISCOVER_MEMBERS = Field.create((String)"mongodb.members.auto.discover").withDisplayName("Auto-discovery").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(new Field.Validator[]{Field::isBoolean, MongoDbConnectorConfig::validateAutodiscovery}).withDescription("Specifies whether the addresses in 'hosts' are seeds that should be used to discover all members of the cluster or replica set ('true'), or whether the address(es) in 'hosts' should be used as is ('false'). The default is 'true'.");
    public static final Field USER = Field.create((String)"mongodb.user").withDisplayName("User").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Database user for connecting to MongoDB, if necessary.");
    public static final Field PASSWORD = Field.create((String)"mongodb.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password to be used when connecting to MongoDB, if necessary.");
    public static final Field MONGODB_POLL_INTERVAL_MS = Field.create((String)"mongodb.poll.interval.ms").withDisplayName("Replica membership poll interval (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30000L).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Interval for looking for new, removed, or changed replica sets, given in milliseconds. Defaults to 30 seconds (30,000 ms).");
    public static final Field SSL_ENABLED = Field.create((String)"mongodb.ssl.enabled").withDisplayName("Enable SSL connection to MongoDB").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Should connector use SSL to connect to MongoDB instances");
    public static final Field SSL_ALLOW_INVALID_HOSTNAMES = Field.create((String)"mongodb.ssl.invalid.hostname.allowed").withDisplayName("Allow invalid hostnames for SSL connection").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED_SSL, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks");
    public static final Field CONNECT_TIMEOUT_MS = Field.create((String)"mongodb.connect.timeout.ms").withDisplayName("Connect Timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("The connection timeout, given in milliseconds. Defaults to 10 seconds (10,000 ms).");
    public static final Field CONNECT_BACKOFF_INITIAL_DELAY_MS = Field.create((String)"connect.backoff.initial.delay.ms").withDisplayName("Initial delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(1L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The initial delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available, given in milliseconds. Defaults to 1 second (1,000 ms).");
    public static final Field CONNECT_BACKOFF_MAX_DELAY_MS = Field.create((String)"connect.backoff.max.delay.ms").withDisplayName("Maximum delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)2)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(120L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The maximum delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available, given in milliseconds. Defaults to 120 second (120,000 ms).");
    public static final Field AUTH_SOURCE = Field.create((String)"mongodb.authsource").withDisplayName("Credentials Database").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault("admin").withDescription("Database containing user credentials.");
    public static final Field MAX_FAILED_CONNECTIONS = Field.create((String)"connect.max.attempts").withDisplayName("Connection attempt limit").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(16).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Maximum number of failed connection attempts to a replica set primary before an exception occurs and task is aborted. Defaults to 16, which with the defaults for '" + CONNECT_BACKOFF_INITIAL_DELAY_MS + "' and '" + CONNECT_BACKOFF_MAX_DELAY_MS + "' results in just over 20 minutes of attempts before failing.");
    public static final Field SERVER_SELECTION_TIMEOUT_MS = Field.create((String)"mongodb.server.selection.timeout.ms").withDisplayName("Server selection timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(30000).withDescription("The server selection timeout, given in milliseconds. Defaults to 10 seconds (10,000 ms).");
    public static final Field SOCKET_TIMEOUT_MS = Field.create((String)"mongodb.socket.timeout.ms").withDisplayName("Socket timeout MS").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)6)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withDescription("The socket timeout, given in milliseconds. Defaults to 0 ms.");
    public static final Field DATABASE_INCLUDE_LIST = Field.create((String)"database.include.list").withDisplayName("Include Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be captured");
    public static final Field DATABASE_EXCLUDE_LIST = Field.create((String)"database.exclude.list").withDisplayName("Exclude Databases").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateDatabaseExcludeList}).withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be excluded");
    public static final Field COLLECTION_INCLUDE_LIST = Field.create((String)"collection.include.list").withDisplayName("Include Collections").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be captured");
    public static final Field COLLECTION_EXCLUDE_LIST = Field.create((String)"collection.exclude.list").withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)3)).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateCollectionExcludeList}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be excluded");
    public static final Field FIELD_EXCLUDE_LIST = Field.create((String)"field.exclude.list").withDisplayName("Exclude Fields").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)5)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateFieldExcludeList}).withDescription("A comma-separated list of the fully-qualified names of fields that should be excluded from change event message values");
    public static final Field FIELD_RENAMES = Field.create((String)"field.renames").withDisplayName("Rename Fields").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateFieldRenamesList}).withDescription("A comma-separated list of the fully-qualified replacements of fields that should be used to rename fields in change event message values. Fully-qualified replacements for fields are of the form databaseName.collectionName.fieldName.nestedFieldName:newNestedFieldName, where databaseName and collectionName may contain the wildcard (*) which matches any characters, the colon character (:) is used to determine rename mapping of field.");
    public static final Field CAPTURE_MODE = Field.create((String)"capture.mode").withDisplayName("Capture mode").withEnum(CaptureMode.class, (Enum)CaptureMode.CHANGE_STREAMS_UPDATE_FULL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)1)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The method used to capture changes from MongoDB server. Options include: 'change_streams' to capture changes via MongoDB Change Streams, update events do not contain full documents; 'change_streams_update_full' (the default) to capture changes via MongoDB Change Streams, update events contain full documents");
    protected static final Field TASK_ID = Field.create((String)"mongodb.task.id").withDescription("Internal use only").withValidation(new Field.Validator[]{Field::isInteger}).withInvisibleRecommender();
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should always perform an initial sync when required; 'never' to specify the connector should never perform an initial sync ");
    public static final Field SNAPSHOT_FILTER_QUERY_BY_COLLECTION = Field.create((String)"snapshot.collection.filter.overrides").withDisplayName("Snapshot mode").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_SNAPSHOT, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("This property contains a comma-separated list of <dbName>.<collectionName>, for which  the initial snapshot may be a subset of data present in the data source. The subset would be defined by mongodb filter query specified as value for property snapshot.collection.filter.override.<dbname>.<collectionName>");
    public static final Field CURSOR_MAX_AWAIT_TIME_MS = Field.create((String)"cursor.max.await.time.ms").withDisplayName("Server's oplog streaming cursor max await time").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The maximum processing time in milliseconds to wait for the oplog cursor to process a single poll request");
    public static final Field TOPIC_NAMING_STRATEGY = Field.create((String)"topic.naming.strategy").withDisplayName("Topic naming strategy class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the TopicNamingStrategy class that should be used to determine the topic name for data change, schema change, transaction, heartbeat event etc.").withDefault(DefaultTopicNamingStrategy.class.getName());
    private static final ConfigDefinition CONFIG_DEFINITION = CommonConnectorConfig.CONFIG_DEFINITION.edit().name("MongoDB").type(new Field[]{TOPIC_PREFIX, CONNECTION_STRING, HOSTS, USER, PASSWORD, AUTH_SOURCE, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, CONNECT_TIMEOUT_MS, SOCKET_TIMEOUT_MS, SERVER_SELECTION_TIMEOUT_MS, MONGODB_POLL_INTERVAL_MS, MAX_FAILED_CONNECTIONS, AUTO_DISCOVER_MEMBERS, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES, CURSOR_MAX_AWAIT_TIME_MS}).events(new Field[]{DATABASE_INCLUDE_LIST, DATABASE_EXCLUDE_LIST, COLLECTION_INCLUDE_LIST, COLLECTION_EXCLUDE_LIST, FIELD_EXCLUDE_LIST, FIELD_RENAMES, SNAPSHOT_FILTER_QUERY_BY_COLLECTION}).connector(new Field[]{SNAPSHOT_MODE, CAPTURE_MODE, SCHEMA_NAME_ADJUSTMENT_MODE}).create();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;
    private final SnapshotMode snapshotMode;
    private CaptureMode captureMode;
    private final int snapshotMaxThreads;
    private final int cursorMaxAwaitTimeMs;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public MongoDbConnectorConfig(Configuration config) {
        super(config, 0);
        String snapshotModeValue = config.getString(SNAPSHOT_MODE);
        this.snapshotMode = SnapshotMode.parse(snapshotModeValue, SNAPSHOT_MODE.defaultValueAsString());
        String captureModeValue = config.getString(CAPTURE_MODE);
        this.captureMode = CaptureMode.parse(captureModeValue, CAPTURE_MODE.defaultValueAsString());
        this.snapshotMaxThreads = MongoDbConnectorConfig.resolveSnapshotMaxThreads(config);
        this.cursorMaxAwaitTimeMs = config.getInteger(CURSOR_MAX_AWAIT_TIME_MS, 0);
    }

    private static int validateHosts(Configuration config, Field field, Field.ValidationOutput problems) {
        String hosts = config.getString(field);
        String connectionString = config.getString(CONNECTION_STRING);
        if (hosts == null && connectionString == null) {
            problems.accept(field, (Object)hosts, "Host specification or connection string is required");
            return 1;
        }
        int count = 0;
        if (hosts != null && ReplicaSets.parse(hosts).all().isEmpty()) {
            problems.accept(field, (Object)hosts, "Invalid host specification");
            ++count;
        }
        return count;
    }

    private static int validateConnectionString(Configuration config, Field field, Field.ValidationOutput problems) {
        String value = config.getString(field);
        try {
            if (value != null) {
                ConnectionString connectionString = new ConnectionString(value);
            }
        }
        catch (Exception e) {
            problems.accept(field, (Object)value, "Connection string is invalid");
            return 1;
        }
        return 0;
    }

    private static int validateAutodiscovery(Configuration config, Field field, Field.ValidationOutput problems) {
        boolean value = config.getBoolean(field);
        if (!value && config.hasKey(CONNECTION_STRING)) {
            problems.accept(field, (Object)value, "Connection string requires autodiscovery");
            return 1;
        }
        return 0;
    }

    private static int validateFieldExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        int problemCount = 0;
        String fieldExcludeList = config.getString(FIELD_EXCLUDE_LIST);
        if (fieldExcludeList != null) {
            for (String excludeField : PATTERN_SPILT.split(fieldExcludeList)) {
                if (FIELD_EXCLUDE_LIST_PATTERN.asPredicate().test(excludeField)) continue;
                problems.accept(FIELD_EXCLUDE_LIST, (Object)excludeField, excludeField + " has invalid format (expecting <databaseName>.<collectionName>.<fieldName>.<nestedFieldName>)");
                ++problemCount;
            }
        }
        return problemCount;
    }

    private static int validateFieldRenamesList(Configuration config, Field field, Field.ValidationOutput problems) {
        int problemCount = 0;
        String fieldRenamesList = config.getString(FIELD_RENAMES);
        if (fieldRenamesList != null) {
            for (String renameField : PATTERN_SPILT.split(fieldRenamesList)) {
                if (FIELD_RENAMES_PATTERN.asPredicate().test(renameField)) continue;
                problems.accept(FIELD_EXCLUDE_LIST, (Object)renameField, renameField + " has invalid format (expecting <databaseName>.<collectionName>.<fieldName>.<nestedFieldName>:<newNestedFieldName>)");
                ++problemCount;
            }
        }
        return problemCount;
    }

    private static int validateCollectionExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getString(COLLECTION_INCLUDE_LIST);
        String excludeList = config.getString(COLLECTION_EXCLUDE_LIST);
        if (includeList != null && excludeList != null) {
            problems.accept(COLLECTION_EXCLUDE_LIST, (Object)excludeList, COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    private static int validateDatabaseExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getString(DATABASE_INCLUDE_LIST);
        String excludeList = config.getString(DATABASE_EXCLUDE_LIST);
        if (includeList != null && excludeList != null) {
            problems.accept(DATABASE_EXCLUDE_LIST, (Object)excludeList, DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public int getCursorMaxAwaitTime() {
        return this.cursorMaxAwaitTimeMs;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        return new MongoDbSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public Optional<String> getSnapshotFilterQueryForCollection(CollectionId collectionId) {
        return Optional.ofNullable(this.getSnapshotFilterQueryByCollection().get(collectionId.dbName() + "." + collectionId.name()));
    }

    public Map<String, String> getSnapshotFilterQueryByCollection() {
        String collectionList = this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION);
        if (collectionList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> snapshotFilterQueryByCollection = new HashMap<String, String>();
        for (String collection : collectionList.split(",")) {
            snapshotFilterQueryByCollection.put(collection, this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION + "." + collection));
        }
        return Collections.unmodifiableMap(snapshotFilterQueryByCollection);
    }

    public boolean supportsOperationFiltering() {
        return true;
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    private static int resolveSnapshotMaxThreads(Configuration config) {
        return config.getInteger(SNAPSHOT_MAX_THREADS);
    }

    public Optional<String[]> parseSignallingMessage(Struct value) {
        String after = value.getString("after");
        if (after == null) {
            LOGGER.warn("After part of signal '{}' is missing", (Object)value);
            return Optional.empty();
        }
        Document fields = Document.parse((String)after);
        if (fields.size() != 3) {
            LOGGER.warn("The signal event '{}' should have 3 fields but has {}", (Object)after, (Object)fields.size());
            return Optional.empty();
        }
        String[] result = new String[3];
        int idx = 0;
        for (Object fieldValue : fields.values()) {
            if (fieldValue instanceof Document) {
                result[idx++] = ((Document)fieldValue).toJson();
                continue;
            }
            result[idx++] = fieldValue.toString();
        }
        return Optional.of(result);
    }

    public boolean isSignalDataCollection(DataCollectionId dataCollectionId) {
        CollectionId id = (CollectionId)dataCollectionId;
        return this.getSignalingDataCollectionId() != null && this.getSignalingDataCollectionId().equals(id.dbName() + "." + id.name());
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        NEVER("never", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum CaptureMode implements EnumeratedValue
    {
        CHANGE_STREAMS("change_streams", true, false, false),
        CHANGE_STREAMS_UPDATE_FULL("change_streams_update_full", true, true, false),
        CHANGE_STREAMS_WITH_PRE_IMAGE("change_streams_with_pre_image", true, false, true),
        CHANGE_STREAMS_UPDATE_FULL_WITH_PRE_IMAGE("change_streams_update_full_with_pre_image", true, true, true);

        private final String value;
        private final boolean changeStreams;
        private final boolean fullUpdate;
        private final boolean includePreImage;

        private CaptureMode(String value, boolean changeStreams, boolean fullUpdate, boolean includePreImage) {
            this.value = value;
            this.changeStreams = changeStreams;
            this.fullUpdate = fullUpdate;
            this.includePreImage = includePreImage;
        }

        public String getValue() {
            return this.value;
        }

        public static CaptureMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (CaptureMode option : CaptureMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static CaptureMode parse(String value, String defaultValue) {
            CaptureMode mode = CaptureMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = CaptureMode.parse(defaultValue);
            }
            return mode;
        }

        public boolean isFullUpdate() {
            return this.fullUpdate;
        }

        public boolean isIncludePreImage() {
            return this.includePreImage;
        }
    }
}

