/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.bson.Document;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class MongoMetricsIT
extends AbstractMongoConnectorIT {
    @Test
    public void testLifecycle() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.INITIAL)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).build();
        this.context = new MongoDbTaskContext(this.config);
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        MongoMetricsIT.waitForSnapshotToBeCompleted("mongodb", "mongo1");
        MongoMetricsIT.waitForStreamingRunning("mongodb", "mongo1");
        this.stopConnector();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            mBeanServer.getMBeanInfo(MongoMetricsIT.getSnapshotMetricsObjectName("mongodb", "mongo1"));
            Assert.fail((String)"Expected Snapshot Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        try {
            mBeanServer.getMBeanInfo(MongoMetricsIT.getStreamingMetricsObjectName("mongodb", "mongo1"));
            Assert.fail((String)"Expected Streaming Metrics no longer to exist");
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testSnapshotOnlyMetrics() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.INITIAL)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        MongoMetricsIT.waitForSnapshotToBeCompleted("mongodb", "mongo1");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("mongo1.dbit.restaurants").size()).isEqualTo(6);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = MongoMetricsIT.getSnapshotMetricsObjectName("mongodb", "mongo1");
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "TotalTableCount")).isEqualTo((Object)1);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "RemainingTableCount")).isEqualTo((Object)0);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotRunning")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotAborted")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotCompleted")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "TotalNumberOfEventsSeen")).isEqualTo((Object)6L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfEventsFiltered")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfErroneousEvents")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "CapturedTables")).isEqualTo((Object)new String[]{"rs0.dbit.restaurants"});
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "LastEvent")).isNotNull();
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfDisconnects")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotPaused")).isEqualTo((Object)false);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SnapshotPausedDurationInSeconds")).isEqualTo((Object)0L);
    }

    @Test
    public void testStreamingOnlyMetrics() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.NEVER)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        MongoMetricsIT.waitForStreamingRunning("mongodb", "mongo1");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)records.recordsForTopic("mongo1.dbit.restaurants").size()).isEqualTo(6);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = MongoMetricsIT.getStreamingMetricsObjectName("mongodb", "mongo1");
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "SourceEventPosition")).isNotNull();
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "Connected")).isEqualTo((Object)true);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "CapturedTables")).isEqualTo((Object)new String[0]);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "LastEvent")).isNotNull();
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "TotalNumberOfEventsSeen")).isEqualTo((Object)6L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfEventsFiltered")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfErroneousEvents")).isEqualTo((Object)0L);
        Assertions.assertThat((Long)((Long)mBeanServer.getAttribute(objectName, "MilliSecondsSinceLastEvent"))).isGreaterThanOrEqualTo(0L);
        Assertions.assertThat((Long)((Long)mBeanServer.getAttribute(objectName, "MilliSecondsBehindSource"))).isGreaterThanOrEqualTo(0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfDisconnects")).isEqualTo((Object)0L);
        Assertions.assertThat((Object)mBeanServer.getAttribute(objectName, "NumberOfPrimaryElections")).isEqualTo((Object)0L);
    }

    @Test
    public void testPauseResumeSnapshotMetrics() throws Exception {
        String DOCUMENT_ID = "_id";
        int NUM_RECORDS = 1000;
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.NEVER)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbit.*")).with(MongoDbConnectorConfig.SIGNAL_DATA_COLLECTION, "dbit.debezium_signal")).with(MongoDbConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1)).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        Document[] documents = new Document[1000];
        for (int i = 0; i < 1000; ++i) {
            Document doc = new Document();
            doc.append("_id", (Object)(i + 1)).append("aa", (Object)i);
            documents[i] = doc;
        }
        this.insertDocumentsInTx("dbit", "numbers", documents);
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        MongoMetricsIT.waitForStreamingRunning("mongodb", "mongo1");
        this.insertDocuments("dbit", "debezium_signal", Document.parse((String)"{\"type\": \"execute-snapshot\", \"payload\": \"{\\\"data-collections\\\": [\\\" dbit.numbers \\\"]}\"}"));
        this.insertDocuments("dbit", "debezium_signal", Document.parse((String)"{\"type\": \"pause-snapshot\", \"payload\": \"{}\"}"));
        Thread.sleep(1500L);
        this.insertDocuments("dbit", "debezium_signal", Document.parse((String)"{\"type\": \"resume-snapshot\", \"payload\": \"{}\"}"));
        ArrayList records = new ArrayList();
        this.consumeRecords(1000, record -> records.add(record));
        Assert.assertTrue((records.size() >= 1000 ? 1 : 0) != 0);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName objectName = MongoMetricsIT.getSnapshotMetricsObjectName("mongodb", "mongo1");
        long snapshotPauseDuration = (Long)mBeanServer.getAttribute(objectName, "SnapshotPausedDurationInSeconds");
        Assert.assertTrue((snapshotPauseDuration > 0L ? 1 : 0) != 0);
    }
}

