/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.TestHelper;
import java.util.Optional;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.Assert;
import org.junit.Test;

public class MongoDbConnectorConfigTest {
    @Test
    public void parseSignallingMessage() {
        Schema schema = new SchemaBuilder(Schema.Type.STRUCT).field("after", Schema.STRING_SCHEMA).build();
        Struct struct = new Struct(schema);
        struct.put("after", (Object)"{\"_id\":\"test-1\",\"type\":\"execute-snapshot\",\"data\":{\"data-collections\":[\"database.collection\"],\"type\":\"incremental\"}}");
        MongoDbConnectorConfig mongoDbConnectorConfig = new MongoDbConnectorConfig(TestHelper.getConfiguration());
        Optional resultOpt = mongoDbConnectorConfig.parseSignallingMessage(struct);
        Assert.assertTrue((boolean)resultOpt.isPresent());
        String[] result = (String[])resultOpt.get();
        Assert.assertEquals((long)3L, (long)result.length);
        Assert.assertEquals((Object)"test-1", (Object)result[0]);
        Assert.assertEquals((Object)"execute-snapshot", (Object)result[1]);
        Assert.assertEquals((Object)"{\"data-collections\": [\"database.collection\"], \"type\": \"incremental\"}", (Object)result[2]);
    }
}

