/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoException;
import com.mongodb.client.MongoClient;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbConnectorTask;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSetDiscovery;
import io.debezium.connector.mongodb.ReplicaSetMonitorThread;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import io.debezium.util.Threads;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnector
extends SourceConnector {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Configuration config;
    private ReplicaSetMonitorThread monitorThread;
    private MongoDbTaskContext taskContext;
    private ConnectionContext connectionContext;
    private ExecutorService replicaSetMonitorExecutor;

    public String version() {
        return Module.version();
    }

    public Class<? extends Task> taskClass() {
        return MongoDbConnectorTask.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Map<String, String> props) {
        Configuration config = Configuration.from(props);
        if (!config.validateAndRecord((Iterable)MongoDbConnectorConfig.ALL_FIELDS, arg_0 -> ((Logger)this.logger).error(arg_0))) {
            throw new ConnectException("Error configuring an instance of " + ((Object)((Object)this)).getClass().getSimpleName() + "; check the logs for details");
        }
        this.config = config;
        this.taskContext = new MongoDbTaskContext(config);
        this.connectionContext = this.taskContext.getConnectionContext();
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext("conn");
        try {
            this.logger.info("Starting MongoDB connector and discovering replica set(s) at {}", (Object)this.connectionContext.connectionSeed());
            this.replicaSetMonitorExecutor = Threads.newSingleThreadExecutor(MongoDbConnector.class, (String)this.taskContext.serverName(), (String)"replica-set-monitor");
            ReplicaSetDiscovery monitor = new ReplicaSetDiscovery(this.taskContext);
            this.monitorThread = new ReplicaSetMonitorThread(monitor::getReplicaSets, this.connectionContext.pollInterval(), Clock.SYSTEM, () -> this.taskContext.configureLoggingContext("disc"), this::replicaSetsChanged);
            this.replicaSetMonitorExecutor.execute(this.monitorThread);
            this.logger.info("Successfully started MongoDB connector, and continuing to discover changes in replica set(s) at {}", (Object)this.connectionContext.connectionSeed());
        }
        finally {
            previousLogContext.restore();
        }
    }

    protected void replicaSetsChanged(ReplicaSets replicaSets) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Requesting task reconfiguration due to new/removed replica set(s) for MongoDB with seeds {}", (Object)this.connectionContext.connectionSeed());
            this.logger.info("New replica sets include:");
            replicaSets.onEachReplicaSet(replicaSet -> this.logger.info("  {}", replicaSet));
        }
        this.context.requestTaskReconfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, String>> taskConfigs(int maxTasks) {
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext("conn");
        try {
            if (this.config == null) {
                this.logger.error("Configuring a maximum of {} tasks with no connector configuration available", (Object)maxTasks);
                List<Map<String, String>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Map<String, String>> taskConfigs = new ArrayList<Map<String, String>>(maxTasks);
            ReplicaSets replicaSets = this.monitorThread.getReplicaSets(10L, TimeUnit.SECONDS);
            if (replicaSets != null) {
                this.logger.info("Subdividing {} MongoDB replica set(s) into at most {} task(s)", (Object)replicaSets.replicaSetCount(), (Object)maxTasks);
                replicaSets.subdivide(maxTasks, replicaSetsForTask -> {
                    int taskId = taskConfigs.size();
                    this.logger.info("Configuring MongoDB connector task {} to capture events for replica set(s) at {}", (Object)taskId, (Object)replicaSetsForTask.hosts());
                    Properties configProps = this.config.asProperties();
                    configProps.remove(MongoDbConnectorConfig.CONNECTION_STRING.name());
                    taskConfigs.add(((Configuration.Builder)((Configuration.Builder)this.config.edit().with(MongoDbConnectorConfig.HOSTS, replicaSetsForTask.hosts())).with(MongoDbConnectorConfig.TASK_ID, taskId)).build().asMap());
                });
            }
            this.logger.debug("Configuring {} MongoDB connector task(s)", (Object)taskConfigs.size());
            ArrayList<Map<String, String>> arrayList = taskConfigs;
            return arrayList;
        }
        finally {
            previousLogContext.restore();
        }
    }

    public void stop() {
        LoggingContext.PreviousContext previousLogContext = this.taskContext != null ? this.taskContext.configureLoggingContext("conn") : null;
        try {
            this.logger.info("Stopping MongoDB connector");
            this.config = null;
            Thread.interrupted();
            if (this.replicaSetMonitorExecutor != null) {
                this.replicaSetMonitorExecutor.shutdownNow();
            }
            try {
                if (this.connectionContext != null) {
                    this.connectionContext.shutdown();
                }
            }
            finally {
                this.logger.info("Stopped MongoDB connector");
            }
        }
        finally {
            if (previousLogContext != null) {
                previousLogContext.restore();
            }
        }
    }

    public ConfigDef config() {
        return MongoDbConnectorConfig.configDef();
    }

    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map results = config.validate(MongoDbConnectorConfig.EXPOSED_FIELDS);
        ConfigValue connectionStringValue = (ConfigValue)results.get(MongoDbConnectorConfig.CONNECTION_STRING.name());
        ConfigValue hostsValue = (ConfigValue)results.get(MongoDbConnectorConfig.HOSTS.name());
        ConfigValue userValue = (ConfigValue)results.get(MongoDbConnectorConfig.USER.name());
        ConfigValue passwordValue = (ConfigValue)results.get(MongoDbConnectorConfig.PASSWORD.name());
        if (hostsValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty() && passwordValue.errorMessages().isEmpty() && connectionStringValue.errorMessages().isEmpty()) {
            try (ConnectionContext connContext = new ConnectionContext(config);
                 MongoClient client = connContext.clientForSeedConnection();){
                client.listDatabaseNames();
            }
            catch (MongoException e) {
                hostsValue.addErrorMessage("Unable to connect: " + e.getMessage());
            }
        }
        return new Config(new ArrayList(results.values()));
    }
}

