/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.client.MongoDatabase;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    protected static final Logger logger = LoggerFactory.getLogger(TestHelper.class);
    private static final String TEST_PROPERTY_PREFIX = "debezium.test.";
    private static final ObjectMapper mapper = new ObjectMapper();

    public static Configuration getConfiguration() {
        Configuration.Builder cfgBuilder = (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.fromSystemProperties((String)"connector.").edit().withDefault(MongoDbConnectorConfig.HOSTS, "rs0/localhost:27017")).withDefault(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, false)).withDefault(CommonConnectorConfig.TOPIC_PREFIX, "mongo1");
        return cfgBuilder.build();
    }

    public static ConnectionContext.MongoPrimary primary(MongoDbTaskContext context) {
        ReplicaSet replicaSet = ReplicaSet.parse((String)context.getConnectionContext().hosts());
        return context.getConnectionContext().primaryFor(replicaSet, context.filters(), TestHelper.connectionErrorHandler(3));
    }

    public static BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }

    public static void cleanDatabase(ConnectionContext.MongoPrimary primary, String dbName) {
        primary.execute("clean-db", mongo -> {
            MongoDatabase db1 = mongo.getDatabase(dbName);
            db1.listCollectionNames().forEach(x -> {
                logger.info("Removing collection '{}' from database '{}'", x, (Object)dbName);
                db1.getCollection(x).drop();
            });
        });
    }

    public static Document databaseInformation(ConnectionContext.MongoPrimary primary, String dbName) {
        AtomicReference ret = new AtomicReference();
        primary.execute("clean-db", mongo -> {
            MongoDatabase db1 = mongo.getDatabase(dbName);
            BsonDocument command = new BsonDocument();
            command.put("buildinfo", (BsonValue)new BsonString(""));
            ret.set(db1.runCommand((Bson)command));
        });
        return (Document)ret.get();
    }

    public static List<Integer> getVersionArray(ConnectionContext.MongoPrimary primary, String dbName) {
        Document serverInfo = TestHelper.databaseInformation(primary, dbName);
        List version = (List)serverInfo.get((Object)"versionArray");
        return version;
    }

    public static boolean transactionsSupported(ConnectionContext.MongoPrimary primary, String dbName) {
        List<Integer> version = TestHelper.getVersionArray(primary, dbName);
        return version.get(0) >= 4;
    }

    public static boolean decimal128Supported(ConnectionContext.MongoPrimary primary, String dbName) {
        List<Integer> version = TestHelper.getVersionArray(primary, dbName);
        return version.get(0) >= 4 || version.get(0) == 3 && version.get(1) >= 4;
    }

    public static String lines(String ... lines) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(lines).forEach(line -> sb.append((String)line).append(System.lineSeparator()));
        return sb.toString();
    }

    public static Document getDocumentWithoutLanguageVersion(String jsonString) {
        Document document = Document.parse((String)jsonString);
        document.remove((Object)"$v");
        return document;
    }

    public static int waitTimeForRecords() {
        return Integer.parseInt(System.getProperty("debezium.test.records.waittime", "2"));
    }

    public static String captureMode() {
        return System.getProperty("debezium.test.capture.mode", "changestreams");
    }

    public static void assertChangeStreamUpdate(ObjectId oid, Struct value, String after, List<String> removedFields, String updatedFields) {
        Assertions.assertThat((String)value.getString("after")).isEqualTo((Object)after.replace("<OID>", oid.toHexString()));
        Assertions.assertThat((String)value.getStruct("updateDescription").getString("updatedFields")).isEqualTo((Object)updatedFields);
        Assertions.assertThat((List)value.getStruct("updateDescription").getArray("removedFields")).isEqualTo(removedFields);
    }

    public static void assertChangeStreamUpdateAsDocs(ObjectId oid, Struct value, String after, List<String> removedFields, String updatedFields) {
        Document expectedAfter = TestHelper.getDocumentWithoutLanguageVersion(after.replace("<OID>", oid.toHexString()));
        Document actualAfter = TestHelper.getDocumentWithoutLanguageVersion(value.getString("after"));
        Assertions.assertThat((Map)actualAfter).isEqualTo((Object)expectedAfter);
        String actualUpdatedFields = value.getStruct("updateDescription").getString("updatedFields");
        if (actualUpdatedFields != null) {
            Assertions.assertThat((String)updatedFields).isNotNull();
            try {
                Assertions.assertThat((Object)mapper.readTree(actualUpdatedFields)).isEqualTo((Object)mapper.readTree(updatedFields));
            }
            catch (JsonProcessingException e) {
                Assert.fail((String)("Failed to parse JSON <" + actualUpdatedFields + "> or <" + updatedFields + ">"));
            }
        } else {
            Assertions.assertThat((String)updatedFields).isNull();
        }
        List actualRemovedFields = value.getStruct("updateDescription").getArray("removedFields");
        if (actualRemovedFields != null) {
            Assertions.assertThat(removedFields).isNotNull();
            Assertions.assertThat((actualRemovedFields.containsAll(removedFields) && removedFields.containsAll(actualRemovedFields) ? 1 : 0) != 0);
        } else {
            Assertions.assertThat(removedFields).isNull();
        }
    }
}

