/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.ServerAddress;
import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.MongoUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Immutable
public final class ReplicaSet
implements Comparable<ReplicaSet> {
    private static final Pattern HOST_PATTERN = Pattern.compile("((([^=]+)[=])?(([^/]+)\\/))?(.+)");
    private final List<ServerAddress> addresses;
    private final String replicaSetName;
    private final String shardName;
    private final int hc;

    public static ReplicaSet parse(String hosts) {
        Matcher matcher;
        if (hosts != null && (matcher = HOST_PATTERN.matcher(hosts)).matches()) {
            String shard = matcher.group(3);
            String replicaSetName = matcher.group(5);
            String host = matcher.group(6);
            if (host != null && host.trim().length() != 0) {
                return new ReplicaSet(host, replicaSetName, shard);
            }
        }
        return null;
    }

    public ReplicaSet(List<ServerAddress> addresses, String replicaSetName, String shardName) {
        this.addresses = new ArrayList<ServerAddress>(addresses);
        this.addresses.sort(ReplicaSet::compareServerAddresses);
        this.replicaSetName = replicaSetName != null ? replicaSetName.trim() : null;
        this.shardName = shardName != null ? shardName.trim() : null;
        this.hc = addresses.hashCode();
    }

    public ReplicaSet(String addresses, String replicaSetName, String shardName) {
        this(MongoUtil.parseAddresses(addresses), replicaSetName, shardName);
    }

    public List<ServerAddress> addresses() {
        return this.addresses;
    }

    public String replicaSetName() {
        return this.replicaSetName;
    }

    public String shardName() {
        return this.shardName;
    }

    public boolean isStandaloneServer() {
        return this.replicaSetName == null;
    }

    public boolean hasReplicaSetName() {
        return this.replicaSetName != null;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReplicaSet) {
            ReplicaSet that = (ReplicaSet)obj;
            return Objects.equals(this.shardName, that.shardName) && Objects.equals(this.replicaSetName, that.replicaSetName) && this.addresses.equals(that.addresses);
        }
        return false;
    }

    @Override
    public int compareTo(ReplicaSet that) {
        if (that == this) {
            return 0;
        }
        int diff = ReplicaSet.compareNullable(this.shardName, that.shardName);
        if (diff != 0) {
            return diff;
        }
        diff = ReplicaSet.compareNullable(this.replicaSetName, that.replicaSetName);
        if (diff != 0) {
            return diff;
        }
        Iterator<ServerAddress> thisIter = this.addresses.iterator();
        Iterator<ServerAddress> thatIter = that.addresses.iterator();
        while (thisIter.hasNext() && thatIter.hasNext()) {
            diff = ReplicaSet.compare(thisIter.next(), thatIter.next());
            if (diff == 0) continue;
            return diff;
        }
        if (thisIter.hasNext()) {
            return 1;
        }
        if (thatIter.hasNext()) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        Iterator<ServerAddress> iter;
        StringBuilder sb = new StringBuilder();
        if (this.shardName != null && !this.shardName.isEmpty()) {
            sb.append(this.shardName).append('=');
        }
        if (this.replicaSetName != null && !this.replicaSetName.isEmpty()) {
            sb.append(this.replicaSetName).append('/');
        }
        if ((iter = this.addresses.iterator()).hasNext()) {
            sb.append(MongoUtil.toString(iter.next()));
        }
        while (iter.hasNext()) {
            sb.append(',').append(MongoUtil.toString(iter.next()));
        }
        return sb.toString();
    }

    protected static int compareServerAddresses(ServerAddress one, ServerAddress two) {
        if (one == two) {
            return 0;
        }
        if (one == null) {
            return two == null ? 0 : -1;
        }
        if (two == null) {
            return 1;
        }
        return ReplicaSet.compare(one, two);
    }

    protected static int compareNullable(String str1, String str2) {
        if (str1 == str2) {
            return 0;
        }
        if (str1 == null) {
            return str2 == null ? 0 : -1;
        }
        if (str2 == null) {
            return 1;
        }
        return str1.compareTo(str2);
    }

    protected static int compare(ServerAddress address1, ServerAddress address2) {
        int diff = address1.getHost().compareTo(address2.getHost());
        if (diff != 0) {
            return diff;
        }
        return address1.getPort() - address2.getPort();
    }
}

