/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbSchemaFactory;
import io.debezium.data.Envelope;
import io.debezium.data.Json;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.spi.topic.TopicNamingStrategy;
import io.debezium.util.SchemaNameAdjuster;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MongoDbSchema
implements DatabaseSchema<CollectionId> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbSchema.class);
    public static final String SCHEMA_NAME_UPDATED_DESCRIPTION = "io.debezium.connector.mongodb.changestream.updatedescription";
    public static final String SCHEMA_NAME_TRUNCATED_ARRAY = "io.debezium.connector.mongodb.changestream.truncatedarray";
    public static final Schema TRUNCATED_ARRAY_SCHEMA = MongoDbSchemaFactory.get().truncatedArraySchema();
    public static final Schema UPDATED_DESCRIPTION_SCHEMA = MongoDbSchemaFactory.get().updatedDescriptionSchema();
    private final Filters filters;
    private final TopicNamingStrategy<CollectionId> topicNamingStrategy;
    private final Schema sourceSchema;
    private final SchemaNameAdjuster adjuster;
    private final ConcurrentMap<CollectionId, MongoDbCollectionSchema> collections = new ConcurrentHashMap<CollectionId, MongoDbCollectionSchema>();
    private final JsonSerialization serialization = new JsonSerialization();

    public MongoDbSchema(Filters filters, TopicNamingStrategy<CollectionId> topicNamingStrategy, Schema sourceSchema, SchemaNameAdjuster schemaNameAdjuster) {
        this.filters = filters;
        this.topicNamingStrategy = topicNamingStrategy;
        this.sourceSchema = sourceSchema;
        this.adjuster = schemaNameAdjuster;
    }

    public void close() {
    }

    public DataCollectionSchema schemaFor(CollectionId collectionId) {
        return this.collections.computeIfAbsent(collectionId, id -> {
            FieldSelector.FieldFilter fieldFilter = this.filters.fieldFilterFor((CollectionId)id);
            String topicName = this.topicNamingStrategy.dataChangeTopic((DataCollectionId)id);
            Schema keySchema = SchemaBuilder.struct().name(this.adjuster.adjust(topicName + ".Key")).field("id", Schema.STRING_SCHEMA).build();
            Schema valueSchema = SchemaBuilder.struct().name(this.adjuster.adjust(Envelope.schemaName((String)topicName))).field("before", Json.builder().optional().build()).field("after", Json.builder().optional().build()).field("patch", Json.builder().optional().build()).field("filter", Json.builder().optional().build()).field("updateDescription", UPDATED_DESCRIPTION_SCHEMA).field("source", this.sourceSchema).field("op", Schema.OPTIONAL_STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("transaction", TransactionMonitor.TRANSACTION_BLOCK_SCHEMA).build();
            Envelope envelope = Envelope.fromSchema((Schema)valueSchema);
            return new MongoDbCollectionSchema((CollectionId)id, fieldFilter, keySchema, this.serialization::getDocumentIdOplog, this.serialization::getDocumentIdChangeStream, envelope, valueSchema, this.serialization::getDocumentValue);
        });
    }

    public boolean tableInformationComplete() {
        return false;
    }

    public void assureNonEmptySchema() {
        if (this.collections.isEmpty()) {
            LOGGER.warn("After applying the include/exclude list filters, no changes will be captured. Please check your configuration!");
        }
    }

    public boolean isHistorized() {
        return false;
    }
}

