/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.MongoDbCollectionSchema;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.data.Envelope;
import io.debezium.pipeline.AbstractChangeRecordEmitter;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.util.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonDocument;

public class MongoDbChangeSnapshotOplogRecordEmitter
extends AbstractChangeRecordEmitter<MongoDbPartition, MongoDbCollectionSchema> {
    private final BsonDocument oplogEvent;
    private final boolean isSnapshot;
    @Immutable
    private static final Map<String, Envelope.Operation> OPERATION_LITERALS;

    public MongoDbChangeSnapshotOplogRecordEmitter(MongoDbPartition partition, OffsetContext offsetContext, Clock clock, BsonDocument oplogEvent, boolean isSnapshot) {
        super((Partition)partition, offsetContext, clock);
        this.oplogEvent = oplogEvent;
        this.isSnapshot = isSnapshot;
    }

    public Envelope.Operation getOperation() {
        if (this.isSnapshot || this.oplogEvent.getString((Object)"op").getValue() == null) {
            return Envelope.Operation.READ;
        }
        return OPERATION_LITERALS.get(this.oplogEvent.getString((Object)"op").getValue());
    }

    protected void emitReadRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        Struct newKey = schema.keyFromDocumentOplog(this.oplogEvent);
        assert (newKey != null);
        Struct value = schema.valueFromDocumentOplog(this.oplogEvent, null, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)schema, this.getOperation(), (Object)newKey, value, this.getOffset(), null);
    }

    protected void emitCreateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    protected void emitUpdateRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    protected void emitDeleteRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        this.createAndEmitChangeRecord(receiver, schema);
    }

    private void createAndEmitChangeRecord(ChangeRecordEmitter.Receiver receiver, MongoDbCollectionSchema schema) throws InterruptedException {
        BsonDocument patchObject = this.oplogEvent.getDocument((Object)"o");
        BsonDocument filter = this.oplogEvent.containsKey((Object)"o2") ? this.oplogEvent.getDocument((Object)"o2") : this.oplogEvent.getDocument((Object)"o");
        Struct newKey = schema.keyFromDocumentOplog(filter);
        assert (newKey != null);
        Struct value = schema.valueFromDocumentOplog(patchObject, filter, this.getOperation());
        value.put("source", (Object)this.getOffset().getSourceInfo());
        value.put("op", (Object)this.getOperation().code());
        value.put("ts_ms", (Object)this.getClock().currentTimeAsInstant().toEpochMilli());
        receiver.changeRecord(this.getPartition(), (DataCollectionSchema)schema, this.getOperation(), (Object)newKey, value, this.getOffset(), null);
    }

    public static boolean isValidOperation(String operation) {
        return OPERATION_LITERALS.containsKey(operation);
    }

    static {
        HashMap<String, Envelope.Operation> literals = new HashMap<String, Envelope.Operation>();
        literals.put("i", Envelope.Operation.CREATE);
        literals.put("u", Envelope.Operation.UPDATE);
        literals.put("d", Envelope.Operation.DELETE);
        OPERATION_LITERALS = Collections.unmodifiableMap(literals);
    }
}

