/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Selectors;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.relational.history.DatabaseHistoryMetrics;
import io.debezium.relational.history.HistoryRecordComparator;
import io.debezium.relational.history.KafkaDatabaseHistory;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceConnector;

public abstract class HistorizedRelationalDatabaseConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 2000;
    private boolean useCatalogBeforeSchema;
    private final String logicalName;
    private final Class<? extends SourceConnector> connectorClass;
    private final boolean multiPartitionMode;
    public static final Field DATABASE_HISTORY = Field.create("database.history").withDisplayName("Database history class").withType(ConfigDef.Type.CLASS).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("The name of the DatabaseHistory class that should be used to store and recover database schema changes. The configuration properties for the history are prefixed with the 'database.history.' string.").withDefault(KafkaDatabaseHistory.class.getName());
    protected static final ConfigDefinition CONFIG_DEFINITION = RelationalDatabaseConnectorConfig.CONFIG_DEFINITION.edit().history(DATABASE_HISTORY, DatabaseHistory.SKIP_UNPARSEABLE_DDL_STATEMENTS, DatabaseHistory.STORE_ONLY_CAPTURED_TABLES_DDL, KafkaDatabaseHistory.BOOTSTRAP_SERVERS, KafkaDatabaseHistory.TOPIC, KafkaDatabaseHistory.RECOVERY_POLL_ATTEMPTS, KafkaDatabaseHistory.RECOVERY_POLL_INTERVAL_MS, KafkaDatabaseHistory.KAFKA_QUERY_TIMEOUT_MS).create();

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, boolean useCatalogBeforeSchema, int defaultSnapshotFetchSize, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, logicalName, systemTablesFilter, TableId::toString, defaultSnapshotFetchSize, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
    }

    protected HistorizedRelationalDatabaseConnectorConfig(Class<? extends SourceConnector> connectorClass, Configuration config, String logicalName, Tables.TableFilter systemTablesFilter, Selectors.TableIdToStringMapper tableIdMapper, boolean useCatalogBeforeSchema, ColumnFilterMode columnFilterMode, boolean multiPartitionMode) {
        super(config, logicalName, systemTablesFilter, tableIdMapper, 2000, columnFilterMode);
        this.useCatalogBeforeSchema = useCatalogBeforeSchema;
        this.logicalName = logicalName;
        this.connectorClass = connectorClass;
        this.multiPartitionMode = multiPartitionMode;
    }

    public DatabaseHistory getDatabaseHistory() {
        Configuration config = this.getConfig();
        DatabaseHistory databaseHistory = config.getInstance(DATABASE_HISTORY, DatabaseHistory.class);
        if (databaseHistory == null) {
            throw new ConnectException("Unable to instantiate the database history class " + config.getString(DATABASE_HISTORY));
        }
        Configuration dbHistoryConfig = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)config.subset("database.history.", false).edit().withDefault(DatabaseHistory.NAME, this.getLogicalName() + "-dbhistory")).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_CLASS, this.connectorClass.getName())).withDefault(KafkaDatabaseHistory.INTERNAL_CONNECTOR_ID, this.logicalName)).build();
        HistoryRecordComparator historyComparator = this.getHistoryRecordComparator();
        databaseHistory.configure(dbHistoryConfig, historyComparator, new DatabaseHistoryMetrics(this, this.multiPartitionMode), this.useCatalogBeforeSchema);
        return databaseHistory;
    }

    public boolean useCatalogBeforeSchema() {
        return this.useCatalogBeforeSchema;
    }

    protected abstract HistoryRecordComparator getHistoryRecordComparator();
}

