/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class CollectionIdTest {
    private CollectionId id;

    @Test
    public void shouldParseString() {
        this.assertParseable("a", "b", "c");
    }

    @Test
    public void shouldParseStringWithDottedCollection() {
        this.assertParseable("a", "b", "c.d");
    }

    @Test
    public void shouldNotParseStringWithDotAtStart() {
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0", (String)".a.b")).isNull();
    }

    @Test
    public void shouldNotParseStringWithDotAtEnd() {
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0", (String)"a.")).isNull();
    }

    @Test
    public void shouldNotParseStringWithOneSegment() {
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0", (String)"a")).isNull();
    }

    @Test
    public void shouldNotFullParseStringWithDot() {
        CollectionId collectionId = CollectionId.parse((String)"rs0.a.b.c");
        Assertions.assertThat((String)collectionId.replicaSetName()).isEqualTo((Object)"rs0");
        Assertions.assertThat((String)collectionId.dbName()).isEqualTo((Object)"a");
        Assertions.assertThat((String)collectionId.name()).isEqualTo((Object)"b.c");
    }

    @Test
    public void shouldNotFullParseStringWithDotAtStart() {
        Assertions.assertThat((Object)CollectionId.parse((String)".rs0.a.b")).isNull();
    }

    @Test
    public void shouldNotParseFullStringWithDotAtEnd() {
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0.")).isNull();
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0.a.")).isNull();
    }

    @Test
    public void shouldNotParseFullStringWithMissingSegment() {
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0")).isNull();
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0.a")).isNull();
        Assertions.assertThat((Object)CollectionId.parse((String)"rs0..a")).isNull();
    }

    protected void assertParseable(String replicaSetName, String dbName, String collectionName) {
        String str = dbName + "." + collectionName;
        this.id = CollectionId.parse((String)replicaSetName, (String)str);
        Assertions.assertThat((String)this.id.replicaSetName()).isEqualTo((Object)replicaSetName);
        Assertions.assertThat((String)this.id.dbName()).isEqualTo((Object)dbName);
        Assertions.assertThat((String)this.id.name()).isEqualTo((Object)collectionName);
    }
}

