/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.util.List;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class TransactionMetadataIT
extends AbstractMongoConnectorIT {
    @Test
    public void transactionMetadata() throws Exception {
        Testing.Print.enable();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbA.c1")).with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.INITIAL)).with(MongoDbConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        if (!TestHelper.transactionsSupported(this.primary(), "mongo1")) {
            return;
        }
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        TransactionMetadataIT.waitForSnapshotToBeCompleted("mongodb", "mongo1");
        List<Document> documentsToInsert = this.loadTestDocuments("restaurants1.json");
        this.insertDocumentsInTx("dbA", "c1", documentsToInsert.toArray(new Document[0]));
        List<Document> documentsToInsert2 = this.loadTestDocuments("restaurants6.json");
        this.insertDocuments("dbA", "c1", documentsToInsert2.toArray(new Document[0]));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8 + (TestHelper.isOplogCaptureMode() ? 1 : 0) + 1);
        List c1s = records.recordsForTopic("mongo1.dbA.c1");
        List txs = records.recordsForTopic("mongo1.transaction");
        Assertions.assertThat((List)c1s).hasSize(7);
        Assertions.assertThat((List)txs).hasSize(TestHelper.isOplogCaptureMode() ? 3 : 2);
        List all = records.allRecordsInOrder();
        String txId1 = this.assertBeginTransaction((SourceRecord)all.get(0));
        long counter = 1L;
        for (int i = 1; i <= 6; ++i) {
            this.assertRecordTransactionMetadata((SourceRecord)all.get(i), txId1, counter, counter);
            ++counter;
        }
        this.assertEndTransaction((SourceRecord)all.get(7), txId1, 6L, Collect.hashMapOf((Object)"rs0.dbA.c1", (Object)6));
        if (TestHelper.isOplogCaptureMode()) {
            String txId2 = this.assertBeginTransaction((SourceRecord)all.get(8));
            this.assertRecordTransactionMetadata((SourceRecord)all.get(9), txId2, 1L, 1L);
        }
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-4077"})
    public void transactionMetadataWithCustomTopicName() throws Exception {
        Testing.Print.enable();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbA.c1")).with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.INITIAL)).with(MongoDbConnectorConfig.PROVIDE_TRANSACTION_METADATA, true)).with(MongoDbConnectorConfig.TRANSACTION_TOPIC, "tx.of.${database.server.name}")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        if (!TestHelper.transactionsSupported(this.primary(), "mongo1")) {
            return;
        }
        this.start(MongoDbConnector.class, this.config);
        this.assertConnectorIsRunning();
        TransactionMetadataIT.waitForSnapshotToBeCompleted("mongodb", "mongo1");
        List<Document> documentsToInsert = this.loadTestDocuments("restaurants1.json");
        this.insertDocumentsInTx("dbA", "c1", documentsToInsert.toArray(new Document[0]));
        List<Document> documentsToInsert2 = this.loadTestDocuments("restaurants6.json");
        this.insertDocuments("dbA", "c1", documentsToInsert2.toArray(new Document[0]));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(8 + (TestHelper.isOplogCaptureMode() ? 1 : 0) + 1);
        List c1s = records.recordsForTopic("mongo1.dbA.c1");
        List txs = records.recordsForTopic("tx.of.mongo1");
        Assertions.assertThat((List)c1s).hasSize(7);
        Assertions.assertThat((List)txs).hasSize(TestHelper.isOplogCaptureMode() ? 3 : 2);
        List all = records.allRecordsInOrder();
        String txId1 = this.assertBeginTransaction((SourceRecord)all.get(0));
        long counter = 1L;
        for (int i = 1; i <= 6; ++i) {
            this.assertRecordTransactionMetadata((SourceRecord)all.get(i), txId1, counter, counter);
            ++counter;
        }
        this.assertEndTransaction((SourceRecord)all.get(7), txId1, 6L, Collect.hashMapOf((Object)"rs0.dbA.c1", (Object)6));
        if (TestHelper.isOplogCaptureMode()) {
            String txId2 = this.assertBeginTransaction((SourceRecord)all.get(8));
            this.assertRecordTransactionMetadata((SourceRecord)all.get(9), txId2, 1L, 1L);
        }
        this.stopConnector();
    }
}

