/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.MongoException;
import com.mongodb.MongoSocketOpenException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.ServerConnectionState;
import com.mongodb.connection.ServerDescription;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSetDiscovery;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.util.Collect;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ReplicaSetDiscoveryTest {
    private ReplicaSetDiscovery replicaSetDiscovery;
    private MongoDbTaskContext context;
    private ConnectionContext connectionContext;
    private MongoClient mongoClient;
    private String seedHosts = "host1:27017,host2:27017";

    @Before
    public void setup() {
        this.context = (MongoDbTaskContext)Mockito.mock(MongoDbTaskContext.class);
        this.connectionContext = (ConnectionContext)Mockito.mock(ConnectionContext.class);
        this.mongoClient = (MongoClient)Mockito.mock(MongoClient.class);
        Mockito.when((Object)this.context.getConnectionContext()).thenReturn((Object)this.connectionContext);
        Mockito.when((Object)this.connectionContext.hosts()).thenReturn((Object)this.seedHosts);
        Mockito.when((Object)this.connectionContext.clientFor(this.seedHosts)).thenReturn((Object)this.mongoClient);
        this.replicaSetDiscovery = new ReplicaSetDiscovery(this.context);
    }

    @Test
    public void shouldGetFirstValidReplicaSetName() {
        Mockito.when((Object)this.mongoClient.listDatabaseNames()).thenThrow(new Throwable[]{new MongoException("dummy")});
        ServerAddress host1Address = new ServerAddress("host1");
        ServerAddress host2Address = new ServerAddress("host2");
        List serverDescriptions = Collect.arrayListOf((Object)ServerDescription.builder().address(host1Address).state(ServerConnectionState.CONNECTING).exception((Throwable)new MongoSocketOpenException("can't connect", host1Address)).build(), (Object[])new ServerDescription[]{ServerDescription.builder().address(host2Address).state(ServerConnectionState.CONNECTED).setName("my_rs").build()});
        ClusterDescription clusterDescription = new ClusterDescription(ClusterConnectionMode.MULTIPLE, ClusterType.REPLICA_SET, serverDescriptions);
        Mockito.when((Object)this.mongoClient.getClusterDescription()).thenReturn((Object)clusterDescription);
        ReplicaSets replicaSets = this.replicaSetDiscovery.getReplicaSets();
        Assertions.assertThat((int)replicaSets.validReplicaSets().size()).isEqualTo(1);
        Assertions.assertThat((String)((ReplicaSet)replicaSets.validReplicaSets().get(0)).replicaSetName()).isEqualTo((Object)"my_rs");
        Assertions.assertThat((List)((ReplicaSet)replicaSets.validReplicaSets().get(0)).addresses()).isEqualTo((Object)Collect.arrayListOf((Object)host2Address, (Object[])new ServerAddress[0]));
    }
}

