/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.SkipForOplogTestRule;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.engine.DebeziumEngine;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;

public class IncrementalSnapshotIT
extends AbstractMongoConnectorIT {
    protected static final int ROW_COUNT = 1000;
    private static final int MAXIMUM_NO_RECORDS_CONSUMES = 3;
    private static final String DATABASE_NAME = "dbA";
    private static final String COLLECTION_NAME = "c1";
    private static final String FULL_COLLECTION_NAME = "dbA.c1";
    private static final String DOCUMENT_ID = "_id";
    protected static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-is.txt").toAbsolutePath();
    @Rule
    public TestRule skipForOplog = new SkipForOplogTestRule();

    @Before
    public void before() {
        this.context = new MongoDbTaskContext(this.config().build());
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
    }

    @After
    public void after() {
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
    }

    protected Class<MongoDbConnector> connectorClass() {
        return MongoDbConnector.class;
    }

    protected Configuration.Builder config() {
        return (Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, DATABASE_NAME)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, this.fullDataCollectionName() + ",dbA.c1,dbA.signals")).with(MongoDbConnectorConfig.SIGNAL_DATA_COLLECTION, "dbA.signals")).with(MongoDbConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 10)).with(MongoDbConnectorConfig.SNAPSHOT_MODE, (EnumeratedValue)MongoDbConnectorConfig.SnapshotMode.NEVER);
    }

    protected String dataCollectionName() {
        return COLLECTION_NAME;
    }

    protected String fullDataCollectionName() {
        return FULL_COLLECTION_NAME;
    }

    protected String topicName() {
        return "mongo1." + this.fullDataCollectionName();
    }

    protected void populateDataCollection(ConnectionContext.MongoPrimary connection, String dataCollectionName) {
        Document[] documents = new Document[1000];
        for (int i = 0; i < 1000; ++i) {
            Document doc = new Document();
            doc.append(DOCUMENT_ID, (Object)(i + 1)).append("aa", (Object)i);
            documents[i] = doc;
        }
        this.insertDocumentsInTx(DATABASE_NAME, dataCollectionName, documents);
    }

    protected void populateDataCollection(ConnectionContext.MongoPrimary connection) {
        this.populateDataCollection(connection, this.dataCollectionName());
    }

    protected void populateDataCollection() {
        this.populateDataCollection(this.primary());
    }

    protected void insertAdditionalData() {
        Document[] documents = new Document[1000];
        for (int i = 0; i < 1000; ++i) {
            Document doc = new Document();
            doc.append(DOCUMENT_ID, (Object)(i + 1000 + 1)).append("aa", (Object)(i + 1000));
            documents[i] = doc;
        }
        this.insertDocumentsInTx(DATABASE_NAME, COLLECTION_NAME, documents);
    }

    protected void updateData(int batchSize) {
        for (int i = 0; i < 1000 / batchSize; ++i) {
            Document gt = new Document();
            gt.append("$gt", (Object)(i * batchSize));
            Document lte = new Document();
            lte.append("$lte", (Object)((i + 1) * batchSize));
            Document filter = new Document();
            filter.append("$and", Arrays.asList(new Document().append(DOCUMENT_ID, (Object)gt), new Document().append(DOCUMENT_ID, (Object)lte)));
            Document update = new Document();
            update.append("$inc", (Object)new Document().append("aa", (Object)2000));
            this.updateDocumentsInTx(DATABASE_NAME, COLLECTION_NAME, filter, update);
        }
    }

    protected void startConnector(DebeziumEngine.CompletionCallback callback) {
        this.startConnector(Function.identity(), callback);
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig) {
        this.startConnector(custConfig, (DebeziumEngine.CompletionCallback)this.loggingCompletion());
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig, DebeziumEngine.CompletionCallback callback) {
        Configuration config = custConfig.apply(this.config()).build();
        this.start(this.connectorClass(), config, callback);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
    }

    protected void startConnector() {
        this.startConnector(Function.identity(), (DebeziumEngine.CompletionCallback)this.loggingCompletion());
    }

    protected void waitForConnectorToStart() {
        this.assertConnectorIsRunning();
    }

    protected void sendAdHocSnapshotSignal(String ... dataCollectionIds) throws SQLException {
        String dataCollectionIdsList = Arrays.stream(dataCollectionIds).map(x -> "\\\"" + x + "\\\"").collect(Collectors.joining(", "));
        this.insertDocuments(DATABASE_NAME, "signals", Document.parse((String)("{\"type\": \"execute-snapshot\", \"payload\": \"{\\\"data-collections\\\": [" + dataCollectionIdsList + "]}\"}")));
    }

    protected void sendAdHocSnapshotSignal() throws SQLException {
        this.sendAdHocSnapshotSignal(this.fullDataCollectionName());
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, this::extractFieldValue, x -> true, null);
    }

    protected Integer extractFieldValue(SourceRecord record) {
        String after = ((Struct)record.value()).getString("after");
        Pattern p = Pattern.compile("\"" + this.valueFieldName() + "\": (\\d+)");
        Matcher m = p.matcher(after);
        m.find();
        return Integer.parseInt(m.group(1));
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Function<SourceRecord, V> valueConverter, Predicate<Map.Entry<Integer, V>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, dataCompleted, k -> Integer.parseInt(k.getString(this.pkFieldName())), valueConverter, this.topicName(), recordConsumer);
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, V>> dataCompleted, Function<Struct, Integer> idCalculator, Function<SourceRecord, V> valueConverter, String topicName, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        HashMap dbChanges = new HashMap();
        int noRecords = 0;
        while (true) {
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List dataRecords = records.recordsForTopic(topicName);
            if (records.allRecordsInOrder().isEmpty()) {
                ((IntAssert)Assertions.assertThat((int)(++noRecords)).describedAs(String.format("Too many no data record results, %d < %d", dbChanges.size(), recordCount))).isLessThanOrEqualTo(3);
                continue;
            }
            noRecords = 0;
            if (dataRecords == null || dataRecords.isEmpty()) continue;
            dataRecords.forEach(record -> {
                int id = (Integer)idCalculator.apply((Struct)record.key());
                Object value = valueConverter.apply((SourceRecord)record);
                dbChanges.put(id, value);
            });
            if (recordConsumer != null) {
                recordConsumer.accept(dataRecords);
            }
            if (dbChanges.size() >= recordCount && !dbChanges.entrySet().stream().anyMatch(dataCompleted.negate())) break;
        }
        Assertions.assertThat(dbChanges).hasSize(recordCount);
        return dbChanges;
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), x -> true, null);
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, Integer>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, this::extractFieldValue, dataCompleted, recordConsumer);
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, SourceRecord>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), dataCompleted, recordConsumer);
    }

    protected String valueFieldName() {
        return "aa";
    }

    protected String pkFieldName() {
        return "id";
    }

    @Test
    public void snapshotOnly() throws Exception {
        this.populateDataCollection();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void invalidTablesInTheList() throws Exception {
        this.populateDataCollection();
        this.startConnector();
        this.sendAdHocSnapshotSignal("dbA.invalid1", this.fullDataCollectionName(), "invalid2");
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void snapshotOnlyWithRestart() throws Exception {
        this.populateDataCollection();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> true, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void inserts() throws Exception {
        this.populateDataCollection();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        this.insertAdditionalData();
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void updates() throws Exception {
        this.populateDataCollection();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        this.updateData(10);
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesWithRestart() throws Exception {
        this.populateDataCollection();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        this.updateData(10);
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesLargeChunk() throws Exception {
        this.populateDataCollection();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1000));
        this.sendAdHocSnapshotSignal();
        this.updateData(1000);
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    protected int getMaximumEnqueuedRecordCount() {
        return 3000;
    }
}

