/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.awaitility.Awaitility;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractMongoConnectorIT
extends AbstractConnectorTest {
    protected Configuration config;
    protected MongoDbTaskContext context;
    protected LogInterceptor logInterceptor;

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            if (this.context != null) {
                this.context.getConnectionContext().shutdown();
            }
        }
    }

    protected List<Document> loadTestDocuments(String pathOnClasspath) {
        ArrayList<Document> documents = new ArrayList<Document>();
        try (InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);){
            Assertions.assertThat((Object)stream).isNotNull();
            IoUtil.readLines((InputStream)stream, line -> {
                Document document = Document.parse((String)line);
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                documents.add(document);
            });
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to find or read file '" + pathOnClasspath + "': " + e.getMessage()));
        }
        return documents;
    }

    protected void dropAndInsertDocuments(String dbName, String collectionName, Document ... documents) {
        if (documents.length == 0) {
            return;
        }
        this.primary().execute("store documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            collection.drop();
            for (Document document : documents) {
                InsertOneOptions options = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                collection.insertOne((Object)document, options);
            }
        });
    }

    protected void insertDocuments(String dbName, String collectionName, Document ... documents) {
        if (documents.length == 0) {
            return;
        }
        this.primary().execute("store documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            for (Document document : documents) {
                InsertOneOptions options = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                collection.insertOne((Object)document, options);
            }
        });
    }

    protected void insertDocumentsInTx(String dbName, String collectionName, Document ... documents) {
        Assertions.assertThat((boolean)TestHelper.transactionsSupported(this.primary(), dbName)).isTrue();
        this.primary().execute("store documents in tx", mongo -> {
            Testing.debug((Object)("Storing documents in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = mongo.getDatabase(dbName);
            if (!AbstractMongoConnectorIT.collectionExists(db, collectionName)) {
                db.createCollection(collectionName);
            }
            MongoCollection collection = db.getCollection(collectionName);
            try (ClientSession session = mongo.startSession();){
                session.startTransaction();
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                for (Document document : documents) {
                    Assertions.assertThat((Map)document).isNotNull();
                    Assertions.assertThat((int)document.size()).isGreaterThan(0);
                    collection.insertOne(session, (Object)document, insertOptions);
                }
                session.commitTransaction();
            }
        });
    }

    protected void updateDocument(String dbName, String collectionName, Document filter, Document document) {
        this.primary().execute("update", mongo -> {
            Testing.debug((Object)("Updating document with filter '" + filter + "' in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            collection.updateOne((Bson)filter, (Bson)document);
        });
    }

    protected void updateDocumentsInTx(String dbName, String collectionName, Document filter, Document document) {
        Assertions.assertThat((boolean)TestHelper.transactionsSupported(this.primary(), dbName)).isTrue();
        this.primary().execute("update documents in tx", mongo -> {
            Testing.debug((Object)("Updating document with filter '" + filter + "' in '" + dbName + "." + collectionName + "'"));
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection collection = db.getCollection(collectionName);
            try (ClientSession session = mongo.startSession();){
                session.startTransaction();
                collection.updateMany((Bson)filter, (Bson)document);
                session.commitTransaction();
            }
        });
    }

    protected void deleteDocuments(String dbName, String collectionName, Document filter) {
        this.primary().execute("delete", mongo -> {
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            coll.deleteOne((Bson)filter);
        });
    }

    protected ConnectionContext.MongoPrimary primary() {
        ReplicaSet replicaSet = ReplicaSet.parse((String)this.context.getConnectionContext().hosts());
        return this.context.getConnectionContext().primaryFor(replicaSet, this.context.filters(), this.connectionErrorHandler(3));
    }

    protected BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            this.logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }

    private static boolean collectionExists(MongoDatabase database, String collectionName) {
        MongoIterable collections = database.listCollectionNames();
        MongoCursor cursor = collections.cursor();
        while (cursor.hasNext()) {
            if (!collectionName.equalsIgnoreCase((String)cursor.next())) continue;
            return true;
        }
        return false;
    }

    protected void storeDocuments(String dbName, String collectionName, String pathOnClasspath) {
        this.primary().execute("storing documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = mongo.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            this.storeDocuments((MongoCollection<Document>)coll, pathOnClasspath);
        });
    }

    protected void storeDocuments(MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            collection.insertOne(doc, insertOptions);
        });
    }

    public static ObjectName getSnapshotMetricsObjectName(String connector, String server) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)"snapshot", (Object)"server", (Object)server));
    }

    public static ObjectName getSnapshotMetricsObjectName(String connector, String server, int taskId) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)"snapshot", (Object)"server", (Object)server, (Object)"task", (Object)String.valueOf(taskId)));
    }

    public static void waitForSnapshotToBeCompleted(String connector, String server) {
        AbstractMongoConnectorIT.waitForSnapshotToBeCompleted(AbstractMongoConnectorIT.getSnapshotMetricsObjectName(connector, server));
    }

    public static void waitForSnapshotToBeCompleted(String connector, String server, int taskId) {
        AbstractMongoConnectorIT.waitForSnapshotToBeCompleted(AbstractMongoConnectorIT.getSnapshotMetricsObjectName(connector, server, taskId));
    }

    public static ObjectName getStreamingMetricsObjectName(String connector, String server) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)AbstractMongoConnectorIT.getStreamingNamespace(), (Object)"server", (Object)server));
    }

    public static ObjectName getStreamingMetricsObjectName(String connector, String server, int taskId) {
        return AbstractMongoConnectorIT.getMetricsObjectNameWithTags(connector, Collect.linkMapOf((Object)"context", (Object)AbstractMongoConnectorIT.getStreamingNamespace(), (Object)"server", (Object)server, (Object)"task", (Object)String.valueOf(taskId)));
    }

    public static void waitForStreamingRunning(String connector, String server) {
        AbstractMongoConnectorIT.waitForStreamingRunning(AbstractMongoConnectorIT.getStreamingMetricsObjectName(connector, server));
    }

    public static void waitForStreamingRunning(String connector, String server, int taskId) {
        AbstractMongoConnectorIT.waitForStreamingRunning(AbstractMongoConnectorIT.getStreamingMetricsObjectName(connector, server, taskId));
    }

    private static void waitForSnapshotToBeCompleted(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Awaitility.await().alias("Streaming was not started on time").pollInterval(100L, TimeUnit.MILLISECONDS).atMost((long)(AbstractMongoConnectorIT.waitTimeForRecords() * 30), TimeUnit.SECONDS).ignoreException(InstanceNotFoundException.class).until(() -> (boolean)((Boolean)mbeanServer.getAttribute(objectName, "SnapshotCompleted")));
    }

    private static void waitForStreamingRunning(ObjectName objectName) {
        MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
        Awaitility.await().alias("Streaming was not started on time").pollInterval(100L, TimeUnit.MILLISECONDS).atMost((long)(AbstractMongoConnectorIT.waitTimeForRecords() * 30), TimeUnit.SECONDS).ignoreException(InstanceNotFoundException.class).until(() -> (boolean)((Boolean)mbeanServer.getAttribute(objectName, "Connected")));
    }

    private static ObjectName getMetricsObjectNameWithTags(String connector, Map<String, String> tags) {
        try {
            return new ObjectName("debezium." + connector + ":type=connector-metrics," + tags.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(",")));
        }
        catch (MalformedObjectNameException e2) {
            throw new RuntimeException(e2);
        }
    }
}

