/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.UpdateOperators;

import io.debezium.connector.mongodb.transforms.UpdateOperators.AbstractExtractNewDocumentStateUpdateOperatorsTestIT;
import io.debezium.data.VerifyRecord;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ExtractNewDocumentStateUpdateBitOperatorTestIT
extends AbstractExtractNewDocumentStateUpdateOperatorsTestIT {
    @Test
    public void shouldTransformOperationBitAnd() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$bit': {dataInt: {and: NumberInt(1010)}}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"_id", (Schema)valueSchema.field("_id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("_id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)114);
    }

    @Test
    public void shouldTransformOperationBitOr() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$bit': {dataInt: {or: NumberInt(1001)}}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"_id", (Schema)valueSchema.field("_id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("_id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)1019);
    }

    @Test
    public void shouldTransformOperationBitXor() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$bit': {dataInt: {xor: NumberInt(111)}}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"_id", (Schema)valueSchema.field("_id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("_id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)20);
    }
}

