/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Objects;

public class ReplicaSetPartition
implements Partition {
    private static final String SERVER_ID_KEY = "server_id";
    private static final String REPLICA_SET_NAME = "rs";
    private final String serverId;
    private final String replicaSetName;

    public ReplicaSetPartition(String serverId, String replicaSetName) {
        this.serverId = serverId;
        this.replicaSetName = replicaSetName;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverId, (Object)REPLICA_SET_NAME, (Object)this.replicaSetName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaSetPartition other = (ReplicaSetPartition)obj;
        return Objects.equals(this.serverId, other.serverId) && Objects.equals(this.replicaSetName, other.replicaSetName);
    }

    public int hashCode() {
        return Objects.hash(this.serverId, this.replicaSetName);
    }

    public String toString() {
        return "ReplicaSetPartition [sourcePartition=" + this.getSourcePartition() + "]";
    }
}

