/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneOptions;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.FieldBlacklistIT;
import io.debezium.connector.mongodb.JsonSerialization;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.fest.assertions.Fail;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class FieldExcludeListIT
extends AbstractConnectorTest {
    private static final String SERVER_NAME = "serverX";
    private static final String PATCH = "patch";
    private Configuration config;
    private MongoDbTaskContext context;

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            if (this.context != null) {
                this.context.getConnectionContext().shutdown();
            }
        }
    }

    @Test
    public void shouldNotExcludeFieldsForEventOfOtherCollection() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c2.name,*.c2.active", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertReadRecord("*.c1.name,*.c1.active", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c1.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertReadRecord("*.c1.name,*.c1.active,*.c1.address.number", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForReadEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertReadRecord("*.c1.address.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("*.c1.name,*.c1.active", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeMissingFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertInsertRecord("*.c1.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeNestedFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"scores\": [1.2,3.4,5.6]}";
        this.assertInsertRecord("*.c1.name,*.c1.active,*.c1.address.number", obj, "after", expected);
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForInsertEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertInsertRecord("*.c1.address.missing", obj, "after", obj.toJson(JsonSerialization.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldExcludeFieldsForUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("phone", (Object)123L).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.active", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeMissingFieldsForUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("phone", (Object)123L).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"phone\": {\"$numberLong\": \"123\"}, \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.missing", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)35L).append("street", (Object)"Claude Debussylaane").append("city", (Object)"Amsterdame")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},\"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.active,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeNestedMissingFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"address\": {\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"number\": {\"$numberLong\": \"34\"}, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},\"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"address\": {\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.address.missing", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"address\": {\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally Mae").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athenss")))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String patch = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{\"active\": true, \"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"active\": true, \"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123, \"scores\": [1.2, 3.4, 5.6]}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetTopLevelFieldUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L);
        String patch = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}}";
        String updated = "{\"phone\": 123}";
        this.assertUpdateRecord("*.c1.name", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeFieldsForUnsetTopLevelFieldUpdateEvent() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("phone", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"phone\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.name", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("phone")));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"));
        String patch = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}}";
        String updated = "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, \"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")));
        String patch = "{\"$v\": 1,\"$set\": {\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}],\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]}";
        String updated = "{\"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}, {\"street\": \"Fragkokklisias\", \"city\": \"Athens\"}], \"phone\": 123}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))));
        String patch = "{\"$v\": 1,\"$set\": {\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"}}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]]}";
        String updated = "{\"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123}";
        this.assertUpdateRecord("*.c1.name,*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses\": [[{\"number\": 34, \"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}], [{\"number\": 7, \"street\": \"Fragkokklisias\", \"city\": \"Athens\"}]], \"phone\": 123}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("name", (Object)"Sally").append("address.number", (Object)34L).append("address.street", (Object)"Claude Debussylaan").append("address.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"address.city\": \"Amsterdam\",\"address.street\": \"Claude Debussylaan\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"456\"}, \"address\": {\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}}";
        String updated = "{\"address.city\": \"Amsterdam\", \"address.street\": \"Claude Debussylaan\"}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"address.city\": \"Amsterdam\", \"address.street\": \"Claude Debussylaan\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.city\": \"Amsterdam\",\"addresses.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}]}";
        String updated = "{\"addresses.0.city\": \"Amsterdam\", \"addresses.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.city\": \"Amsterdam\", \"addresses.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForSetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.0.city\": \"Amsterdam\",\"addresses.0.0.number\": {\"$numberLong\": \"34\"},\"addresses.0.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"8\"},\"street\": \"Fragkokklisiass\",\"city\": \"Athense\"}]]}";
        String updated = "{\"addresses.0.0.city\": \"Amsterdam\", \"addresses.0.0.number\": 34, \"addresses.0.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.0.city\": \"Amsterdam\", \"addresses.0.0.number\": 34, \"addresses.0.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForSetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonMap("second", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")))));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.second.0.number", (Object)34L).append("addresses.0.second.0.street", (Object)"Claude Debussylaan").append("addresses.0.second.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"addresses.0.second.0.city\": \"Amsterdam\",\"addresses.0.second.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\", \"addresses\": [{\"second\": [{\"street\": \"Claude Debussylaan\", \"city\": \"Amsterdam\"}]}]}";
        String updated = "{\"addresses.0.second.0.city\": \"Amsterdam\", \"addresses.0.second.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses.second.number", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"addresses.0.second.0.city\": \"Amsterdam\", \"addresses.0.second.0.street\": \"Claude Debussylaan\", \"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam");
        String patch = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\"}";
        String updated = "{\"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeFieldsForSetToArrayFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"));
        String patch = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\"}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"name\": \"Sally\"}";
        String updated = "{\"name\": \"Sally\"}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{\"name\": \"Sally\"}", null));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("name", (Object)"").append("address.number", (Object)"").append("address.street", (Object)"").append("address.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"address.city\": true,\"address.street\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"456\"}, \"address\": {}, \"active\": false, \"scores\": [1.2, 3.4, 5.6, 7.8]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.name,*.c1.address.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("address.city", "address.street")));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.city\": true,\"addresses.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [{},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.city", "addresses.0.street", "name")));
    }

    @Test
    public void shouldNotExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.0.number", (Object)"").append("addresses.0.0.street", (Object)"").append("addresses.0.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.0.city\": true,\"addresses.0.0.number\": true,\"addresses.0.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"phone\": {\"$numberLong\": \"123\"}, \"addresses\": [[{}]], \"active\": true, \"scores\": [1.2, 3.4, 5.6]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.0.city", "addresses.0.0.number", "addresses.0.0.street", "name")));
    }

    @Test
    public void shouldExcludeNestedFieldsForUnsetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("addresses", Arrays.asList(Collections.singletonMap("second", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")))));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.second.0.number", (Object)"").append("addresses.0.second.0.street", (Object)"").append("addresses.0.second.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"addresses.0.second.0.city\": true,\"addresses.0.second.0.street\": true,\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}, \"addresses\": [{\"second\": [{}]}]}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses.second.number", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("addresses.0.second.0.city", "addresses.0.second.0.street", "name")));
    }

    @Test
    public void shouldExcludeFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)"");
        String patch = "{\"$v\": 1,\"$unset\": {\"name\": true}}";
        String full = "{\"_id\": {\"$oid\": \"<OID>\"}}";
        String updated = "{}";
        this.assertUpdateRecord("*.c1.addresses", objId, obj, updateObj, false, this.updateField(), new FieldBlacklistIT.ExpectedUpdate(patch, full, "{}", Arrays.asList("name")));
    }

    @Test
    public void shouldExcludeFieldsForDeleteEvent() throws InterruptedException {
        this.config = this.getConfiguration("*.c1.name,*.c1.active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        this.storeDocuments("dbA", "c1", obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.deleteDocuments("dbA", "c1", objId);
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        String json = value.getString("after");
        if (json == null) {
            json = value.getString(PATCH);
        }
        Assertions.assertThat((String)json).isNull();
    }

    @Test
    public void shouldExcludeFieldsForDeleteTombstoneEvent() throws InterruptedException {
        this.config = this.getConfiguration("*.c1.name,*.c1.active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        this.storeDocuments("dbA", "c1", obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.deleteDocuments("dbA", "c1", objId);
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(1);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value).isNull();
    }

    private Configuration getConfiguration(String blackList) {
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, blackList)).with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, "dbA.c1")).with(MongoDbConnectorConfig.LOGICAL_NAME, SERVER_NAME)).build();
    }

    private Struct getValue(SourceRecord record) {
        return (Struct)record.value();
    }

    private BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Fail.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            this.logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }

    private ConnectionContext.MongoPrimary primary() {
        ReplicaSet replicaSet = ReplicaSet.parse((String)this.context.getConnectionContext().hosts());
        return this.context.getConnectionContext().primaryFor(replicaSet, this.context.filters(), this.connectionErrorHandler(3));
    }

    private void storeDocuments(String dbName, String collectionName, Document ... documents) {
        this.primary().execute("store documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' document"));
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            coll.drop();
            for (Document document : documents) {
                InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
                Assertions.assertThat((Map)document).isNotNull();
                Assertions.assertThat((int)document.size()).isGreaterThan(0);
                coll.insertOne((Object)document, insertOptions);
            }
        });
    }

    private void updateDocuments(String dbName, String collectionName, ObjectId objId, Document document, boolean doSet) {
        this.primary().execute("update", mongo -> {
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            Document filter = Document.parse((String)("{\"_id\": {\"$oid\": \"" + objId + "\"}}"));
            coll.updateOne((Bson)filter, (Bson)new Document().append(doSet ? "$set" : "$unset", (Object)document));
        });
    }

    private void deleteDocuments(String dbName, String collectionName, ObjectId objId) {
        this.primary().execute("delete", mongo -> {
            MongoDatabase db = mongo.getDatabase(dbName);
            MongoCollection coll = db.getCollection(collectionName);
            Document filter = Document.parse((String)("{\"_id\": {\"$oid\": \"" + objId + "\"}}"));
            coll.deleteOne((Bson)filter);
        });
    }

    private void assertReadRecord(String blackList, Document snapshotRecord, String field, String expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        this.storeDocuments("dbA", "c1", snapshotRecord);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)snapshotRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value.get(field)).isEqualTo((Object)expected);
    }

    private void assertInsertRecord(String blackList, Document insertRecord, String field, String expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        this.start(MongoDbConnector.class, this.config);
        FieldExcludeListIT.waitForSnapshotToBeCompleted((String)"mongodb", (String)SERVER_NAME);
        this.storeDocuments("dbA", "c1", insertRecord);
        AbstractConnectorTest.SourceRecords insertRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)insertRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)insertRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)insertRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        Assertions.assertThat((Object)value.get(field)).isEqualTo((Object)expected);
    }

    private void assertUpdateRecord(String blackList, ObjectId objectId, Document snapshotRecord, Document updateRecord, String field, FieldBlacklistIT.ExpectedUpdate expected) throws InterruptedException {
        this.assertUpdateRecord(blackList, objectId, snapshotRecord, updateRecord, true, field, expected);
    }

    private void assertUpdateRecord(String blackList, ObjectId objectId, Document snapshotRecord, Document updateRecord, boolean doSet, String field, FieldBlacklistIT.ExpectedUpdate expected) throws InterruptedException {
        this.config = this.getConfiguration(blackList);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbA");
        this.storeDocuments("dbA", "c1", snapshotRecord);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldExcludeListIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.updateDocuments("dbA", "c1", objectId, updateRecord, doSet);
        AbstractConnectorTest.SourceRecords updateRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)updateRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)updateRecords.allRecordsInOrder().size()).isEqualTo(1);
        SourceRecord record = (SourceRecord)updateRecords.allRecordsInOrder().get(0);
        Struct value = this.getValue(record);
        if (TestHelper.isOplogCaptureMode()) {
            Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected.patch);
            Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(field));
            Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
        } else {
            TestHelper.assertChangeStreamUpdateAsDocs(objectId, value, expected.full, expected.removedFields, expected.updatedFields);
        }
    }

    private String updateField() {
        return TestHelper.isOplogCaptureMode() ? PATCH : "after";
    }
}

