/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.converters;

import io.debezium.converters.spi.RecordParser;
import io.debezium.util.Collect;
import java.util.Set;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.DataException;

public class MongoDbRecordParser
extends RecordParser {
    static final String REPLICA_SET_NAME = "rs";
    static final String ORDER = "ord";
    static final String OPERATION_ID = "h";
    static final String COLLECTION = "collection";
    static final Set<String> MONGODB_SOURCE_FIELD = Collect.unmodifiableSet((Object[])new String[]{"rs", "ord", "h", "collection"});

    public MongoDbRecordParser(Schema schema, Struct record) {
        super(schema, record, new String[]{"after", "patch", "filter"});
    }

    public Object getMetadata(String name) {
        if (SOURCE_FIELDS.contains(name)) {
            return this.source().get(name);
        }
        if (MONGODB_SOURCE_FIELD.contains(name)) {
            return this.source().get(name);
        }
        throw new DataException("No such field \"" + name + "\" in the \"source\" field of events from MongoDB connector");
    }
}

