/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.UpdateOperators;

import com.mongodb.client.MongoClient;
import com.mongodb.client.model.UpdateOptions;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.transforms.UpdateOperators.AbstractExtractNewDocumentStateUpdateOperatorsTestIT;
import io.debezium.data.VerifyRecord;
import java.util.function.Consumer;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ExtractNewDocumentStateUpdateFieldOperatorTestIT
extends AbstractExtractNewDocumentStateUpdateOperatorsTestIT {
    @Test
    public void shouldTransformOperationInc() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$inc': {'dataInt': 123, 'nested.dataInt': -23}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)246);
        if (TestHelper.isOplogCaptureMode()) {
            VerifyRecord.assertConnectSchemasAreEqual((String)"nested.dataInt", (Schema)valueSchema.field("nested.dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.get("nested.dataInt")).isEqualTo((Object)100);
        } else {
            VerifyRecord.assertConnectSchemasAreEqual((String)"nested.dataInt", (Schema)valueSchema.field("nested").schema().field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.getStruct("nested").get("dataInt")).isEqualTo((Object)100);
        }
    }

    @Test
    public void shouldTransformOperationMin() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$min': {'dataInt': 122, 'nested.dataInt': 124}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)122);
        if (TestHelper.isOplogCaptureMode()) {
            Assertions.assertThat((Object)valueSchema.field("nested.dataInt")).isNull();
        } else {
            Assertions.assertThat((Object)transformedUpdateValue.getStruct("nested").get("dataInt")).isEqualTo((Object)123);
        }
    }

    @Test
    public void shouldTransformOperationMax() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$max': {'dataInt': 122, 'nested.dataInt': 124}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        if (TestHelper.isOplogCaptureMode()) {
            Assertions.assertThat((Object)valueSchema.field("dataInt")).isNull();
            VerifyRecord.assertConnectSchemasAreEqual((String)"nested.dataInt", (Schema)valueSchema.field("nested.dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.get("nested.dataInt")).isEqualTo((Object)124);
        } else {
            Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)123);
            Assertions.assertThat((Object)transformedUpdateValue.getStruct("nested").get("dataInt")).isEqualTo((Object)124);
        }
    }

    @Test
    public void shouldTransformOperationMul() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$mul': {'dataInt': 3, 'nested.dataInt': 2, 'nonExistentField': 123}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"nonExistentField", (Schema)valueSchema.field("nonExistentField").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isEqualTo((Object)369);
        Assertions.assertThat((Object)transformedUpdateValue.get("nonExistentField")).isEqualTo((Object)0);
        if (TestHelper.isOplogCaptureMode()) {
            VerifyRecord.assertConnectSchemasAreEqual((String)"nested.dataInt", (Schema)valueSchema.field("nested.dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.get("nested.dataInt")).isEqualTo((Object)246);
        } else {
            VerifyRecord.assertConnectSchemasAreEqual((String)"nested.dataInt", (Schema)valueSchema.field("nested").schema().field("dataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.getStruct("nested").get("dataInt")).isEqualTo((Object)246);
        }
    }

    @Test
    public void shouldTransformOperationRename() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$rename': {'dataInt': 'dataIntNewName', 'nonExistentField': 'nonExistentFieldRenamed'}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataIntNewName", (Schema)valueSchema.field("dataIntNewName").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataIntNewName")).isEqualTo((Object)123);
        if (TestHelper.isOplogCaptureMode()) {
            VerifyRecord.assertConnectSchemasAreEqual((String)"dataInt", (Schema)valueSchema.field("dataInt").schema(), (Schema)Schema.OPTIONAL_STRING_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.get("dataInt")).isNull();
        } else {
            Assertions.assertThat((Object)valueSchema.field("dataInt")).isNull();
        }
    }

    @Test
    public void shouldTransformOperationSet() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$set': {'dataStr': 'Setting new value', 'newDataInt': 456}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataStr", (Schema)valueSchema.field("dataStr").schema(), (Schema)Schema.OPTIONAL_STRING_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"newDataInt", (Schema)valueSchema.field("newDataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataStr")).isEqualTo((Object)"Setting new value");
        Assertions.assertThat((Object)transformedUpdateValue.get("newDataInt")).isEqualTo((Object)456);
    }

    @Test
    public void shouldTransformOperationSetOnInsert() throws InterruptedException {
        Document setOnInsert = Document.parse((String)"{'$setOnInsert': {'onlySetIfInsertDataInt': 789}}");
        UpdateOptions updateOptions = new UpdateOptions();
        updateOptions.upsert(true);
        Consumer<MongoClient> upsert = arg_0 -> this.lambda$shouldTransformOperationSetOnInsert$0((Bson)setOnInsert, updateOptions, arg_0);
        this.primary().execute("update", upsert);
        SourceRecord upsertRecord = (SourceRecord)this.consumeRecordsByTopic(1).recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedUpsert = (SourceRecord)this.transformation.apply((ConnectRecord)upsertRecord);
        Struct transformedUpsertValue = (Struct)transformedUpsert.value();
        Schema upsertValueSchema = transformedUpsert.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)upsertValueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"onlySetIfInsertDataInt", (Schema)upsertValueSchema.field("onlySetIfInsertDataInt").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpsertValue.get("id")).isEqualTo((Object)2);
        Assertions.assertThat((Object)transformedUpsertValue.get("onlySetIfInsertDataInt")).isEqualTo((Object)789);
        Document setOnInsertAndSet = Document.parse((String)"{'$setOnInsert': {'onlySetIfInsertDataInt': 123}, '$set': {'newField': 456}}");
        Consumer<MongoClient> upsertAndUpdate = arg_0 -> this.lambda$shouldTransformOperationSetOnInsert$1((Bson)setOnInsertAndSet, updateOptions, arg_0);
        this.primary().execute("update", upsertAndUpdate);
        SourceRecord updateRecord = this.getUpdateRecord();
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema updateValueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)updateValueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"newField", (Schema)updateValueSchema.field("newField").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)2);
        Assertions.assertThat((Object)transformedUpdateValue.get("newField")).isEqualTo((Object)456);
        if (TestHelper.isOplogCaptureMode()) {
            Assertions.assertThat((Object)updateValueSchema.field("onlySetIfInsertDataInt")).isNull();
        } else {
            Assertions.assertThat((Object)transformedUpdateValue.get("onlySetIfInsertDataInt")).isEqualTo((Object)789);
        }
    }

    @Test
    public void shouldTransformOperationUnset() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$unset': {'dataStr': '', 'nonExistentField': ''}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        if (TestHelper.isOplogCaptureMode()) {
            VerifyRecord.assertConnectSchemasAreEqual((String)"dataStr", (Schema)valueSchema.field("dataStr").schema(), (Schema)Schema.OPTIONAL_STRING_SCHEMA);
            Assertions.assertThat((Object)transformedUpdateValue.get("dataStr")).isNull();
        } else {
            Assertions.assertThat((Object)valueSchema.field("dataStr")).isNull();
        }
        Assertions.assertThat((Object)valueSchema.field("nonExistentField")).isNull();
    }

    private /* synthetic */ void lambda$shouldTransformOperationSetOnInsert$1(Bson setOnInsertAndSet, UpdateOptions updateOptions, MongoClient client) {
        client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)Document.parse((String)"{'_id' : 2}"), setOnInsertAndSet, updateOptions);
    }

    private /* synthetic */ void lambda$shouldTransformOperationSetOnInsert$0(Bson setOnInsert, UpdateOptions updateOptions, MongoClient client) {
        client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)Document.parse((String)"{'_id' : 2}"), setOnInsert, updateOptions);
    }
}

