/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.TruncatedArray;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.BsonDocument;
import org.bson.Document;

public class MongoDbCollectionSchema
implements DataCollectionSchema {
    private final CollectionId id;
    private final FieldSelector.FieldFilter fieldFilter;
    private final Schema keySchema;
    private final Envelope enveopeSchema;
    private final Schema valueSchema;
    private final Function<Document, Object> keyGeneratorOplog;
    private final Function<BsonDocument, Object> keyGeneratorChangeStream;
    private final Function<Document, String> valueGenerator;

    public MongoDbCollectionSchema(CollectionId id, FieldSelector.FieldFilter fieldFilter, Schema keySchema, Function<Document, Object> keyGenerator, Function<BsonDocument, Object> keyGeneratorChangeStream, Envelope envelopeSchema, Schema valueSchema, Function<Document, String> valueGenerator) {
        this.id = id;
        this.fieldFilter = fieldFilter;
        this.keySchema = keySchema;
        this.enveopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGeneratorOplog = keyGenerator != null ? keyGenerator : Document2 -> null;
        this.keyGeneratorChangeStream = keyGeneratorChangeStream != null ? keyGeneratorChangeStream : BsonDocument2 -> null;
        this.valueGenerator = valueGenerator != null ? valueGenerator : Document2 -> null;
    }

    public DataCollectionId id() {
        return this.id;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Envelope getEnvelopeSchema() {
        return this.enveopeSchema;
    }

    public Struct keyFromDocument(Document document) {
        return document == null ? null : new Struct(this.keySchema).put("id", this.keyGeneratorOplog.apply(document));
    }

    public Struct keyFromDocument(BsonDocument document) {
        return document == null ? null : new Struct(this.keySchema).put("id", this.keyGeneratorChangeStream.apply(document));
    }

    public Struct valueFromDocumentOplog(Document document, Document filter, Envelope.Operation operation) {
        Struct value = new Struct(this.valueSchema);
        switch (operation) {
            case READ: 
            case CREATE: {
                String jsonStr = this.valueGenerator.apply(this.fieldFilter.apply(document));
                value.put("after", (Object)jsonStr);
                break;
            }
            case UPDATE: {
                String patchStr = this.valueGenerator.apply(this.fieldFilter.apply(document));
                value.put("patch", (Object)patchStr);
                String updateFilterStr = this.valueGenerator.apply(this.fieldFilter.apply(filter));
                value.put("filter", (Object)updateFilterStr);
                break;
            }
            case DELETE: {
                String deleteFilterStr = this.valueGenerator.apply(this.fieldFilter.apply(filter));
                value.put("filter", (Object)deleteFilterStr);
            }
        }
        return value;
    }

    public Struct valueFromDocumentChangeStream(ChangeStreamDocument<Document> document, Envelope.Operation operation) {
        Struct value = new Struct(this.valueSchema);
        switch (operation) {
            case CREATE: {
                String jsonStr = this.valueGenerator.apply(this.fieldFilter.apply((Document)document.getFullDocument()));
                value.put("after", (Object)jsonStr);
                break;
            }
            case UPDATE: {
                List truncatedArrays;
                BsonDocument updatedFields;
                if (document.getFullDocument() != null) {
                    String fullDocStr = this.valueGenerator.apply(this.fieldFilter.apply((Document)document.getFullDocument()));
                    value.put("after", (Object)fullDocStr);
                }
                if (document.getUpdateDescription() == null) break;
                Struct updateDescription = new Struct(MongoDbSchema.UPDATED_DESCRIPTION_SCHEMA);
                List removedFields = document.getUpdateDescription().getRemovedFields();
                if (removedFields != null && !removedFields.isEmpty() && !(removedFields = removedFields.stream().map(x -> this.fieldFilter.apply((String)x)).filter(x -> x != null).collect(Collectors.toList())).isEmpty()) {
                    updateDescription.put("removedFields", removedFields);
                }
                if ((updatedFields = document.getUpdateDescription().getUpdatedFields()) != null) {
                    updateDescription.put("updatedFields", (Object)this.fieldFilter.applyChange(updatedFields).toJson());
                }
                if ((truncatedArrays = document.getUpdateDescription().getTruncatedArrays()) != null && !truncatedArrays.isEmpty() && !(truncatedArrays = truncatedArrays.stream().map(x -> new TruncatedArray(this.fieldFilter.apply(x.getField()), x.getNewSize())).filter(x -> x.getField() != null).collect(Collectors.toList())).isEmpty()) {
                    updateDescription.put("truncatedArrays", truncatedArrays.stream().map(x -> {
                        Struct element = new Struct(MongoDbSchema.TRUNCATED_ARRAY_SCHEMA);
                        element.put("field", (Object)x.getField());
                        element.put("size", (Object)x.getNewSize());
                        return element;
                    }).collect(Collectors.toList()));
                }
                value.put("updateDescription", (Object)updateDescription);
                break;
            }
        }
        return value;
    }

    public int hashCode() {
        return this.valueSchema().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MongoDbCollectionSchema) {
            MongoDbCollectionSchema that = (MongoDbCollectionSchema)obj;
            return Objects.equals(this.keySchema(), that.keySchema()) && Objects.equals(this.valueSchema(), that.valueSchema());
        }
        return false;
    }

    public String toString() {
        return "{ key : " + SchemaUtil.asString((Schema)this.keySchema()) + ", value : " + SchemaUtil.asString((Schema)this.valueSchema()) + " }";
    }
}

