/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.bson.Document;

@ThreadSafe
public final class FieldSelector {
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final Pattern COLON = Pattern.compile(":");
    private final List<Path> paths;

    private FieldSelector(List<Path> paths) {
        this.paths = paths;
    }

    public static FieldSelectorBuilder builder() {
        return new FieldSelectorBuilder();
    }

    public FieldFilter fieldFilterFor(CollectionId id) {
        if (!this.paths.isEmpty()) {
            String namespace = id.namespace();
            List pathsApplyingToCollection = this.paths.stream().filter(path -> path.matches(namespace)).collect(Collectors.toList());
            if (pathsApplyingToCollection.size() == 1) {
                return doc -> {
                    Document setDoc = (Document)doc.get((Object)"$set", Document.class);
                    Document unsetDoc = (Document)doc.get((Object)"$unset", Document.class);
                    ((Path)pathsApplyingToCollection.get(0)).modify(doc, setDoc, unsetDoc);
                    return doc;
                };
            }
            if (pathsApplyingToCollection.size() > 1) {
                return doc -> {
                    Document setDoc = (Document)doc.get((Object)"$set", Document.class);
                    Document unsetDoc = (Document)doc.get((Object)"$unset", Document.class);
                    pathsApplyingToCollection.forEach(path -> path.modify(doc, setDoc, unsetDoc));
                    return doc;
                };
            }
        }
        return doc -> doc;
    }

    @ThreadSafe
    private static final class RenamePath
    extends Path {
        private final String newFieldNode;
        private final String newField;

        private RenamePath(Pattern namespacePattern, String[] oldFieldNodes, String newFieldNode) {
            super(namespacePattern, oldFieldNodes);
            this.newFieldNode = newFieldNode;
            this.newField = this.replaceLastNameNode(oldFieldNodes, newFieldNode);
        }

        @Override
        void modifyField(Document doc, String field) {
            if (!doc.containsKey((Object)field)) {
                return;
            }
            doc.put(this.checkFieldExists(doc, this.newFieldNode), doc.remove((Object)field));
        }

        @Override
        void modifyFieldWithDotNotation(Document doc, String field) {
            if (!doc.containsKey((Object)field)) {
                return;
            }
            doc.put(this.checkFieldExists(doc, this.newField), doc.remove((Object)field));
        }

        @Override
        FieldNameAndValue generateNewFieldName(String[] fieldNodes, Object value) {
            String newField = this.rename(fieldNodes);
            return new FieldNameAndValue(newField, value);
        }

        private String replaceLastNameNode(String[] nameNodes, String lastNameNode) {
            if (nameNodes.length > 1) {
                StringJoiner newName = new StringJoiner(".");
                int replaceIndex = nameNodes.length - 1;
                for (int i = 0; i < nameNodes.length; ++i) {
                    newName.add(i == replaceIndex ? lastNameNode : nameNodes[i]);
                }
                return newName.toString();
            }
            return lastNameNode;
        }

        private String rename(String[] nameNodes) {
            StringJoiner newName = new StringJoiner(".");
            int replaceIndex = this.fieldNodes.length - 1;
            int i = 0;
            for (String nameNode : nameNodes) {
                if (Strings.isNumeric((String)nameNode)) {
                    newName.add(nameNode);
                    continue;
                }
                newName.add(i == replaceIndex ? this.newFieldNode : nameNode);
                ++i;
            }
            return newName.toString();
        }
    }

    @ThreadSafe
    private static final class RemovePath
    extends Path {
        private RemovePath(Pattern namespacePattern, String[] fieldNodes) {
            super(namespacePattern, fieldNodes);
        }

        @Override
        void modifyField(Document doc, String field) {
            doc.remove((Object)field);
        }

        @Override
        void modifyFieldWithDotNotation(Document doc, String field) {
            doc.remove((Object)field);
        }

        @Override
        FieldNameAndValue generateNewFieldName(String[] fieldNodes, Object value) {
            return null;
        }
    }

    @ThreadSafe
    private static abstract class Path {
        final Pattern namespacePattern;
        final String[] fieldNodes;
        final String field;

        private Path(Pattern namespacePattern, String[] fieldNodes) {
            this.namespacePattern = namespacePattern;
            this.fieldNodes = fieldNodes;
            StringJoiner field = new StringJoiner(".");
            Arrays.stream(fieldNodes).forEach(field::add);
            this.field = field.toString();
        }

        public boolean matches(String namespace) {
            return this.namespacePattern.matcher(namespace).matches();
        }

        public void modify(Document doc, Document setDoc, Document unsetDoc) {
            if (setDoc == null && unsetDoc == null) {
                this.modifyFields(doc, this.fieldNodes, 0);
            } else {
                if (setDoc != null) {
                    this.modifyFieldsWithDotNotation(setDoc);
                }
                if (unsetDoc != null) {
                    this.modifyFieldsWithDotNotation(unsetDoc);
                }
            }
        }

        private void modifyFields(Document doc, String[] nodes, int beginIndex) {
            Document current = doc;
            int stopIndex = nodes.length - 1;
            for (int i = beginIndex; i < nodes.length; ++i) {
                String node = nodes[i];
                if (i == stopIndex) {
                    this.modifyField(current, node);
                    break;
                }
                Object next = current.get((Object)node);
                if (!(next instanceof Document)) {
                    this.modifyFields(next, nodes, i + 1);
                    break;
                }
                current = (Document)next;
            }
        }

        private void modifyFieldsWithDotNotation(Document doc) {
            if (doc.containsKey((Object)this.field)) {
                this.modifyFieldWithDotNotation(doc, this.field);
                return;
            }
            List<FieldNameAndValue> newFields = null;
            Iterator it = doc.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry2 = (Map.Entry)it.next();
                String[] originKeyNodes = DOT.split((CharSequence)entry2.getKey());
                Object[] keyNodes = this.excludeNumericItems(originKeyNodes);
                if (keyNodes.length > this.fieldNodes.length) {
                    if (!this.startsWith(this.fieldNodes, (String[])keyNodes)) continue;
                    newFields = this.add(newFields, this.generateNewFieldName(originKeyNodes, entry2.getValue()));
                    it.remove();
                    continue;
                }
                if (keyNodes.length < this.fieldNodes.length) {
                    if (!this.startsWith((String[])keyNodes, this.fieldNodes)) continue;
                    Object value = entry2.getValue();
                    if (value instanceof Document) {
                        this.modifyFields((Document)value, this.fieldNodes, keyNodes.length);
                        break;
                    }
                    this.modifyFields(value, this.fieldNodes, keyNodes.length);
                    break;
                }
                if (!Arrays.equals(keyNodes, this.fieldNodes)) continue;
                newFields = this.add(newFields, this.generateNewFieldName(originKeyNodes, entry2.getValue()));
                it.remove();
            }
            if (newFields != null) {
                newFields.forEach(entry -> doc.put(this.checkFieldExists(doc, ((FieldNameAndValue)entry).key), ((FieldNameAndValue)entry).value));
            }
        }

        private void modifyFields(Object value, String[] fieldNodes, int length) {
            if (value instanceof List) {
                for (Object item : (List)value) {
                    if (!(item instanceof Document)) continue;
                    this.modifyFields((Document)item, fieldNodes, length);
                }
            }
        }

        private String[] excludeNumericItems(String[] items) {
            if (items.length > 1) {
                ArrayList<String> newItems = null;
                boolean previousNumerical = false;
                int offset = 0;
                for (int i = 0; i < items.length; ++i) {
                    if (Strings.isNumeric((String)items[i])) {
                        if (previousNumerical) {
                            return items;
                        }
                        previousNumerical = true;
                        if (newItems == null) {
                            newItems = new ArrayList<String>(Arrays.asList(items));
                        }
                        newItems.remove(i - offset++);
                        continue;
                    }
                    previousNumerical = false;
                }
                if (newItems != null) {
                    return newItems.toArray(new String[newItems.size()]);
                }
            }
            return items;
        }

        private boolean startsWith(String[] begin, String[] source) {
            if (begin.length > source.length) {
                return false;
            }
            for (int i = 0; i < begin.length; ++i) {
                if (source[i].equals(begin[i])) continue;
                return false;
            }
            return true;
        }

        private <T> List<T> add(List<T> list, T element) {
            if (element != null) {
                if (list == null) {
                    list = new ArrayList<T>();
                }
                list.add(element);
            }
            return list;
        }

        String checkFieldExists(Document doc, String field) {
            if (doc.containsKey((Object)field)) {
                throw new IllegalArgumentException("Document already contains field : " + field);
            }
            return field;
        }

        abstract void modifyField(Document var1, String var2);

        abstract void modifyFieldWithDotNotation(Document var1, String var2);

        abstract FieldNameAndValue generateNewFieldName(String[] var1, Object var2);

        public String toString() {
            return this.field;
        }
    }

    private static final class FieldNameAndValue {
        private final String key;
        private final Object value;

        private FieldNameAndValue(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class FieldSelectorBuilder {
        private String fullyQualifiedFieldNames;
        private String fullyQualifiedFieldReplacements;

        private FieldSelectorBuilder() {
        }

        public FieldSelectorBuilder excludeFields(String fullyQualifiedFieldNames) {
            this.fullyQualifiedFieldNames = fullyQualifiedFieldNames;
            return this;
        }

        public FieldSelectorBuilder renameFields(String fullyQualifiedFieldReplacements) {
            this.fullyQualifiedFieldReplacements = fullyQualifiedFieldReplacements;
            return this;
        }

        public FieldSelector build() {
            ArrayList<Path> result = new ArrayList<Path>();
            this.parse(this.fullyQualifiedFieldNames, name -> {
                String[] nameNodes = this.parseIntoParts((String)name, (String)name, length -> length < 3, DOT);
                return new RemovePath(this.selectNamespacePartAsPattern(nameNodes), this.selectFieldPartAsNodes(nameNodes));
            }, result);
            this.parse(this.fullyQualifiedFieldReplacements, name -> {
                String[] replacement = this.parseIntoParts((String)name, (String)name, length -> length != 2, COLON);
                String[] nameNodes = this.parseIntoParts((String)name, replacement[0], length -> length < 3, DOT);
                return new RenamePath(this.selectNamespacePartAsPattern(nameNodes), this.selectFieldPartAsNodes(nameNodes), replacement[1]);
            }, result);
            return new FieldSelector(result);
        }

        private void parse(String value, Function<String, Path> pathCreator, List<Path> result) {
            if (!Strings.isNullOrEmpty((String)value)) {
                Arrays.stream(value.trim().split(",")).forEach(name -> result.add((Path)pathCreator.apply((String)name)));
            }
        }

        private String[] parseIntoParts(String name, String value, Predicate<Integer> lengthPredicate, Pattern delimiterPattern) {
            String[] nodes = delimiterPattern.split(value.trim());
            if (lengthPredicate.test(nodes.length) || Arrays.stream(nodes).anyMatch(Strings::isNullOrEmpty)) {
                throw new ConfigException("Invalid format: " + name);
            }
            return nodes;
        }

        private Pattern selectNamespacePartAsPattern(String[] expressionNodes) {
            String databaseName = expressionNodes[0];
            String collectionName = expressionNodes[1];
            String namespaceRegex = this.toRegex(databaseName) + "\\." + this.toRegex(collectionName);
            return Pattern.compile(namespaceRegex.trim(), 2);
        }

        private String toRegex(String value) {
            return value.replace("*", ".*");
        }

        private String[] selectFieldPartAsNodes(String[] expressionNodes) {
            return Arrays.copyOfRange(expressionNodes, 2, expressionNodes.length);
        }
    }

    @ThreadSafe
    @FunctionalInterface
    public static interface FieldFilter {
        public Document apply(Document var1);
    }
}

