/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.DebeziumException;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.Column;
import io.debezium.relational.HistorizedRelationalDatabaseSchema;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.schema.SchemaChangeEvent;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalSnapshotChangeEventSource<P extends Partition, O extends OffsetContext>
extends AbstractSnapshotChangeEventSource<P, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalSnapshotChangeEventSource.class);
    public static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
    private final RelationalDatabaseConnectorConfig connectorConfig;
    private final JdbcConnection jdbcConnection;
    private final HistorizedRelationalDatabaseSchema schema;
    protected final EventDispatcher<TableId> dispatcher;
    protected final Clock clock;
    private final SnapshotProgressListener snapshotProgressListener;

    public RelationalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig connectorConfig, JdbcConnection jdbcConnection, HistorizedRelationalDatabaseSchema schema, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        super(connectorConfig, snapshotProgressListener);
        this.connectorConfig = connectorConfig;
        this.jdbcConnection = jdbcConnection;
        this.schema = schema;
        this.dispatcher = dispatcher;
        this.clock = clock;
        this.snapshotProgressListener = snapshotProgressListener;
    }

    public RelationalSnapshotChangeEventSource(RelationalDatabaseConnectorConfig connectorConfig, JdbcConnection jdbcConnection, EventDispatcher<TableId> dispatcher, Clock clock, SnapshotProgressListener snapshotProgressListener) {
        this(connectorConfig, jdbcConnection, null, dispatcher, clock, snapshotProgressListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SnapshotResult<O> doExecute(ChangeEventSource.ChangeEventSourceContext context, O previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<P, O> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        RelationalSnapshotContext ctx = (RelationalSnapshotContext)snapshotContext;
        Connection connection = null;
        try {
            LOGGER.info("Snapshot step 1 - Preparing");
            if (previousOffset != null && previousOffset.isSnapshotRunning()) {
                LOGGER.info("Previous snapshot was cancelled before completion; a new snapshot will be taken.");
            }
            connection = this.createSnapshotConnection();
            this.connectionCreated(ctx);
            LOGGER.info("Snapshot step 2 - Determining captured tables");
            this.determineCapturedTables(ctx);
            this.snapshotProgressListener.monitoredDataCollectionsDetermined(ctx.capturedTables);
            LOGGER.info("Snapshot step 3 - Locking captured tables {}", ctx.capturedTables);
            if (snapshottingTask.snapshotSchema()) {
                this.lockTablesForSchemaSnapshot(context, ctx);
            }
            LOGGER.info("Snapshot step 4 - Determining snapshot offset");
            this.determineSnapshotOffset(ctx, previousOffset);
            LOGGER.info("Snapshot step 5 - Reading structure of captured tables");
            this.readTableStructure(context, ctx, previousOffset);
            if (snapshottingTask.snapshotSchema()) {
                LOGGER.info("Snapshot step 6 - Persisting schema history");
                this.createSchemaChangeEventsForTables(context, ctx, snapshottingTask);
                this.releaseSchemaSnapshotLocks(ctx);
            } else {
                LOGGER.info("Snapshot step 6 - Skipping persisting of schema history");
            }
            if (snapshottingTask.snapshotData()) {
                LOGGER.info("Snapshot step 7 - Snapshotting data");
                this.createDataEvents(context, ctx);
            } else {
                LOGGER.info("Snapshot step 7 - Skipping snapshotting of data");
                this.releaseDataSnapshotLocks(ctx);
                ctx.offset.preSnapshotCompletion();
                ctx.offset.postSnapshotCompletion();
            }
            this.postSnapshot();
            this.dispatcher.alwaysDispatchHeartbeatEvent(ctx.partition, ctx.offset);
            SnapshotResult<OffsetContext> snapshotResult = SnapshotResult.completed(ctx.offset);
            this.rollbackTransaction(connection);
            return snapshotResult;
        }
        catch (Throwable throwable) {
            this.rollbackTransaction(connection);
            throw throwable;
        }
    }

    public Connection createSnapshotConnection() throws SQLException {
        Connection connection = this.jdbcConnection.connection();
        connection.setAutoCommit(false);
        return connection;
    }

    protected void connectionCreated(RelationalSnapshotContext<P, O> snapshotContext) throws Exception {
    }

    private Stream<TableId> toTableIds(Set<TableId> tableIds, Pattern pattern) {
        return tableIds.stream().filter(tid -> pattern.asPredicate().test(this.connectorConfig.getTableIdMapper().toString((TableId)tid))).sorted();
    }

    private Set<TableId> sort(Set<TableId> capturedTables) throws Exception {
        String tableIncludeList = this.connectorConfig.tableIncludeList();
        if (tableIncludeList != null) {
            return Strings.listOfRegex(tableIncludeList, 2).stream().flatMap(pattern -> this.toTableIds(capturedTables, (Pattern)pattern)).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return capturedTables.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private void determineCapturedTables(RelationalSnapshotContext<P, O> ctx) throws Exception {
        Set allTableIds = this.determineDataCollectionsToBeSnapshotted(this.getAllTableIds(ctx)).collect(Collectors.toSet());
        HashSet<TableId> capturedTables = new HashSet<TableId>();
        HashSet<TableId> capturedSchemaTables = new HashSet<TableId>();
        for (TableId tableId : allTableIds) {
            if (this.connectorConfig.getTableFilters().eligibleDataCollectionFilter().isIncluded(tableId)) {
                LOGGER.trace("Adding table {} to the list of capture schema tables", (Object)tableId);
                capturedSchemaTables.add(tableId);
            }
            if (this.connectorConfig.getTableFilters().dataCollectionFilter().isIncluded(tableId)) {
                LOGGER.trace("Adding table {} to the list of captured tables", (Object)tableId);
                capturedTables.add(tableId);
                continue;
            }
            LOGGER.trace("Ignoring table {} as it's not included in the filter configuration", (Object)tableId);
        }
        ctx.capturedTables = this.sort(capturedTables);
        ctx.capturedSchemaTables = capturedSchemaTables.stream().sorted().collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected abstract Set<TableId> getAllTableIds(RelationalSnapshotContext<P, O> var1) throws Exception;

    protected abstract void lockTablesForSchemaSnapshot(ChangeEventSource.ChangeEventSourceContext var1, RelationalSnapshotContext<P, O> var2) throws Exception;

    protected abstract void determineSnapshotOffset(RelationalSnapshotContext<P, O> var1, O var2) throws Exception;

    protected abstract void readTableStructure(ChangeEventSource.ChangeEventSourceContext var1, RelationalSnapshotContext<P, O> var2, O var3) throws Exception;

    protected abstract void releaseSchemaSnapshotLocks(RelationalSnapshotContext<P, O> var1) throws Exception;

    protected void releaseDataSnapshotLocks(RelationalSnapshotContext<P, O> snapshotContext) throws Exception {
    }

    protected void createSchemaChangeEventsForTables(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
        this.tryStartingSnapshot(snapshotContext);
        Iterator<TableId> iterator = snapshotContext.capturedTables.iterator();
        while (iterator.hasNext()) {
            TableId tableId = iterator.next();
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while capturing schema of table " + tableId);
            }
            LOGGER.debug("Capturing structure of table {}", (Object)tableId);
            Table table = snapshotContext.tables.forTable(tableId);
            if (this.schema == null) continue;
            snapshotContext.offset.event(tableId, this.getClock().currentTime());
            if (!snapshottingTask.snapshotData() && !iterator.hasNext()) {
                this.lastSnapshotRecord(snapshotContext);
            }
            this.dispatcher.dispatchSchemaChangeEvent(table.id(), receiver -> {
                try {
                    receiver.schemaChangeEvent(this.getCreateTableEvent(snapshotContext, table));
                }
                catch (Exception e) {
                    throw new DebeziumException((Throwable)e);
                }
            });
        }
    }

    protected abstract SchemaChangeEvent getCreateTableEvent(RelationalSnapshotContext<P, O> var1, Table var2) throws Exception;

    private void createDataEvents(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext) throws Exception {
        EventDispatcher.SnapshotReceiver snapshotReceiver = this.dispatcher.getSnapshotChangeEventReceiver();
        this.tryStartingSnapshot(snapshotContext);
        int tableCount = snapshotContext.capturedTables.size();
        int tableOrder = 1;
        LOGGER.info("Snapshotting contents of {} tables while still in transaction", (Object)tableCount);
        Iterator<TableId> tableIdIterator = snapshotContext.capturedTables.iterator();
        while (tableIdIterator.hasNext()) {
            TableId tableId = tableIdIterator.next();
            boolean bl = snapshotContext.lastTable = !tableIdIterator.hasNext();
            if (!sourceContext.isRunning()) {
                throw new InterruptedException("Interrupted while snapshotting table " + tableId);
            }
            LOGGER.debug("Snapshotting table {}", (Object)tableId);
            this.createDataEventsForTable(sourceContext, snapshotContext, snapshotReceiver, snapshotContext.tables.forTable(tableId), tableOrder++, tableCount);
        }
        this.releaseDataSnapshotLocks(snapshotContext);
        snapshotContext.offset.preSnapshotCompletion();
        snapshotReceiver.completeSnapshot();
        snapshotContext.offset.postSnapshotCompletion();
    }

    protected void tryStartingSnapshot(RelationalSnapshotContext<P, O> snapshotContext) {
        if (!snapshotContext.offset.isSnapshotRunning()) {
            snapshotContext.offset.preSnapshotStart();
        }
    }

    private void createDataEventsForTable(ChangeEventSource.ChangeEventSourceContext sourceContext, RelationalSnapshotContext<P, O> snapshotContext, EventDispatcher.SnapshotReceiver snapshotReceiver, Table table, int tableOrder, int tableCount) throws InterruptedException {
        long exportStart = this.clock.currentTimeInMillis();
        LOGGER.info("\t Exporting data from table '{}' ({} of {} tables)", new Object[]{table.id(), tableOrder, tableCount});
        Optional<String> selectStatement = this.determineSnapshotSelect(snapshotContext, table.id());
        if (!selectStatement.isPresent()) {
            LOGGER.warn("For table '{}' the select statement was not provided, skipping table", (Object)table.id());
            this.snapshotProgressListener.dataCollectionSnapshotCompleted(table.id(), 0L);
            return;
        }
        LOGGER.info("\t For table '{}' using select statement: '{}'", (Object)table.id(), (Object)selectStatement.get());
        OptionalLong rowCount = this.rowCountForTable(table.id());
        try (Statement statement = this.readTableStatement(rowCount);
             ResultSet rs = statement.executeQuery(selectStatement.get());){
            ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
            long rows = 0L;
            Threads.Timer logTimer = this.getTableScanLogTimer();
            snapshotContext.lastRecordInTable = false;
            if (rs.next()) {
                while (!snapshotContext.lastRecordInTable) {
                    if (!sourceContext.isRunning()) {
                        throw new InterruptedException("Interrupted while snapshotting table " + table.id());
                    }
                    ++rows;
                    Object[] row = this.jdbcConnection.rowToArray(table, this.schema(), rs, columnArray);
                    boolean bl = snapshotContext.lastRecordInTable = !rs.next();
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        if (rowCount.isPresent()) {
                            LOGGER.info("\t Exported {} of {} records for table '{}' after {}", new Object[]{rows, rowCount.getAsLong(), table.id(), Strings.duration(stop - exportStart)});
                        } else {
                            LOGGER.info("\t Exported {} records for table '{}' after {}", new Object[]{rows, table.id(), Strings.duration(stop - exportStart)});
                        }
                        this.snapshotProgressListener.rowsScanned(table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    if (snapshotContext.lastTable && snapshotContext.lastRecordInTable) {
                        this.lastSnapshotRecord(snapshotContext);
                    }
                    this.dispatcher.dispatchSnapshotEvent(table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
                }
            } else if (snapshotContext.lastTable) {
                this.lastSnapshotRecord(snapshotContext);
            }
            LOGGER.info("\t Finished exporting {} records for table '{}'; total duration '{}'", new Object[]{rows, table.id(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            this.snapshotProgressListener.dataCollectionSnapshotCompleted(table.id(), rows);
        }
        catch (SQLException e) {
            throw new ConnectException("Snapshotting of table " + table.id() + " failed", (Throwable)e);
        }
    }

    protected void lastSnapshotRecord(RelationalSnapshotContext<P, O> snapshotContext) {
        snapshotContext.offset.markLastSnapshotRecord();
    }

    protected OptionalLong rowCountForTable(TableId tableId) {
        return OptionalLong.empty();
    }

    private Threads.Timer getTableScanLogTimer() {
        return Threads.timer(this.clock, LOG_INTERVAL);
    }

    protected ChangeRecordEmitter getChangeRecordEmitter(AbstractSnapshotChangeEventSource.SnapshotContext<P, O> snapshotContext, TableId tableId, Object[] row) {
        snapshotContext.offset.event(tableId, this.getClock().currentTime());
        return new SnapshotChangeRecordEmitter((Partition)snapshotContext.partition, (OffsetContext)snapshotContext.offset, row, this.getClock());
    }

    private Optional<String> determineSnapshotSelect(RelationalSnapshotContext<P, O> snapshotContext, TableId tableId) {
        String overriddenSelect = this.connectorConfig.getSnapshotSelectOverridesByTable().get(tableId);
        if (overriddenSelect == null) {
            overriddenSelect = this.connectorConfig.getSnapshotSelectOverridesByTable().get(new TableId(null, tableId.schema(), tableId.table()));
        }
        return overriddenSelect != null ? Optional.of(this.enhanceOverriddenSelect(snapshotContext, overriddenSelect, tableId)) : this.getSnapshotSelect(snapshotContext, tableId);
    }

    protected String enhanceOverriddenSelect(RelationalSnapshotContext<P, O> snapshotContext, String overriddenSelect, TableId tableId) {
        return overriddenSelect;
    }

    protected abstract Optional<String> getSnapshotSelect(RelationalSnapshotContext<P, O> var1, TableId var2);

    protected RelationalDatabaseSchema schema() {
        return this.schema;
    }

    protected Object getColumnValue(ResultSet rs, int columnIndex, Column column, Table table) throws SQLException {
        return this.jdbcConnection.getColumnValue(rs, columnIndex, column, table, this.schema());
    }

    protected Statement readTableStatement(OptionalLong tableSize) throws SQLException {
        return this.jdbcConnection.readTableStatement(this.connectorConfig, tableSize);
    }

    private void rollbackTransaction(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Clock getClock() {
        return this.clock;
    }

    protected void postSnapshot() throws InterruptedException {
    }

    public static class RelationalSnapshotContext<P extends Partition, O extends OffsetContext>
    extends AbstractSnapshotChangeEventSource.SnapshotContext<P, O> {
        public final String catalogName;
        public final Tables tables;
        public Set<TableId> capturedTables;
        public Set<TableId> capturedSchemaTables;
        public boolean lastTable;
        public boolean lastRecordInTable;

        public RelationalSnapshotContext(P partition, String catalogName) throws SQLException {
            super(partition);
            this.catalogName = catalogName;
            this.tables = new Tables();
        }
    }
}

