/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.SubjectProvider;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.lang.NonNull;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

@ThreadSafe
public class KerberosSubjectProvider
implements SubjectProvider {
    private static final Logger LOGGER = Loggers.getLogger("authenticator");
    private static final String TGT_PREFIX = "krbtgt/";
    private final String loginContextName;
    private Subject subject;

    public KerberosSubjectProvider() {
        this("com.sun.security.jgss.krb5.initiate");
    }

    public KerberosSubjectProvider(@NonNull String loginContextName) {
        this.loginContextName = Assertions.notNull("loginContextName", loginContextName);
    }

    @Override
    @NonNull
    public synchronized Subject getSubject() throws LoginException {
        if (this.subject == null || KerberosSubjectProvider.needNewSubject(this.subject)) {
            LOGGER.info("Creating new LoginContext and logging in the principal");
            LoginContext loginContext = new LoginContext(this.loginContextName);
            loginContext.login();
            this.subject = loginContext.getSubject();
            LOGGER.info("Login successful");
        }
        return this.subject;
    }

    private static boolean needNewSubject(@NonNull Subject subject) {
        for (KerberosTicket cur : subject.getPrivateCredentials(KerberosTicket.class)) {
            if (!cur.getServer().getName().startsWith(TGT_PREFIX)) continue;
            if (System.currentTimeMillis() <= cur.getEndTime().getTime() - TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES)) break;
            LOGGER.info("The TGT is close to expiring. Time to reacquire.");
            return true;
        }
        return false;
    }
}

