/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoSecurityException;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.authentication.NativeAuthenticationHelper;
import com.mongodb.internal.connection.Authenticator;
import com.mongodb.internal.connection.CommandHelper;
import com.mongodb.internal.connection.InternalConnection;
import com.mongodb.internal.connection.MongoCredentialWithCache;
import org.bson.BsonDocument;
import org.bson.BsonString;

class NativeAuthenticator
extends Authenticator {
    public static final Logger LOGGER = Loggers.getLogger("authenticator");

    NativeAuthenticator(MongoCredentialWithCache credential) {
        super(credential);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument nonceResponse = CommandHelper.executeCommand(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection);
            BsonDocument authCommand = NativeAuthenticationHelper.getAuthCommand(this.getUserNameNonNull(), this.getPasswordNonNull(), ((BsonString)nonceResponse.get((Object)"nonce")).getValue());
            CommandHelper.executeCommand(this.getMongoCredential().getSource(), authCommand, connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
        final SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        CommandHelper.executeCommandAsync(this.getMongoCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument nonceResult, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                } else {
                    CommandHelper.executeCommandAsync(NativeAuthenticator.this.getMongoCredential().getSource(), NativeAuthenticationHelper.getAuthCommand(NativeAuthenticator.this.getUserNameNonNull(), NativeAuthenticator.this.getPasswordNonNull(), ((BsonString)nonceResult.get((Object)"nonce")).getValue()), connection, new SingleResultCallback<BsonDocument>(){

                        @Override
                        public void onResult(BsonDocument result, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                            } else {
                                errHandlingCallback.onResult(null, null);
                            }
                        }
                    });
                }
            }
        });
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getMongoCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

