/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DataCollectionSchema;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.bson.Document;

public class MongoDbCollectionSchema
implements DataCollectionSchema {
    private final CollectionId id;
    private final FieldSelector.FieldFilter fieldFilter;
    private final Schema keySchema;
    private final Envelope enveopeSchema;
    private final Schema valueSchema;
    private final Function<Document, Object> keyGenerator;
    private final Function<Document, String> valueGenerator;

    public MongoDbCollectionSchema(CollectionId id, FieldSelector.FieldFilter fieldFilter, Schema keySchema, Function<Document, Object> keyGenerator, Envelope envelopeSchema, Schema valueSchema, Function<Document, String> valueGenerator) {
        this.id = id;
        this.fieldFilter = fieldFilter;
        this.keySchema = keySchema;
        this.enveopeSchema = envelopeSchema;
        this.valueSchema = valueSchema;
        this.keyGenerator = keyGenerator != null ? keyGenerator : Document2 -> null;
        this.valueGenerator = valueGenerator != null ? valueGenerator : Document2 -> null;
    }

    public DataCollectionId id() {
        return this.id;
    }

    public Schema keySchema() {
        return this.keySchema;
    }

    public Schema valueSchema() {
        return this.valueSchema;
    }

    public Envelope getEnvelopeSchema() {
        return this.enveopeSchema;
    }

    public Struct keyFromDocument(Document document) {
        return document == null ? null : new Struct(this.keySchema).put("id", this.keyGenerator.apply(document));
    }

    public Struct valueFromDocument(Document document, Document filter, Envelope.Operation operation) {
        Struct value = new Struct(this.valueSchema);
        switch (operation) {
            case READ: 
            case CREATE: {
                String jsonStr = this.valueGenerator.apply(this.fieldFilter.apply(document));
                value.put("after", (Object)jsonStr);
                break;
            }
            case UPDATE: {
                String patchStr = this.valueGenerator.apply(this.fieldFilter.apply(document));
                value.put("patch", (Object)patchStr);
                String updateFilterStr = this.valueGenerator.apply(this.fieldFilter.apply(filter));
                value.put("filter", (Object)updateFilterStr);
                break;
            }
            case DELETE: {
                String deleteFilterStr = this.valueGenerator.apply(this.fieldFilter.apply(filter));
                value.put("filter", (Object)deleteFilterStr);
            }
        }
        return value;
    }

    public int hashCode() {
        return this.valueSchema().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MongoDbCollectionSchema) {
            MongoDbCollectionSchema that = (MongoDbCollectionSchema)obj;
            return Objects.equals(this.keySchema(), that.keySchema()) && Objects.equals(this.valueSchema(), that.valueSchema());
        }
        return false;
    }

    public String toString() {
        return "{ key : " + SchemaUtil.asString((Schema)this.keySchema()) + ", value : " + SchemaUtil.asString((Schema)this.valueSchema()) + " }";
    }
}

