/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.SnapshotChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.StreamingChangeEventSourceMetrics;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.source.spi.SnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.StreamingChangeEventSource;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.schema.DataCollectionId;
import io.debezium.schema.DatabaseSchema;
import io.debezium.util.LoggingContext;
import io.debezium.util.Threads;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.connect.source.SourceConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ChangeEventSourceCoordinator<O extends OffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeEventSourceCoordinator.class);
    public static final Duration SHUTDOWN_WAIT_TIMEOUT = Duration.ofSeconds(90L);
    private final O previousOffset;
    private final ErrorHandler errorHandler;
    private final ChangeEventSourceFactory<O> changeEventSourceFactory;
    private final ChangeEventSourceMetricsFactory changeEventSourceMetricsFactory;
    private final ExecutorService executor;
    private final EventDispatcher<?> eventDispatcher;
    private final DatabaseSchema<?> schema;
    private volatile boolean running;
    private volatile StreamingChangeEventSource<O> streamingSource;
    private final ReentrantLock commitOffsetLock = new ReentrantLock();
    private SnapshotChangeEventSourceMetrics snapshotMetrics;
    private StreamingChangeEventSourceMetrics streamingMetrics;

    public ChangeEventSourceCoordinator(O previousOffset, ErrorHandler errorHandler, Class<? extends SourceConnector> connectorType, CommonConnectorConfig connectorConfig, ChangeEventSourceFactory<O> changeEventSourceFactory, ChangeEventSourceMetricsFactory changeEventSourceMetricsFactory, EventDispatcher<?> eventDispatcher, DatabaseSchema<?> schema) {
        this.previousOffset = previousOffset;
        this.errorHandler = errorHandler;
        this.changeEventSourceFactory = changeEventSourceFactory;
        this.changeEventSourceMetricsFactory = changeEventSourceMetricsFactory;
        this.executor = Threads.newSingleThreadExecutor(connectorType, connectorConfig.getLogicalName(), "change-event-source-coordinator");
        this.eventDispatcher = eventDispatcher;
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(CdcSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider) {
        AtomicReference previousLogContext = new AtomicReference();
        try {
            this.snapshotMetrics = this.changeEventSourceMetricsFactory.getSnapshotMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
            this.streamingMetrics = this.changeEventSourceMetricsFactory.getStreamingMetrics(taskContext, changeEventQueueMetrics, metadataProvider);
            this.running = true;
            this.executor.submit(() -> {
                try {
                    previousLogContext.set(taskContext.configureLoggingContext("snapshot"));
                    this.snapshotMetrics.register(LOGGER);
                    this.streamingMetrics.register(LOGGER);
                    LOGGER.info("Metrics registered");
                    ChangeEventSourceContextImpl context = new ChangeEventSourceContextImpl();
                    LOGGER.info("Context created");
                    SnapshotChangeEventSource<O> snapshotSource = this.changeEventSourceFactory.getSnapshotChangeEventSource(this.snapshotMetrics);
                    CatchUpStreamingResult catchUpStreamingResult = this.executeCatchUpStreaming(this.previousOffset, context, snapshotSource);
                    if (catchUpStreamingResult.performedCatchUpStreaming) {
                        this.streamingConnected(false);
                        this.commitOffsetLock.lock();
                        this.streamingSource = null;
                        this.commitOffsetLock.unlock();
                    }
                    this.eventDispatcher.setEventListener(this.snapshotMetrics);
                    SnapshotResult<O> snapshotResult = snapshotSource.execute(context, this.previousOffset);
                    LOGGER.info("Snapshot ended with {}", snapshotResult);
                    if (snapshotResult.getStatus() == SnapshotResult.SnapshotResultStatus.COMPLETED || this.schema.tableInformationComplete()) {
                        this.schema.assureNonEmptySchema();
                    }
                    if (this.running && snapshotResult.isCompletedOrSkipped()) {
                        previousLogContext.set(taskContext.configureLoggingContext("streaming"));
                        this.streamEvents(snapshotResult.getOffset(), context);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.warn("Change event source executor was interrupted", (Throwable)e);
                }
                catch (Throwable e) {
                    this.errorHandler.setProducerThrowable(e);
                }
                finally {
                    this.streamingConnected(false);
                }
            });
        }
        finally {
            if (previousLogContext.get() != null) {
                ((LoggingContext.PreviousContext)previousLogContext.get()).restore();
            }
        }
    }

    protected CatchUpStreamingResult executeCatchUpStreaming(O previousOffset, ChangeEventSource.ChangeEventSourceContext context, SnapshotChangeEventSource<O> snapshotSource) throws InterruptedException {
        return new CatchUpStreamingResult(false);
    }

    protected void streamEvents(O offsetContext, ChangeEventSource.ChangeEventSourceContext context) throws InterruptedException {
        this.streamingSource = this.changeEventSourceFactory.getStreamingChangeEventSource();
        Optional<IncrementalSnapshotChangeEventSource<? extends DataCollectionId>> incrementalSnapshotChangeEventSource = this.changeEventSourceFactory.getIncrementalSnapshotChangeEventSource(offsetContext, this.snapshotMetrics, this.snapshotMetrics);
        this.eventDispatcher.setIncrementalSnapshotChangeEventSource(incrementalSnapshotChangeEventSource);
        this.eventDispatcher.setEventListener(this.streamingMetrics);
        this.streamingConnected(true);
        LOGGER.info("Starting streaming");
        incrementalSnapshotChangeEventSource.ifPresent(x -> x.init((OffsetContext)offsetContext));
        this.streamingSource.execute(context, offsetContext);
        LOGGER.info("Finished streaming");
    }

    public void commitOffset(Map<String, ?> offset) {
        if (!this.commitOffsetLock.isLocked() && this.streamingSource != null && offset != null) {
            this.streamingSource.commitOffset(offset);
        }
    }

    public synchronized void stop() throws InterruptedException {
        this.running = false;
        try {
            Thread.interrupted();
            this.executor.shutdown();
            boolean isShutdown = this.executor.awaitTermination(SHUTDOWN_WAIT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            if (!isShutdown) {
                LOGGER.warn("Coordinator didn't stop in the expected time, shutting down executor now");
                Thread.interrupted();
                this.executor.shutdownNow();
                this.executor.awaitTermination(SHUTDOWN_WAIT_TIMEOUT.toMillis(), TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this.snapshotMetrics.unregister(LOGGER);
            this.streamingMetrics.unregister(LOGGER);
        }
    }

    private void streamingConnected(boolean status) {
        if (this.changeEventSourceMetricsFactory.connectionMetricHandledByCoordinator()) {
            this.streamingMetrics.connected(status);
        }
    }

    protected class CatchUpStreamingResult {
        public boolean performedCatchUpStreaming;

        public CatchUpStreamingResult(boolean performedCatchUpStreaming) {
            this.performedCatchUpStreaming = performedCatchUpStreaming;
        }
    }

    private class ChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private ChangeEventSourceContextImpl() {
        }

        @Override
        public boolean isRunning() {
            return ChangeEventSourceCoordinator.this.running;
        }
    }
}

