/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.result;

import com.mongodb.lang.Nullable;
import java.util.Objects;
import org.bson.BsonValue;

public abstract class InsertOneResult {
    public abstract boolean wasAcknowledged();

    @Nullable
    public abstract BsonValue getInsertedId();

    public static InsertOneResult acknowledged(@Nullable BsonValue insertId) {
        return new AcknowledgedInsertOneResult(insertId);
    }

    public static InsertOneResult unacknowledged() {
        return new UnacknowledgedInsertOneResult();
    }

    private static class UnacknowledgedInsertOneResult
    extends InsertOneResult {
        private UnacknowledgedInsertOneResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        @Nullable
        public BsonValue getInsertedId() {
            throw new UnsupportedOperationException("Cannot get information about an unacknowledged insert");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedInsertOneResult{}";
        }
    }

    private static class AcknowledgedInsertOneResult
    extends InsertOneResult {
        private final BsonValue insertedId;

        AcknowledgedInsertOneResult(@Nullable BsonValue insertId) {
            this.insertedId = insertId;
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        @Nullable
        public BsonValue getInsertedId() {
            return this.insertedId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedInsertOneResult that = (AcknowledgedInsertOneResult)o;
            return Objects.equals(this.insertedId, that.insertedId);
        }

        public int hashCode() {
            return Objects.hash(this.insertedId);
        }

        public String toString() {
            return "AcknowledgedInsertOneResult{insertedId=" + this.insertedId + '}';
        }
    }
}

