/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.data.Envelope;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.relational.CustomConverterRegistry;
import io.debezium.relational.history.KafkaDatabaseHistory;
import io.debezium.spi.converter.ConvertedField;
import io.debezium.spi.converter.CustomConverter;
import io.debezium.util.Strings;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.data.SchemaBuilder;

public abstract class CommonConnectorConfig {
    private static final String CONFLUENT_AVRO_CONVERTER = "io.confluent.connect.avro.AvroConverter";
    private static final String APICURIO_AVRO_CONVERTER = "io.apicurio.registry.utils.converter.AvroConverter";
    public static final int DEFAULT_MAX_QUEUE_SIZE = 8192;
    public static final int DEFAULT_MAX_BATCH_SIZE = 2048;
    public static final int DEFAULT_QUERY_FETCH_SIZE = 0;
    public static final long DEFAULT_POLL_INTERVAL_MILLIS = 500L;
    public static final String DATABASE_CONFIG_PREFIX = "database.";
    private static final String CONVERTER_TYPE_SUFFIX = ".type";
    public static final long DEFAULT_RETRIABLE_RESTART_WAIT = 10000L;
    public static final long DEFAULT_MAX_QUEUE_SIZE_IN_BYTES = 0L;
    public static final Field RETRIABLE_RESTART_WAIT = Field.create("retriable.restart.connector.wait.ms").withDisplayName("Retriable restart wait (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(10000L).withDescription("Time to wait before restarting connector after retriable exception occurs. Defaults to 10000ms.").withValidation(Field::isPositiveLong);
    public static final Field TOMBSTONES_ON_DELETE = Field.create("tombstones.on.delete").withDisplayName("Change the behaviour of Debezium with regards to delete operations").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withValidation(Field::isBoolean).withDescription("Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.");
    public static final Field MAX_QUEUE_SIZE = Field.create("max.queue.size").withDisplayName("Change event buffer size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue for change events read from the database log but not yet recorded or forwarded. Defaults to 8192, and should always be larger than the maximum batch size.").withDefault(8192).withValidation(CommonConnectorConfig::validateMaxQueueSize);
    public static final Field MAX_BATCH_SIZE = Field.create("max.batch.size").withDisplayName("Change event batch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of each batch of source records. Defaults to 2048.").withDefault(2048).withValidation(Field::isPositiveInteger);
    public static final Field POLL_INTERVAL_MS = Field.create("poll.interval.ms").withDisplayName("Poll interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Time to wait for new change events to appear after receiving no events, given in milliseconds. Defaults to 500 ms.").withDefault(500L).withValidation(Field::isPositiveInteger);
    public static final Field MAX_QUEUE_SIZE_IN_BYTES = Field.create("max.queue.size.in.bytes").withDisplayName("Change event buffer size in bytes").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Maximum size of the queue in bytes for change events read from the database log but not yet recorded or forwarded. Defaults to 0. Mean the feature is not enabled").withDefault(0L).withValidation(Field::isNonNegativeLong);
    public static final Field SNAPSHOT_DELAY_MS = Field.create("snapshot.delay.ms").withDisplayName("Snapshot Delay (milliseconds)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A delay period before a snapshot will begin, given in milliseconds. Defaults to 0 ms.").withDefault(0L).withValidation(Field::isNonNegativeLong);
    public static final Field SNAPSHOT_FETCH_SIZE = Field.create("snapshot.fetch.size").withDisplayName("Snapshot fetch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of records that should be loaded into memory while performing a snapshot").withValidation(Field::isNonNegativeInteger);
    public static final Field SNAPSHOT_MODE_TABLES = Field.create("snapshot.include.collection.list").withDisplayName("Snapshot mode include data collection").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(Field::isListOfRegex).withDescription("this setting must be set to specify a list of tables/collections whose snapshot must be taken on creating or restarting the connector.");
    public static final Field SOURCE_STRUCT_MAKER_VERSION = Field.create("source.struct.version").withDisplayName("Source struct maker version").withEnum(Version.class, Version.V2).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("A version of the format of the publicly visible source part in the message").withValidation(Field::isClassName);
    public static final Field SANITIZE_FIELD_NAMES = Field.create("sanitize.field.names").withDisplayName("Sanitize field names to adhere to Avro naming conventions").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether field names will be sanitized to Avro naming conventions").withDefault(Boolean.FALSE);
    public static final Field PROVIDE_TRANSACTION_METADATA = Field.create("provide.transaction.metadata").withDisplayName("Store transaction metadata information in a dedicated topic.").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Enables transaction metadata extraction together with event counting").withDefault(Boolean.FALSE);
    public static final Field EVENT_PROCESSING_FAILURE_HANDLING_MODE = Field.create("event.processing.failure.handling.mode").withDisplayName("Event deserialization failure handling").withEnum(EventProcessingFailureHandlingMode.class, EventProcessingFailureHandlingMode.FAIL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify how failures during processing of events (i.e. when encountering a corrupted event) should be handled, including:'fail' (the default) an exception indicating the problematic event and its position is raised, causing the connector to be stopped; 'warn' the problematic event and its position will be logged and the event will be skipped;'ignore' the problematic event will be skipped.");
    public static final Field CUSTOM_CONVERTERS = Field.create("converters").withDisplayName("List of prefixes defining custom values converters.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Optional list of custom converters that would be used instead of default ones. The converters are defined using '<converter.prefix>.type' config option and configured using options '<converter.prefix>.<option>'");
    public static final Field SKIPPED_OPERATIONS = Field.create("skipped.operations").withDisplayName("skipped Operations").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withValidation(CommonConnectorConfig::validateSkippedOperation).withDescription("The comma-separated list of operations to skip during streaming, defined as: 'c' for inserts/create; 'u' for updates; 'd' for deletes. By default, no operations will be skipped.");
    public static final Field BINARY_HANDLING_MODE = Field.create("binary.handling.mode").withDisplayName("Binary Handling").withEnum(BinaryHandlingMode.class, BinaryHandlingMode.BYTES).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how binary (blob, binary, etc.) columns should be represented in change events, including:'bytes' represents binary data as byte array (default)'base64' represents binary data as base64-encoded string'hex' represents binary data as hex-encoded (base16) string");
    public static final Field QUERY_FETCH_SIZE = Field.create("query.fetch.size").withDisplayName("Query fetch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of records that should be loaded into memory while streaming.  A value of `0` uses the default JDBC fetch size.").withValidation(Field::isNonNegativeInteger).withDefault(0);
    public static final Field SNAPSHOT_MAX_THREADS = Field.create("snapshot.max.threads").withDisplayName("Snapshot maximum threads").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1).withValidation(Field::isPositiveInteger).withDescription("The maximum number of threads used to perform the snapshot.  Defaults to 1.");
    public static final Field SIGNAL_DATA_COLLECTION = Field.create("signal.data.collection").withDisplayName("Signaling data collection").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the data collection that is used to send signals/commands to Debezium. Signaling is disabled when not set.");
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().connector(EVENT_PROCESSING_FAILURE_HANDLING_MODE, MAX_BATCH_SIZE, MAX_QUEUE_SIZE, POLL_INTERVAL_MS, MAX_QUEUE_SIZE_IN_BYTES, PROVIDE_TRANSACTION_METADATA, SKIPPED_OPERATIONS, SNAPSHOT_DELAY_MS, SNAPSHOT_MODE_TABLES, SNAPSHOT_FETCH_SIZE, SNAPSHOT_MAX_THREADS, RETRIABLE_RESTART_WAIT, QUERY_FETCH_SIZE).events(CUSTOM_CONVERTERS, SANITIZE_FIELD_NAMES, TOMBSTONES_ON_DELETE, SOURCE_STRUCT_MAKER_VERSION, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, SIGNAL_DATA_COLLECTION).create();
    private final Configuration config;
    private final boolean emitTombstoneOnDelete;
    private final int maxQueueSize;
    private final int maxBatchSize;
    private final long maxQueueSizeInBytes;
    private final Duration pollInterval;
    private final String logicalName;
    private final String heartbeatTopicsPrefix;
    private final Duration snapshotDelayMs;
    private final Duration retriableRestartWait;
    private final int snapshotFetchSize;
    private final int snapshotMaxThreads;
    private final Integer queryFetchSize;
    private final SourceInfoStructMaker<? extends AbstractSourceInfo> sourceInfoStructMaker;
    private final boolean sanitizeFieldNames;
    private final boolean shouldProvideTransactionMetadata;
    private final EventProcessingFailureHandlingMode eventProcessingFailureHandlingMode;
    private final CustomConverterRegistry customConverterRegistry;
    private final BinaryHandlingMode binaryHandlingMode;
    private final String signalingDataCollection;

    protected CommonConnectorConfig(Configuration config, String logicalName, int defaultSnapshotFetchSize) {
        this.config = config;
        this.emitTombstoneOnDelete = config.getBoolean(TOMBSTONES_ON_DELETE);
        this.maxQueueSize = config.getInteger(MAX_QUEUE_SIZE);
        this.maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        this.pollInterval = config.getDuration(POLL_INTERVAL_MS, ChronoUnit.MILLIS);
        this.maxQueueSizeInBytes = config.getLong(MAX_QUEUE_SIZE_IN_BYTES);
        this.logicalName = logicalName;
        this.heartbeatTopicsPrefix = config.getString(Heartbeat.HEARTBEAT_TOPICS_PREFIX);
        this.snapshotDelayMs = Duration.ofMillis(config.getLong(SNAPSHOT_DELAY_MS));
        this.retriableRestartWait = Duration.ofMillis(config.getLong(RETRIABLE_RESTART_WAIT));
        this.snapshotFetchSize = config.getInteger(SNAPSHOT_FETCH_SIZE, defaultSnapshotFetchSize);
        this.snapshotMaxThreads = config.getInteger(SNAPSHOT_MAX_THREADS);
        this.queryFetchSize = config.getInteger(QUERY_FETCH_SIZE);
        this.sourceInfoStructMaker = this.getSourceInfoStructMaker(Version.parse(config.getString(SOURCE_STRUCT_MAKER_VERSION)));
        this.sanitizeFieldNames = config.getBoolean(SANITIZE_FIELD_NAMES) || CommonConnectorConfig.isUsingAvroConverter(config);
        this.shouldProvideTransactionMetadata = config.getBoolean(PROVIDE_TRANSACTION_METADATA);
        this.eventProcessingFailureHandlingMode = EventProcessingFailureHandlingMode.parse(config.getString(EVENT_PROCESSING_FAILURE_HANDLING_MODE));
        this.customConverterRegistry = new CustomConverterRegistry(this.getCustomConverters());
        this.binaryHandlingMode = BinaryHandlingMode.parse(config.getString(BINARY_HANDLING_MODE));
        this.signalingDataCollection = config.getString(SIGNAL_DATA_COLLECTION);
    }

    @Deprecated
    public Configuration getConfig() {
        return this.config;
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public Duration getPollInterval() {
        return this.pollInterval;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public abstract String getContextName();

    public abstract String getConnectorName();

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public Duration getRetriableRestartWait() {
        return this.retriableRestartWait;
    }

    public Duration getSnapshotDelay() {
        return this.snapshotDelayMs;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public boolean shouldProvideTransactionMetadata() {
        return this.shouldProvideTransactionMetadata;
    }

    public EventProcessingFailureHandlingMode getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public CustomConverterRegistry customConverterRegistry() {
        return this.customConverterRegistry;
    }

    private List<CustomConverter<SchemaBuilder, ConvertedField>> getCustomConverters() {
        String converterNameList = this.config.getString(CUSTOM_CONVERTERS);
        List<String> converterNames = Strings.listOf(converterNameList, x -> x.split(","), String::trim);
        return converterNames.stream().map(name -> {
            CustomConverter converter = this.config.getInstance(name + CONVERTER_TYPE_SUFFIX, CustomConverter.class);
            converter.configure(this.config.subset((String)name, true).asProperties());
            return converter;
        }).collect(Collectors.toList());
    }

    public <T extends AbstractSourceInfo> SourceInfoStructMaker<T> getSourceInfoStructMaker() {
        return this.sourceInfoStructMaker;
    }

    public boolean getSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public Set<Envelope.Operation> getSkippedOps() {
        String operations = this.config.getString(SKIPPED_OPERATIONS);
        if (operations != null) {
            return Arrays.stream(operations.split(",")).map(String::trim).map(Envelope.Operation::forCode).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Set<String> getDataCollectionsToBeSnapshotted() {
        return Optional.ofNullable(this.config.getString(SNAPSHOT_MODE_TABLES)).map(tables -> Strings.setOf(tables, Function.identity())).orElseGet(Collections::emptySet);
    }

    public boolean isSchemaChangesHistoryEnabled() {
        return false;
    }

    public boolean validate(Iterable<Field> fields, Field.ValidationOutput problems) {
        return this.config.validate(fields, problems);
    }

    public boolean validateAndRecord(Iterable<Field> fields, Consumer<String> problems) {
        return this.config.validateAndRecord(fields, problems);
    }

    private static int validateMaxQueueSize(Configuration config, Field field, Field.ValidationOutput problems) {
        int maxQueueSize = config.getInteger(field);
        int maxBatchSize = config.getInteger(MAX_BATCH_SIZE);
        int count = 0;
        if (maxQueueSize <= 0) {
            problems.accept(field, maxQueueSize, "A positive queue size is required");
            ++count;
        }
        if (maxQueueSize <= maxBatchSize) {
            problems.accept(field, maxQueueSize, "Must be larger than the maximum batch size");
            ++count;
        }
        return count;
    }

    private static int validateSkippedOperation(Configuration config, Field field, Field.ValidationOutput problems) {
        String operations = config.getString(field);
        if (operations == null) {
            return 0;
        }
        block9: for (String operation : operations.split(",")) {
            switch (operation.trim()) {
                case "r": 
                case "c": 
                case "u": 
                case "d": {
                    continue block9;
                }
                default: {
                    problems.accept(field, operation, "Invalid operation");
                    return 1;
                }
            }
        }
        return 0;
    }

    private static boolean isUsingAvroConverter(Configuration config) {
        String keyConverter = config.getString("key.converter");
        String valueConverter = config.getString("value.converter");
        return CONFLUENT_AVRO_CONVERTER.equals(keyConverter) || CONFLUENT_AVRO_CONVERTER.equals(valueConverter) || APICURIO_AVRO_CONVERTER.equals(keyConverter) || APICURIO_AVRO_CONVERTER.equals(valueConverter);
    }

    protected static int validateServerNameIsDifferentFromHistoryTopicName(Configuration config, Field field, Field.ValidationOutput problems) {
        String historyTopicName;
        String serverName = config.getString(field);
        if (Objects.equals(serverName, historyTopicName = config.getString(KafkaDatabaseHistory.TOPIC))) {
            problems.accept(field, serverName, "Must not have the same value as " + KafkaDatabaseHistory.TOPIC.name());
            return 1;
        }
        return 0;
    }

    protected abstract SourceInfoStructMaker<?> getSourceInfoStructMaker(Version var1);

    public BinaryHandlingMode binaryHandlingMode() {
        return this.binaryHandlingMode;
    }

    public String getSignalingDataCollectionId() {
        return this.signalingDataCollection;
    }

    public static enum BinaryHandlingMode implements EnumeratedValue
    {
        BYTES("bytes", SchemaBuilder::bytes),
        BASE64("base64", SchemaBuilder::string),
        HEX("hex", SchemaBuilder::string);

        private final String value;
        private final Supplier<SchemaBuilder> schema;

        private BinaryHandlingMode(String value, Supplier<SchemaBuilder> schema) {
            this.value = value;
            this.schema = schema;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public SchemaBuilder getSchema() {
            return this.schema.get();
        }

        public static BinaryHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (BinaryHandlingMode option : BinaryHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static BinaryHandlingMode parse(String value, String defaultValue) {
            BinaryHandlingMode mode = BinaryHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = BinaryHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum EventProcessingFailureHandlingMode implements EnumeratedValue
    {
        SKIP("skip"),
        WARN("warn"),
        FAIL("fail"),
        IGNORE("ignore");

        public static final String OBSOLETE_NAME_FOR_SKIP_FAILURE_HANDLING = "ignore";
        private final String value;

        private EventProcessingFailureHandlingMode(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static EventProcessingFailureHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            if (OBSOLETE_NAME_FOR_SKIP_FAILURE_HANDLING.equals(value = value.trim())) {
                return SKIP;
            }
            for (EventProcessingFailureHandlingMode option : EventProcessingFailureHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum Version implements EnumeratedValue
    {
        V1("v1"),
        V2("v2");

        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static Version parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (Version option : Version.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static Version parse(String value, String defaultValue) {
            Version mode = Version.parse(value);
            if (mode == null && defaultValue != null) {
                mode = Version.parse(defaultValue);
            }
            return mode;
        }
    }
}

