/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertManyResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.client.AsyncAggregateIterable;
import com.mongodb.internal.async.client.AsyncChangeStreamIterable;
import com.mongodb.internal.async.client.AsyncClientSession;
import com.mongodb.internal.async.client.AsyncDistinctIterable;
import com.mongodb.internal.async.client.AsyncFindIterable;
import com.mongodb.internal.async.client.AsyncListIndexesIterable;
import com.mongodb.internal.async.client.AsyncMapReduceIterable;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface AsyncMongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public <NewTDocument> AsyncMongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public AsyncMongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public AsyncMongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public AsyncMongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public AsyncMongoCollection<TDocument> withReadConcern(ReadConcern var1);

    public void countDocuments(SingleResultCallback<Long> var1);

    public void countDocuments(Bson var1, SingleResultCallback<Long> var2);

    public void countDocuments(Bson var1, CountOptions var2, SingleResultCallback<Long> var3);

    public void countDocuments(AsyncClientSession var1, SingleResultCallback<Long> var2);

    public void countDocuments(AsyncClientSession var1, Bson var2, SingleResultCallback<Long> var3);

    public void countDocuments(AsyncClientSession var1, Bson var2, CountOptions var3, SingleResultCallback<Long> var4);

    public void estimatedDocumentCount(SingleResultCallback<Long> var1);

    public void estimatedDocumentCount(EstimatedDocumentCountOptions var1, SingleResultCallback<Long> var2);

    public <TResult> AsyncDistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public <TResult> AsyncDistinctIterable<TResult> distinct(String var1, Bson var2, Class<TResult> var3);

    public <TResult> AsyncDistinctIterable<TResult> distinct(AsyncClientSession var1, String var2, Class<TResult> var3);

    public <TResult> AsyncDistinctIterable<TResult> distinct(AsyncClientSession var1, String var2, Bson var3, Class<TResult> var4);

    public AsyncFindIterable<TDocument> find();

    public <TResult> AsyncFindIterable<TResult> find(Class<TResult> var1);

    public AsyncFindIterable<TDocument> find(Bson var1);

    public <TResult> AsyncFindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public AsyncFindIterable<TDocument> find(AsyncClientSession var1);

    public <TResult> AsyncFindIterable<TResult> find(AsyncClientSession var1, Class<TResult> var2);

    public AsyncFindIterable<TDocument> find(AsyncClientSession var1, Bson var2);

    public <TResult> AsyncFindIterable<TResult> find(AsyncClientSession var1, Bson var2, Class<TResult> var3);

    public AsyncAggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AsyncAggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public AsyncAggregateIterable<TDocument> aggregate(AsyncClientSession var1, List<? extends Bson> var2);

    public <TResult> AsyncAggregateIterable<TResult> aggregate(AsyncClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public AsyncChangeStreamIterable<TDocument> watch();

    public <TResult> AsyncChangeStreamIterable<TResult> watch(Class<TResult> var1);

    public AsyncChangeStreamIterable<TDocument> watch(List<? extends Bson> var1);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(List<? extends Bson> var1, Class<TResult> var2);

    public AsyncChangeStreamIterable<TDocument> watch(AsyncClientSession var1);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession var1, Class<TResult> var2);

    public AsyncChangeStreamIterable<TDocument> watch(AsyncClientSession var1, List<? extends Bson> var2);

    public <TResult> AsyncChangeStreamIterable<TResult> watch(AsyncClientSession var1, List<? extends Bson> var2, Class<TResult> var3);

    public AsyncMapReduceIterable<TDocument> mapReduce(String var1, String var2);

    public <TResult> AsyncMapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public AsyncMapReduceIterable<TDocument> mapReduce(AsyncClientSession var1, String var2, String var3);

    public <TResult> AsyncMapReduceIterable<TResult> mapReduce(AsyncClientSession var1, String var2, String var3, Class<TResult> var4);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, SingleResultCallback<BulkWriteResult> var2);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2, SingleResultCallback<BulkWriteResult> var3);

    public void bulkWrite(AsyncClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, SingleResultCallback<BulkWriteResult> var3);

    public void bulkWrite(AsyncClientSession var1, List<? extends WriteModel<? extends TDocument>> var2, BulkWriteOptions var3, SingleResultCallback<BulkWriteResult> var4);

    public void insertOne(TDocument var1, SingleResultCallback<InsertOneResult> var2);

    public void insertOne(TDocument var1, InsertOneOptions var2, SingleResultCallback<InsertOneResult> var3);

    public void insertOne(AsyncClientSession var1, TDocument var2, SingleResultCallback<InsertOneResult> var3);

    public void insertOne(AsyncClientSession var1, TDocument var2, InsertOneOptions var3, SingleResultCallback<InsertOneResult> var4);

    public void insertMany(List<? extends TDocument> var1, SingleResultCallback<InsertManyResult> var2);

    public void insertMany(List<? extends TDocument> var1, InsertManyOptions var2, SingleResultCallback<InsertManyResult> var3);

    public void insertMany(AsyncClientSession var1, List<? extends TDocument> var2, SingleResultCallback<InsertManyResult> var3);

    public void insertMany(AsyncClientSession var1, List<? extends TDocument> var2, InsertManyOptions var3, SingleResultCallback<InsertManyResult> var4);

    public void deleteOne(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void deleteOne(Bson var1, DeleteOptions var2, SingleResultCallback<DeleteResult> var3);

    public void deleteOne(AsyncClientSession var1, Bson var2, SingleResultCallback<DeleteResult> var3);

    public void deleteOne(AsyncClientSession var1, Bson var2, DeleteOptions var3, SingleResultCallback<DeleteResult> var4);

    public void deleteMany(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void deleteMany(Bson var1, DeleteOptions var2, SingleResultCallback<DeleteResult> var3);

    public void deleteMany(AsyncClientSession var1, Bson var2, SingleResultCallback<DeleteResult> var3);

    public void deleteMany(AsyncClientSession var1, Bson var2, DeleteOptions var3, SingleResultCallback<DeleteResult> var4);

    public void replaceOne(Bson var1, TDocument var2, SingleResultCallback<UpdateResult> var3);

    public void replaceOne(Bson var1, TDocument var2, ReplaceOptions var3, SingleResultCallback<UpdateResult> var4);

    public void replaceOne(AsyncClientSession var1, Bson var2, TDocument var3, SingleResultCallback<UpdateResult> var4);

    public void replaceOne(AsyncClientSession var1, Bson var2, TDocument var3, ReplaceOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateOne(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateOne(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(AsyncClientSession var1, Bson var2, Bson var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(AsyncClientSession var1, Bson var2, Bson var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateOne(Bson var1, List<? extends Bson> var2, SingleResultCallback<UpdateResult> var3);

    public void updateOne(Bson var1, List<? extends Bson> var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateMany(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateMany(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(AsyncClientSession var1, Bson var2, Bson var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(AsyncClientSession var1, Bson var2, Bson var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void updateMany(Bson var1, List<? extends Bson> var2, SingleResultCallback<UpdateResult> var3);

    public void updateMany(Bson var1, List<? extends Bson> var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, UpdateOptions var4, SingleResultCallback<UpdateResult> var5);

    public void findOneAndDelete(Bson var1, SingleResultCallback<TDocument> var2);

    public void findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2, SingleResultCallback<TDocument> var3);

    public void findOneAndDelete(AsyncClientSession var1, Bson var2, SingleResultCallback<TDocument> var3);

    public void findOneAndDelete(AsyncClientSession var1, Bson var2, FindOneAndDeleteOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(Bson var1, TDocument var2, SingleResultCallback<TDocument> var3);

    public void findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(AsyncClientSession var1, Bson var2, TDocument var3, SingleResultCallback<TDocument> var4);

    public void findOneAndReplace(AsyncClientSession var1, Bson var2, TDocument var3, FindOneAndReplaceOptions var4, SingleResultCallback<TDocument> var5);

    public void findOneAndUpdate(Bson var1, Bson var2, SingleResultCallback<TDocument> var3);

    public void findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(AsyncClientSession var1, Bson var2, Bson var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(AsyncClientSession var1, Bson var2, Bson var3, FindOneAndUpdateOptions var4, SingleResultCallback<TDocument> var5);

    public void findOneAndUpdate(Bson var1, List<? extends Bson> var2, SingleResultCallback<TDocument> var3);

    public void findOneAndUpdate(Bson var1, List<? extends Bson> var2, FindOneAndUpdateOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(AsyncClientSession var1, Bson var2, List<? extends Bson> var3, FindOneAndUpdateOptions var4, SingleResultCallback<TDocument> var5);

    public void drop(SingleResultCallback<Void> var1);

    public void drop(AsyncClientSession var1, SingleResultCallback<Void> var2);

    public void createIndex(Bson var1, SingleResultCallback<String> var2);

    public void createIndex(Bson var1, IndexOptions var2, SingleResultCallback<String> var3);

    public void createIndex(AsyncClientSession var1, Bson var2, SingleResultCallback<String> var3);

    public void createIndex(AsyncClientSession var1, Bson var2, IndexOptions var3, SingleResultCallback<String> var4);

    public void createIndexes(List<IndexModel> var1, SingleResultCallback<List<String>> var2);

    public void createIndexes(List<IndexModel> var1, CreateIndexOptions var2, SingleResultCallback<List<String>> var3);

    public void createIndexes(AsyncClientSession var1, List<IndexModel> var2, SingleResultCallback<List<String>> var3);

    public void createIndexes(AsyncClientSession var1, List<IndexModel> var2, CreateIndexOptions var3, SingleResultCallback<List<String>> var4);

    public AsyncListIndexesIterable<Document> listIndexes();

    public <TResult> AsyncListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public AsyncListIndexesIterable<Document> listIndexes(AsyncClientSession var1);

    public <TResult> AsyncListIndexesIterable<TResult> listIndexes(AsyncClientSession var1, Class<TResult> var2);

    public void dropIndex(String var1, SingleResultCallback<Void> var2);

    public void dropIndex(String var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void dropIndex(Bson var1, SingleResultCallback<Void> var2);

    public void dropIndex(Bson var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void dropIndex(AsyncClientSession var1, String var2, SingleResultCallback<Void> var3);

    public void dropIndex(AsyncClientSession var1, String var2, DropIndexOptions var3, SingleResultCallback<Void> var4);

    public void dropIndex(AsyncClientSession var1, Bson var2, SingleResultCallback<Void> var3);

    public void dropIndex(AsyncClientSession var1, Bson var2, DropIndexOptions var3, SingleResultCallback<Void> var4);

    public void dropIndexes(SingleResultCallback<Void> var1);

    public void dropIndexes(DropIndexOptions var1, SingleResultCallback<Void> var2);

    public void dropIndexes(AsyncClientSession var1, SingleResultCallback<Void> var2);

    public void dropIndexes(AsyncClientSession var1, DropIndexOptions var2, SingleResultCallback<Void> var3);

    public void renameCollection(MongoNamespace var1, SingleResultCallback<Void> var2);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2, SingleResultCallback<Void> var3);

    public void renameCollection(AsyncClientSession var1, MongoNamespace var2, SingleResultCallback<Void> var3);

    public void renameCollection(AsyncClientSession var1, MongoNamespace var2, RenameCollectionOptions var3, SingleResultCallback<Void> var4);
}

