/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.transforms.ExtractNewDocumentState;
import io.debezium.schema.FieldNameSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.data.Timestamp;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class MongoDataConverter {
    public static final String SCHEMA_NAME_REGEX = "io.debezium.mongodb.regex";
    private final ExtractNewDocumentState.ArrayEncoding arrayEncoding;
    private final FieldNameSelector.FieldNamer<String> fieldNamer;
    private final boolean sanitizeValue;

    public MongoDataConverter(ExtractNewDocumentState.ArrayEncoding arrayEncoding, FieldNameSelector.FieldNamer<String> fieldNamer, boolean sanitizeValue) {
        this.arrayEncoding = arrayEncoding;
        this.fieldNamer = fieldNamer;
        this.sanitizeValue = sanitizeValue;
    }

    public MongoDataConverter(ExtractNewDocumentState.ArrayEncoding arrayEncoding) {
        this(arrayEncoding, (FieldNameSelector.FieldNamer<String>)FieldNameSelector.defaultNonRelationalSelector((boolean)false), false);
    }

    public Struct convertRecord(Map.Entry<String, BsonValue> keyvalueforStruct, Schema schema, Struct struct) {
        this.convertFieldValue(keyvalueforStruct, struct, schema);
        return struct;
    }

    public void convertFieldValue(Map.Entry<String, BsonValue> keyvalueforStruct, Struct struct, Schema schema) {
        Object colValue = null;
        String key = this.fieldNamer.fieldNameFor((Object)keyvalueforStruct.getKey());
        BsonType type = keyvalueforStruct.getValue().getBsonType();
        switch (type) {
            case NULL: {
                colValue = null;
                break;
            }
            case STRING: {
                colValue = keyvalueforStruct.getValue().asString().getValue().toString();
                break;
            }
            case OBJECT_ID: {
                colValue = keyvalueforStruct.getValue().asObjectId().getValue().toString();
                break;
            }
            case DOUBLE: {
                colValue = keyvalueforStruct.getValue().asDouble().getValue();
                break;
            }
            case BINARY: {
                colValue = keyvalueforStruct.getValue().asBinary().getData();
                break;
            }
            case INT32: {
                colValue = keyvalueforStruct.getValue().asInt32().getValue();
                break;
            }
            case INT64: {
                colValue = keyvalueforStruct.getValue().asInt64().getValue();
                break;
            }
            case BOOLEAN: {
                colValue = keyvalueforStruct.getValue().asBoolean().getValue();
                break;
            }
            case DATE_TIME: {
                colValue = new Date(keyvalueforStruct.getValue().asDateTime().getValue());
                break;
            }
            case JAVASCRIPT: {
                colValue = keyvalueforStruct.getValue().asJavaScript().getCode();
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                Struct jsStruct = new Struct(schema.field(keyvalueforStruct.getKey()).schema());
                Struct jsScopeStruct = new Struct(schema.field(keyvalueforStruct.getKey()).schema().field("scope").schema());
                jsStruct.put("code", (Object)keyvalueforStruct.getValue().asJavaScriptWithScope().getCode());
                BsonDocument jwsDoc = keyvalueforStruct.getValue().asJavaScriptWithScope().getScope().asDocument();
                for (Map.Entry jwsDocKey : jwsDoc.entrySet()) {
                    this.convertFieldValue(jwsDocKey, jsScopeStruct, schema.field(keyvalueforStruct.getKey()).schema());
                }
                jsStruct.put("scope", (Object)jsScopeStruct);
                colValue = jsStruct;
                break;
            }
            case REGULAR_EXPRESSION: {
                Struct regexStruct = new Struct(schema.field(keyvalueforStruct.getKey()).schema());
                regexStruct.put("regex", (Object)keyvalueforStruct.getValue().asRegularExpression().getPattern());
                regexStruct.put("options", (Object)keyvalueforStruct.getValue().asRegularExpression().getOptions());
                colValue = regexStruct;
                break;
            }
            case TIMESTAMP: {
                colValue = new Date(1000L * (long)keyvalueforStruct.getValue().asTimestamp().getTime());
                break;
            }
            case DECIMAL128: {
                colValue = keyvalueforStruct.getValue().asDecimal128().getValue().toString();
                break;
            }
            case DOCUMENT: {
                Field field = schema.field(keyvalueforStruct.getKey());
                if (field == null) {
                    throw new DataException("Failed to find field '" + keyvalueforStruct.getKey() + "' in schema " + schema.name());
                }
                Schema documentSchema = field.schema();
                Struct documentStruct = new Struct(documentSchema);
                BsonDocument docs = keyvalueforStruct.getValue().asDocument();
                for (Map.Entry doc : docs.entrySet()) {
                    this.convertFieldValue(doc, documentStruct, documentSchema);
                }
                colValue = documentStruct;
                break;
            }
            case ARRAY: {
                if (keyvalueforStruct.getValue().asArray().isEmpty()) {
                    if (this.sanitizeValue) {
                        return;
                    }
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            colValue = new ArrayList();
                            break;
                        }
                        case DOCUMENT: {
                            Schema fieldSchema = schema.field(keyvalueforStruct.getKey()).schema();
                            colValue = new Struct(fieldSchema);
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        BsonType valueType = keyvalueforStruct.getValue().asArray().get(0).getBsonType();
                        List arrValues = keyvalueforStruct.getValue().asArray().getValues();
                        ArrayList list = new ArrayList();
                        arrValues.stream().forEach(arrValue -> {
                            Schema valueSchema = Arrays.asList(BsonType.ARRAY, BsonType.DOCUMENT).contains(valueType) ? schema.field((String)keyvalueforStruct.getKey()).schema().valueSchema() : null;
                            this.convertFieldValue(valueSchema, valueType, (BsonValue)arrValue, list);
                        });
                        colValue = list;
                        break;
                    }
                    case DOCUMENT: {
                        BsonArray array = keyvalueforStruct.getValue().asArray();
                        HashMap<String, BsonValue> convertedArray = new HashMap<String, BsonValue>();
                        Schema arraySchema = schema.field(keyvalueforStruct.getKey()).schema();
                        Struct arrayStruct = new Struct(arraySchema);
                        for (int i = 0; i < array.size(); ++i) {
                            convertedArray.put(this.arrayElementStructName(i), array.get(i));
                        }
                        convertedArray.entrySet().forEach(x -> {
                            Schema elementSchema = schema.field(key).schema();
                            this.convertFieldValue((Map.Entry<String, BsonValue>)x, arrayStruct, elementSchema);
                        });
                        colValue = arrayStruct;
                    }
                }
                break;
            }
            default: {
                return;
            }
        }
        struct.put(key, keyvalueforStruct.getValue().isNull() ? null : colValue);
    }

    private void convertFieldValue(Schema valueSchema, BsonType valueType, BsonValue arrValue, ArrayList<Object> list) {
        if (arrValue.getBsonType() == BsonType.STRING && valueType == BsonType.STRING) {
            String temp = arrValue.asString().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.JAVASCRIPT && valueType == BsonType.JAVASCRIPT) {
            String temp = arrValue.asJavaScript().getCode();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.OBJECT_ID && valueType == BsonType.OBJECT_ID) {
            String temp = arrValue.asObjectId().getValue().toString();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DOUBLE && valueType == BsonType.DOUBLE) {
            double temp = arrValue.asDouble().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.BINARY && valueType == BsonType.BINARY) {
            byte[] temp = arrValue.asBinary().getData();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.INT32 && valueType == BsonType.INT32) {
            int temp = arrValue.asInt32().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.INT64 && valueType == BsonType.INT64) {
            long temp = arrValue.asInt64().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DATE_TIME && valueType == BsonType.DATE_TIME) {
            Date temp = new Date(arrValue.asInt64().getValue());
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DECIMAL128 && valueType == BsonType.DECIMAL128) {
            String temp = arrValue.asDecimal128().getValue().toString();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.TIMESTAMP && valueType == BsonType.TIMESTAMP) {
            Date temp = new Date(1000L * (long)arrValue.asInt32().getValue());
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.BOOLEAN && valueType == BsonType.BOOLEAN) {
            boolean temp = arrValue.asBoolean().getValue();
            list.add(temp);
        } else if (arrValue.getBsonType() == BsonType.DOCUMENT && valueType == BsonType.DOCUMENT) {
            Struct struct1 = new Struct(valueSchema);
            for (Map.Entry entry9 : arrValue.asDocument().entrySet()) {
                this.convertFieldValue(entry9, struct1, valueSchema);
            }
            list.add(struct1);
        } else if (arrValue.getBsonType() == BsonType.ARRAY && valueType == BsonType.ARRAY) {
            ArrayList<Object> subList = new ArrayList<Object>();
            Schema subValueSchema = Arrays.asList(BsonType.ARRAY, BsonType.DOCUMENT).contains(arrValue.asArray().get(0).getBsonType()) ? valueSchema.valueSchema() : null;
            for (BsonValue v : arrValue.asArray()) {
                this.convertFieldValue(subValueSchema, v.getBsonType(), v, subList);
            }
            list.add(subList);
        }
    }

    protected String arrayElementStructName(int i) {
        return "_" + i;
    }

    public void addFieldSchema(Map.Entry<String, BsonValue> keyValuesforSchema, SchemaBuilder builder) {
        String key = this.fieldNamer.fieldNameFor((Object)keyValuesforSchema.getKey());
        BsonType type = keyValuesforSchema.getValue().getBsonType();
        switch (type) {
            case NULL: 
            case STRING: 
            case OBJECT_ID: 
            case JAVASCRIPT: 
            case DECIMAL128: {
                builder.field(key, Schema.OPTIONAL_STRING_SCHEMA);
                break;
            }
            case DOUBLE: {
                builder.field(key, Schema.OPTIONAL_FLOAT64_SCHEMA);
                break;
            }
            case BINARY: {
                builder.field(key, Schema.OPTIONAL_BYTES_SCHEMA);
                break;
            }
            case INT32: {
                builder.field(key, Schema.OPTIONAL_INT32_SCHEMA);
                break;
            }
            case INT64: {
                builder.field(key, Schema.OPTIONAL_INT64_SCHEMA);
                break;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                builder.field(key, Timestamp.builder().optional().build());
                break;
            }
            case BOOLEAN: {
                builder.field(key, Schema.OPTIONAL_BOOLEAN_SCHEMA);
                break;
            }
            case JAVASCRIPT_WITH_SCOPE: {
                SchemaBuilder jswithscope = SchemaBuilder.struct().name(builder.name() + "." + key);
                jswithscope.field("code", Schema.OPTIONAL_STRING_SCHEMA);
                SchemaBuilder scope = SchemaBuilder.struct().name(jswithscope.name() + ".scope").optional();
                BsonDocument jwsDocument = keyValuesforSchema.getValue().asJavaScriptWithScope().getScope().asDocument();
                for (Map.Entry jwsDocumentKey : jwsDocument.entrySet()) {
                    this.addFieldSchema(jwsDocumentKey, scope);
                }
                Schema scopeBuild = scope.build();
                jswithscope.field("scope", scopeBuild).build();
                builder.field(key, (Schema)jswithscope);
                break;
            }
            case REGULAR_EXPRESSION: {
                SchemaBuilder regexwop = SchemaBuilder.struct().name(SCHEMA_NAME_REGEX).optional();
                regexwop.field("regex", Schema.OPTIONAL_STRING_SCHEMA);
                regexwop.field("options", Schema.OPTIONAL_STRING_SCHEMA);
                builder.field(key, regexwop.build());
                break;
            }
            case DOCUMENT: {
                SchemaBuilder builderDoc = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                BsonDocument docs = keyValuesforSchema.getValue().asDocument();
                for (Map.Entry doc : docs.entrySet()) {
                    this.addFieldSchema(doc, builderDoc);
                }
                builder.field(key, builderDoc.build());
                break;
            }
            case ARRAY: {
                if (keyValuesforSchema.getValue().asArray().isEmpty()) {
                    if (this.sanitizeValue) {
                        return;
                    }
                    switch (this.arrayEncoding) {
                        case ARRAY: {
                            builder.field(key, SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
                            break;
                        }
                        case DOCUMENT: {
                            builder.field(key, SchemaBuilder.struct().name(builder.name() + "." + key).optional().build());
                        }
                    }
                    break;
                }
                switch (this.arrayEncoding) {
                    case ARRAY: {
                        BsonArray value = keyValuesforSchema.getValue().asArray();
                        BsonType valueType = value.get(0).getBsonType();
                        this.testType(builder, key, keyValuesforSchema.getValue(), valueType);
                        builder.field(key, SchemaBuilder.array((Schema)this.subSchema(builder, key, valueType, (BsonValue)value)).optional().build());
                        break;
                    }
                    case DOCUMENT: {
                        BsonArray array = keyValuesforSchema.getValue().asArray();
                        SchemaBuilder arrayStructBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                        HashMap<String, BsonValue> convertedArray = new HashMap<String, BsonValue>();
                        for (int i = 0; i < array.size(); ++i) {
                            convertedArray.put(this.arrayElementStructName(i), array.get(i));
                        }
                        convertedArray.entrySet().forEach(x -> this.addFieldSchema((Map.Entry<String, BsonValue>)x, arrayStructBuilder));
                        builder.field(key, arrayStructBuilder.build());
                    }
                }
                break;
            }
        }
    }

    private Schema subSchema(SchemaBuilder builder, String key, BsonType valueType, BsonValue value) {
        switch (valueType) {
            case NULL: 
            case STRING: 
            case OBJECT_ID: 
            case JAVASCRIPT: 
            case DECIMAL128: {
                return Schema.OPTIONAL_STRING_SCHEMA;
            }
            case DOUBLE: {
                return Schema.OPTIONAL_FLOAT64_SCHEMA;
            }
            case BINARY: {
                return Schema.OPTIONAL_BYTES_SCHEMA;
            }
            case INT32: {
                return Schema.OPTIONAL_INT32_SCHEMA;
            }
            case INT64: {
                return Schema.OPTIONAL_INT64_SCHEMA;
            }
            case DATE_TIME: 
            case TIMESTAMP: {
                return Timestamp.builder().optional().build();
            }
            case BOOLEAN: {
                return Schema.OPTIONAL_BOOLEAN_SCHEMA;
            }
            case DOCUMENT: {
                SchemaBuilder documentSchemaBuilder = SchemaBuilder.struct().name(builder.name() + "." + key).optional();
                HashMap<String, BsonType> union = new HashMap<String, BsonType>();
                if (value.isArray()) {
                    for (BsonValue element : value.asArray()) {
                        this.subSchema(documentSchemaBuilder, union, element.asDocument());
                    }
                } else {
                    this.subSchema(documentSchemaBuilder, union, value.asDocument());
                }
                return documentSchemaBuilder.build();
            }
            case ARRAY: {
                BsonType subValueType = value.asArray().get(0).asArray().get(0).getBsonType();
                return SchemaBuilder.array((Schema)this.subSchema(builder, key, subValueType, value.asArray().get(0))).optional().build();
            }
        }
        throw new IllegalArgumentException("The value type '" + valueType + " is not yet supported inside for a subSchema.");
    }

    private void subSchema(SchemaBuilder documentSchemaBuilder, Map<String, BsonType> union, BsonDocument arrayDocs) {
        for (Map.Entry arrayDoc : arrayDocs.entrySet()) {
            BsonType prevType = union.putIfAbsent((String)arrayDoc.getKey(), ((BsonValue)arrayDoc.getValue()).getBsonType());
            if (prevType == null) {
                this.addFieldSchema(arrayDoc, documentSchemaBuilder);
                continue;
            }
            if (prevType == ((BsonValue)arrayDoc.getValue()).getBsonType()) continue;
            throw new ConnectException("Field " + (String)arrayDoc.getKey() + " of schema " + documentSchemaBuilder.name() + " is not the same type for all documents in the array.\nCheck option 'struct' of parameter 'array.encoding'");
        }
    }

    private void testType(SchemaBuilder builder, String key, BsonValue value, BsonType valueType) {
        if (valueType == BsonType.DOCUMENT) {
            HashMap union = new HashMap();
            for (BsonValue element : value.asArray()) {
                BsonDocument arrayDocs = element.asDocument();
                for (Map.Entry arrayDoc : arrayDocs.entrySet()) {
                    BsonType prevType = union.putIfAbsent(arrayDoc.getKey(), ((BsonValue)arrayDoc.getValue()).getBsonType());
                    if (prevType == null || prevType == ((BsonValue)arrayDoc.getValue()).getBsonType()) continue;
                    throw new ConnectException("Field " + (String)arrayDoc.getKey() + " of schema " + builder.name() + " is not the same type for all documents in the array.\nCheck option 'struct' of parameter 'array.encoding'");
                }
            }
        } else if (valueType == BsonType.ARRAY) {
            for (BsonValue element : value.asArray()) {
                BsonType subValueType = element.asArray().get(0).getBsonType();
                this.testType(builder, key, element, subValueType);
            }
        } else {
            for (BsonValue element : value.asArray()) {
                if (element.getBsonType() == valueType) continue;
                throw new ConnectException("Field " + key + " of schema " + builder.name() + " is not a homogenous array.\nCheck option 'struct' of parameter 'array.encoding'");
            }
        }
    }
}

