/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.LegacyV1MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbSourceInfoStructMaker;
import io.debezium.connector.mongodb.ReplicaSets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class MongoDbConnectorConfig
extends CommonConnectorConfig {
    protected static final String COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"collection.include.list\" or \"collection.whitelist\" is already specified";
    protected static final String DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG = "\"database.include.list\" or \"database.whitelist\" is already specified";
    protected static final int DEFAULT_SNAPSHOT_FETCH_SIZE = 0;
    public static final Field HOSTS = Field.create((String)"mongodb.hosts").withDisplayName("Hosts").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{MongoDbConnectorConfig::validateHosts}).withDescription("The hostname and port pairs (in the form 'host' or 'host:port') of the MongoDB server(s) in the replica set.");
    public static final Field LOGICAL_NAME = Field.create((String)"mongodb.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Unique name that identifies the MongoDB replica set or cluster and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct MongoDB installation should have a separate namespace and monitored by at most one Debezium connector.");
    public static final Field USER = Field.create((String)"mongodb.user").withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Database user for connecting to MongoDB, if necessary.");
    public static final Field PASSWORD = Field.create((String)"mongodb.password").withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password to be used when connecting to MongoDB, if necessary.");
    public static final Field AUTH_SOURCE = Field.create((String)"mongodb.authsource").withDisplayName("Credentials Database").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault("admin").withDescription("Database containing user credentials.");
    @Deprecated
    public static final Field POLL_INTERVAL_SEC = Field.create((String)"mongodb.poll.interval.sec").withDisplayName("Replica membership poll interval (sec)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("(Deprecated, use mongodb.poll.interval.ms) Frequency in seconds to look for new, removed, or changed replica sets. Defaults to 30 seconds.");
    public static final Field MONGODB_POLL_INTERVAL_MS = Field.create((String)"mongodb.poll.interval.ms").withDisplayName("Replica membership poll interval (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(30000L).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Frequency in milliseconds to look for new, removed, or changed replica sets.  Defaults to 30000 milliseconds.");
    public static final Field SSL_ENABLED = Field.create((String)"mongodb.ssl.enabled").withDisplayName("Enable SSL connection to MongoDB").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Should connector use SSL to connect to MongoDB instances");
    public static final Field SSL_ALLOW_INVALID_HOSTNAMES = Field.create((String)"mongodb.ssl.invalid.hostname.allowed").withDisplayName("Allow invalid hostnames for SSL connection").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Whether invalid host names are allowed when using SSL. If true the connection will not prevent man-in-the-middle attacks");
    public static final Field MAX_COPY_THREADS = Field.create((String)"initial.sync.max.threads").withDisplayName("Maximum number of threads for initial sync").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Maximum number of threads used to perform an initial sync of the collections in a replica set. Defaults to 1.");
    public static final Field CONNECT_BACKOFF_INITIAL_DELAY_MS = Field.create((String)"connect.backoff.initial.delay.ms").withDisplayName("Initial delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(1L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The initial delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 1 second (1000 ms).");
    public static final Field CONNECT_BACKOFF_MAX_DELAY_MS = Field.create((String)"connect.backoff.max.delay.ms").withDisplayName("Maximum delay before reconnection (ms)").withType(ConfigDef.Type.LONG).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(TimeUnit.SECONDS.toMillis(120L)).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("The maximum delay when trying to reconnect to a primary after a connection cannot be made or when no primary is available. Defaults to 120 second (120,000 ms).");
    public static final Field MAX_FAILED_CONNECTIONS = Field.create((String)"connect.max.attempts").withDisplayName("Connection attempt limit").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(16).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Maximum number of failed connection attempts to a replica set primary before an exception occurs and task is aborted. Defaults to 16, which with the defaults for '" + CONNECT_BACKOFF_INITIAL_DELAY_MS + "' and '" + CONNECT_BACKOFF_MAX_DELAY_MS + "' results in just over 20 minutes of attempts before failing.");
    public static final Field AUTO_DISCOVER_MEMBERS = Field.create((String)"mongodb.members.auto.discover").withDisplayName("Auto-discovery").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(true).withValidation(new Field.Validator[]{Field::isBoolean}).withDescription("Specifies whether the addresses in 'hosts' are seeds that should be used to discover all members of the cluster or replica set ('true'), or whether the address(es) in 'hosts' should be used as is ('false'). The default is 'true'.");
    public static final Field DATABASE_INCLUDE_LIST = Field.create((String)"database.include.list").withDisplayName("Include Databases").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateDatabaseExcludeList}).withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be captured");
    @Deprecated
    public static final Field DATABASE_WHITELIST = Field.create((String)"database.whitelist").withDisplayName("Deprecated: Include Databases").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateDatabaseExcludeList}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be captured (deprecated, use \"" + DATABASE_INCLUDE_LIST.name() + "\" instead)");
    public static final Field DATABASE_EXCLUDE_LIST = Field.create((String)"database.exclude.list").withDisplayName("Exclude Databases").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be excluded");
    @Deprecated
    public static final Field DATABASE_BLACKLIST = Field.create((String)"database.blacklist").withDisplayName("Deprecated: Exclude Databases").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isListOfRegex}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the database names for which changes are to be excluded (deprecated, use \"" + DATABASE_EXCLUDE_LIST.name() + "\" instead)");
    public static final Field COLLECTION_INCLUDE_LIST = Field.create((String)"collection.include.list").withDisplayName("Include Collections").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateCollectionExcludeList}).withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be captured");
    @Deprecated
    public static final Field COLLECTION_WHITELIST = Field.create((String)"collection.whitelist").withDisplayName("Deprecated: Include Collections").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withValidation(new Field.Validator[]{Field::isListOfRegex, MongoDbConnectorConfig::validateCollectionExcludeList}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be captured (deprecated, use \"" + COLLECTION_INCLUDE_LIST.name() + "\" instead)");
    public static final Field COLLECTION_EXCLUDE_LIST = Field.create((String)"collection.exclude.list").withValidation(new Field.Validator[]{Field::isListOfRegex}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be excluded");
    @Deprecated
    public static final Field COLLECTION_BLACKLIST = Field.create((String)"collection.blacklist").withValidation(new Field.Validator[]{Field::isListOfRegex}).withInvisibleRecommender().withDescription("A comma-separated list of regular expressions that match the collection names for which changes are to be excluded (deprecated, use \"" + COLLECTION_EXCLUDE_LIST.name() + "\" instead)");
    public static final Field FIELD_EXCLUDE_LIST = Field.create((String)"field.exclude.list").withDisplayName("Exclude Fields").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A comma-separated list of the fully-qualified names of fields that should be excluded from change event message values");
    @Deprecated
    public static final Field FIELD_BLACKLIST = Field.create((String)"field.blacklist").withDisplayName("Deprecated: Exclude Fields").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withInvisibleRecommender().withDescription("A comma-separated list of the fully-qualified names of fields that should be excluded from change event message values (deprecated, use \"" + FIELD_EXCLUDE_LIST.name() + "\" instead)");
    public static final Field FIELD_RENAMES = Field.create((String)"field.renames").withDisplayName("Rename Fields").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'initial' (the default) to specify the connector should always perform an initial sync when required; 'never' to specify the connector should never perform an initial sync ");
    public static final Field CONNECT_TIMEOUT_MS = Field.create((String)"mongodb.connect.timeout.ms").withDisplayName("Connect Timeout MS").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("The connection timeout in milliseconds");
    public static final Field SERVER_SELECTION_TIMEOUT_MS = Field.create((String)"mongodb.server.selection.timeout.ms").withDisplayName("Server selection timeout MS").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(30000).withDescription("The server selection timeout in milliseconds");
    public static final Field SOCKET_TIMEOUT_MS = Field.create((String)"mongodb.socket.timeout.ms").withDisplayName("Socket timeout MS").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(0).withDescription("The socket timeout in milliseconds");
    protected static final Field TASK_ID = Field.create((String)"mongodb.task.id").withDescription("Internal use only").withValidation(new Field.Validator[]{Field::isInteger}).withInvisibleRecommender();
    public static final Field SNAPSHOT_FILTER_QUERY_BY_COLLECTION = Field.create((String)"snapshot.collection.filter.overrides").withDisplayName("Snapshot mode").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("This property contains a comma-separated list of <dbName>.<collectionName>, for which  the initial snapshot may be a subset of data present in the data source. The subset would be defined by mongodb filter query specified as value for property snapshot.collection.filter.override.<dbname>.<collectionName>");
    private static final ConfigDefinition CONFIG_DEFINITION = CommonConnectorConfig.CONFIG_DEFINITION.edit().name("MongoDB").type(new Field[]{HOSTS, USER, PASSWORD, AUTH_SOURCE, LOGICAL_NAME, CONNECT_BACKOFF_INITIAL_DELAY_MS, CONNECT_BACKOFF_MAX_DELAY_MS, CONNECT_TIMEOUT_MS, SOCKET_TIMEOUT_MS, SERVER_SELECTION_TIMEOUT_MS, POLL_INTERVAL_SEC, MONGODB_POLL_INTERVAL_MS, MAX_FAILED_CONNECTIONS, AUTO_DISCOVER_MEMBERS, SSL_ENABLED, SSL_ALLOW_INVALID_HOSTNAMES}).events(new Field[]{DATABASE_WHITELIST, DATABASE_INCLUDE_LIST, DATABASE_BLACKLIST, DATABASE_EXCLUDE_LIST, COLLECTION_WHITELIST, COLLECTION_INCLUDE_LIST, COLLECTION_BLACKLIST, COLLECTION_EXCLUDE_LIST, FIELD_BLACKLIST, FIELD_EXCLUDE_LIST, FIELD_RENAMES, SNAPSHOT_FILTER_QUERY_BY_COLLECTION}).connector(new Field[]{MAX_COPY_THREADS, SNAPSHOT_MODE}).create();
    public static Field.Set ALL_FIELDS;
    protected static Field.Set EXPOSED_FIELDS;
    private final SnapshotMode snapshotMode;

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }

    public MongoDbConnectorConfig(Configuration config) {
        super(config, config.getString(LOGICAL_NAME), 0);
        String snapshotModeValue = config.getString(SNAPSHOT_MODE);
        this.snapshotMode = SnapshotMode.parse(snapshotModeValue, SNAPSHOT_MODE.defaultValueAsString());
    }

    private static int validateHosts(Configuration config, Field field, Field.ValidationOutput problems) {
        String hosts = config.getString(field);
        if (hosts == null) {
            problems.accept(field, (Object)hosts, "Host specification is required");
            return 1;
        }
        int count = 0;
        if (ReplicaSets.parse(hosts).all().isEmpty()) {
            problems.accept(field, (Object)hosts, "Invalid host specification");
            ++count;
        }
        return count;
    }

    private static int validateCollectionExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getFallbackStringProperty(COLLECTION_INCLUDE_LIST, COLLECTION_WHITELIST);
        String excludeList = config.getFallbackStringProperty(COLLECTION_EXCLUDE_LIST, COLLECTION_BLACKLIST);
        if (includeList != null && excludeList != null) {
            problems.accept(COLLECTION_EXCLUDE_LIST, (Object)excludeList, COLLECTION_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    private static int validateDatabaseExcludeList(Configuration config, Field field, Field.ValidationOutput problems) {
        String includeList = config.getFallbackStringProperty(DATABASE_INCLUDE_LIST, DATABASE_WHITELIST);
        String excludeList = config.getFallbackStringProperty(DATABASE_EXCLUDE_LIST, DATABASE_BLACKLIST);
        if (includeList != null && excludeList != null) {
            problems.accept(DATABASE_EXCLUDE_LIST, (Object)excludeList, DATABASE_INCLUDE_LIST_ALREADY_SPECIFIED_ERROR_MSG);
            return 1;
        }
        return 0;
    }

    public SnapshotMode getSnapshotMode() {
        return this.snapshotMode;
    }

    protected SourceInfoStructMaker<? extends AbstractSourceInfo> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
        switch (version) {
            case V1: {
                return new LegacyV1MongoDbSourceInfoStructMaker(Module.name(), Module.version(), this);
            }
        }
        return new MongoDbSourceInfoStructMaker(Module.name(), Module.version(), this);
    }

    public Optional<String> getSnapshotFilterQueryForCollection(CollectionId collectionId) {
        return Optional.ofNullable(this.getSnapshotFilterQueryByCollection().get(collectionId.dbName() + "." + collectionId.name()));
    }

    public Map<String, String> getSnapshotFilterQueryByCollection() {
        String collectionList = this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION);
        if (collectionList == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> snapshotFilterQueryByCollection = new HashMap<String, String>();
        for (String collection : collectionList.split(",")) {
            snapshotFilterQueryByCollection.put(collection, this.getConfig().getString(SNAPSHOT_FILTER_QUERY_BY_COLLECTION + "." + collection));
        }
        return Collections.unmodifiableMap(snapshotFilterQueryByCollection);
    }

    public String getContextName() {
        return Module.contextName();
    }

    public String getConnectorName() {
        return Module.name();
    }

    static {
        EXPOSED_FIELDS = ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        INITIAL("initial", true),
        NEVER("never", false);

        private final String value;
        private final boolean includeData;

        private SnapshotMode(String value, boolean includeData) {
            this.value = value;
            this.includeData = includeData;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

