/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.util.Testing;

public class Configurator {
    private Configuration.Builder configBuilder = Configuration.create();

    public Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, boolean value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator with(Field field, int value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator serverName(String serverName) {
        return this.with(MongoDbConnectorConfig.LOGICAL_NAME, serverName);
    }

    public Configurator hosts(String hosts) {
        return this.with(MongoDbConnectorConfig.HOSTS, hosts);
    }

    public Configurator maxBatchSize(int maxBatchSize) {
        return this.with(MongoDbConnectorConfig.MAX_BATCH_SIZE, maxBatchSize);
    }

    public Configurator includeDatabases(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_WHITELIST.name() + "\" config property"));
            return this.with(MongoDbConnectorConfig.DATABASE_WHITELIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.DATABASE_INCLUDE_LIST, regexList);
    }

    public Configurator excludeDatabases(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_BLACKLIST.name() + "\" config property"));
            return this.with(MongoDbConnectorConfig.DATABASE_BLACKLIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST, regexList);
    }

    public Configurator includeCollections(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_WHITELIST.name() + "\" config property"));
            return this.with(MongoDbConnectorConfig.COLLECTION_WHITELIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, regexList);
    }

    public Configurator excludeCollections(String regexList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_BLACKLIST.name() + "\" config property"));
            return this.with(MongoDbConnectorConfig.COLLECTION_BLACKLIST, regexList);
        }
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST, regexList);
    }

    public Configurator excludeFields(String excludeList) {
        if (Math.random() >= 0.5) {
            Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.FIELD_BLACKLIST.name() + "\" config property"));
            return this.with(MongoDbConnectorConfig.FIELD_BLACKLIST, excludeList);
        }
        Testing.debug((Object)("Using \"" + MongoDbConnectorConfig.FIELD_EXCLUDE_LIST.name() + "\" config property"));
        return this.with(MongoDbConnectorConfig.FIELD_EXCLUDE_LIST, excludeList);
    }

    public Configurator renameFields(String renames) {
        return this.with(MongoDbConnectorConfig.FIELD_RENAMES, renames);
    }

    public Filters createFilters() {
        return new Filters(this.configBuilder.build());
    }
}

