/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.transforms.MongoDataConverter;
import io.debezium.data.Envelope;
import io.debezium.schema.FieldNameSelector;
import io.debezium.transforms.ExtractNewRecordStateConfigDefinition;
import io.debezium.transforms.SmtManager;
import io.debezium.util.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.header.ConnectHeaders;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.transforms.ExtractField;
import org.apache.kafka.connect.transforms.Flatten;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.SchemaUtil;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractNewDocumentState<R extends ConnectRecord<R>>
implements Transformation<R> {
    private String addFieldsPrefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractNewDocumentState.class);
    private static final Pattern FIELD_SEPARATOR = Pattern.compile("\\.");
    private static final io.debezium.config.Field ARRAY_ENCODING = io.debezium.config.Field.create((String)"array.encoding").withDisplayName("Array encoding").withEnum(ArrayEncoding.class, (Enum)ArrayEncoding.ARRAY).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The arrays can be encoded using 'array' schema type (the default) or as a 'document' (similar to how BSON encodes arrays). 'array' is easier to consume but requires all elements in the array to be of the same type. Use 'document' if the arrays in data source mix different types together.");
    private static final io.debezium.config.Field FLATTEN_STRUCT = io.debezium.config.Field.create((String)"flatten.struct").withDisplayName("Flatten struct").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Flattening structs by concatenating the fields into plain properties, using a (configurable) delimiter.");
    private static final io.debezium.config.Field DELIMITER = io.debezium.config.Field.create((String)"flatten.struct.delimiter").withDisplayName("Delimiter for flattened struct").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_").withDescription("Delimiter to concat between field names from the input record when generating field names for theoutput record.");
    public static final io.debezium.config.Field SANITIZE_FIELD_NAMES = io.debezium.config.Field.create((String)"sanitize.field.names").withDisplayName("Sanitize field names to adhere to Avro naming conventions").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Whether field names will be sanitized to Avro naming conventions").withDefault(Boolean.FALSE.booleanValue());
    public static final io.debezium.config.Field ADD_SOURCE_FIELDS = io.debezium.config.Field.create((String)"add.source.fields").withDisplayName("Adds the specified fields from the 'source' field from the payload if they exist.").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDefault("").withDescription("DEPRECATED. Please use the 'add.fields' option instead. Adds each field listed from the 'source' element of the payload, prefixed with __ Example: 'version,connector' would add __version and __connector fields");
    public static final io.debezium.config.Field OPERATION_HEADER = io.debezium.config.Field.create((String)"operation.header").withDisplayName("Adds a message header representing the applied operation").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("DEPRECATED. Please use the 'add.fields' option instead. Adds the operation type of the change event as a header.Its key is '__op'");
    private final ExtractField<R> afterExtractor = new ExtractField.Value();
    private final ExtractField<R> patchExtractor = new ExtractField.Value();
    private final ExtractField<R> keyExtractor = new ExtractField.Key();
    private MongoDataConverter converter;
    private final Flatten<R> recordFlattener = new Flatten.Value();
    private boolean addOperationHeader;
    private List<String> addSourceFields;
    private List<FieldReference> additionalHeaders;
    private List<FieldReference> additionalFields;
    private boolean flattenStruct;
    private String delimiter;
    private boolean dropTombstones;
    private ExtractNewRecordStateConfigDefinition.DeleteHandling handleDeletes;
    private SmtManager<R> smtManager;

    public R apply(R record) {
        if (!this.smtManager.isValidKey(record)) {
            return record;
        }
        ConnectRecord keyRecord = this.keyExtractor.apply(record);
        BsonDocument keyDocument = BsonDocument.parse((String)("{ \"id\" : " + keyRecord.key().toString() + "}"));
        BsonDocument valueDocument = new BsonDocument();
        if (record.value() == null) {
            if (this.dropTombstones) {
                LOGGER.trace("Tombstone {} arrived and requested to be dropped", record.key());
                return null;
            }
            if (!this.additionalHeaders.isEmpty()) {
                Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
                headersToAdd.forEach(h -> record.headers().add(h));
            } else if (this.addOperationHeader) {
                LOGGER.warn("operation.header has been deprecated and is scheduled for removal.  Use add.headers instead.");
                record.headers().addString("__op", Envelope.Operation.DELETE.code());
            }
            return this.newRecord(record, keyDocument, valueDocument);
        }
        if (!this.smtManager.isValidEnvelope(record)) {
            return record;
        }
        ConnectRecord afterRecord = this.afterExtractor.apply(record);
        ConnectRecord patchRecord = this.patchExtractor.apply(record);
        if (!this.additionalHeaders.isEmpty()) {
            Headers headersToAdd = this.makeHeaders(this.additionalHeaders, (Struct)record.value());
            headersToAdd.forEach(h -> record.headers().add(h));
        } else if (this.addOperationHeader) {
            LOGGER.warn("operation.header has been deprecated and is scheduled for removal.  Use add.headers instead.");
            record.headers().addString("__op", ((Struct)record.value()).get("op").toString());
        }
        if (afterRecord.value() != null) {
            valueDocument = this.getInsertDocument(afterRecord, keyDocument);
        }
        if (afterRecord.value() == null && patchRecord.value() != null) {
            valueDocument = this.getUpdateDocument(patchRecord, keyDocument);
        }
        boolean isDeletion = false;
        if (afterRecord.value() == null && patchRecord.value() == null) {
            if (this.handleDeletes.equals((Object)ExtractNewRecordStateConfigDefinition.DeleteHandling.DROP)) {
                LOGGER.trace("Delete {} arrived and requested to be dropped", record.key());
                return null;
            }
            isDeletion = true;
        }
        if (this.handleDeletes.equals((Object)ExtractNewRecordStateConfigDefinition.DeleteHandling.REWRITE)) {
            valueDocument.append("__deleted", (BsonValue)new BsonBoolean(isDeletion));
        }
        return this.newRecord(record, keyDocument, valueDocument);
    }

    private R newRecord(R record, BsonDocument keyDocument, BsonDocument valueDocument) {
        SchemaBuilder keySchemaBuilder = SchemaBuilder.struct();
        Set keyPairs = keyDocument.entrySet();
        for (Map.Entry keyPairsForSchema : keyPairs) {
            this.converter.addFieldSchema(keyPairsForSchema, keySchemaBuilder);
        }
        Schema finalKeySchema = keySchemaBuilder.build();
        Struct finalKeyStruct = new Struct(finalKeySchema);
        for (Map.Entry keyPairsForStruct : keyPairs) {
            this.converter.convertRecord(keyPairsForStruct, finalKeySchema, finalKeyStruct);
        }
        Schema finalValueSchema = null;
        Struct finalValueStruct = null;
        if (valueDocument.size() > 0) {
            BsonDocument val1;
            String newValueSchemaName = record.valueSchema().name();
            if (Envelope.isEnvelopeSchema((String)newValueSchemaName)) {
                newValueSchemaName = newValueSchemaName.substring(0, newValueSchemaName.length() - 9);
            }
            SchemaBuilder valueSchemaBuilder = SchemaBuilder.struct().name(newValueSchemaName);
            Set valuePairs = valueDocument.entrySet();
            for (Map.Entry valuePairsForSchema : valuePairs) {
                if (((String)valuePairsForSchema.getKey()).equalsIgnoreCase("$set")) {
                    val1 = BsonDocument.parse((String)((BsonValue)valuePairsForSchema.getValue()).toString());
                    Set keyValuesForSetSchema = val1.entrySet();
                    for (Map.Entry keyValuesForSetSchemaEntry : keyValuesForSetSchema) {
                        this.converter.addFieldSchema(keyValuesForSetSchemaEntry, valueSchemaBuilder);
                    }
                    continue;
                }
                this.converter.addFieldSchema(valuePairsForSchema, valueSchemaBuilder);
            }
            if (this.addSourceFields != null) {
                this.addSourceFieldsSchema(this.addFieldsPrefix, this.addSourceFields, record, valueSchemaBuilder);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addAdditionalFieldsSchema(this.additionalFields, record, valueSchemaBuilder);
            }
            finalValueSchema = valueSchemaBuilder.build();
            finalValueStruct = new Struct(finalValueSchema);
            for (Map.Entry valuePairsForStruct : valuePairs) {
                if (((String)valuePairsForStruct.getKey()).equalsIgnoreCase("$set")) {
                    val1 = BsonDocument.parse((String)((BsonValue)valuePairsForStruct.getValue()).toString());
                    Set keyValueForSetStruct = val1.entrySet();
                    for (Map.Entry keyValueForSetStructEntry : keyValueForSetStruct) {
                        this.converter.convertRecord(keyValueForSetStructEntry, finalValueSchema, finalValueStruct);
                    }
                    continue;
                }
                this.converter.convertRecord(valuePairsForStruct, finalValueSchema, finalValueStruct);
            }
            if (this.addSourceFields != null) {
                this.addSourceFieldsValue(this.addSourceFields, record, finalValueStruct);
            }
            if (!this.additionalFields.isEmpty()) {
                this.addFields(this.additionalFields, record, finalValueStruct);
            }
        }
        ConnectRecord newRecord = record.newRecord(record.topic(), record.kafkaPartition(), finalKeySchema, (Object)finalKeyStruct, finalValueSchema, finalValueStruct, record.timestamp());
        if (this.flattenStruct) {
            return (R)this.recordFlattener.apply(newRecord);
        }
        return (R)newRecord;
    }

    private void addSourceFieldsSchema(String fieldPrefix, List<String> addSourceFields, R originalRecord, SchemaBuilder valueSchemaBuilder) {
        Schema sourceSchema = originalRecord.valueSchema().field("source").schema();
        for (String sourceField : addSourceFields) {
            if (sourceSchema.field(sourceField) == null) {
                throw new ConfigException("Source field specified in 'add.source.fields' does not exist: " + sourceField);
            }
            valueSchemaBuilder.field(fieldPrefix + sourceField, sourceSchema.field(sourceField).schema());
        }
    }

    private void addAdditionalFieldsSchema(List<FieldReference> additionalFields, R originalRecord, SchemaBuilder valueSchemaBuilder) {
        Schema sourceSchema = originalRecord.valueSchema();
        for (FieldReference fieldReference : additionalFields) {
            valueSchemaBuilder.field(fieldReference.newFieldName, fieldReference.getSchema(sourceSchema));
        }
    }

    private void addSourceFieldsValue(List<String> addSourceFields, R originalRecord, Struct valueStruct) {
        Struct sourceValue = ((Struct)originalRecord.value()).getStruct("source");
        for (String sourceField : addSourceFields) {
            valueStruct.put("__" + sourceField, sourceValue.get(sourceField));
        }
    }

    private void addFields(List<FieldReference> additionalFields, R originalRecord, Struct value) {
        Struct originalRecordValue = (Struct)originalRecord.value();
        for (FieldReference fieldReference : additionalFields) {
            value.put(fieldReference.newFieldName, fieldReference.getValue(originalRecordValue));
        }
    }

    private BsonDocument getUpdateDocument(R patchRecord, BsonDocument keyDocument) {
        BsonDocument valueDocument = new BsonDocument();
        BsonDocument document = BsonDocument.parse((String)patchRecord.value().toString());
        if (document.containsKey((Object)"$set")) {
            valueDocument = document.getDocument((Object)"$set");
        }
        if (document.containsKey((Object)"$unset")) {
            Set unsetDocumentEntry = document.getDocument((Object)"$unset").entrySet();
            for (Map.Entry valueEntry : unsetDocumentEntry) {
                if (!((BsonValue)valueEntry.getValue()).asBoolean().getValue()) continue;
                valueDocument.append((String)valueEntry.getKey(), (BsonValue)new BsonNull());
            }
        }
        if (!document.containsKey((Object)"$set") && !document.containsKey((Object)"$unset")) {
            if (!document.containsKey((Object)"_id")) {
                throw new ConnectException("Unable to process Mongo Operation, a '$set' or '$unset' is necessary for partial updates or '_id' is expected for full Document replaces.");
            }
            valueDocument = document;
            valueDocument.remove((Object)"_id");
        }
        if (!valueDocument.containsKey((Object)"id")) {
            valueDocument.append("id", keyDocument.get((Object)"id"));
        }
        if (this.flattenStruct) {
            BsonDocument newDocument = new BsonDocument();
            valueDocument.forEach((fKey, fValue) -> newDocument.put(fKey.replace(".", this.delimiter), fValue));
            valueDocument = newDocument;
        }
        return valueDocument;
    }

    private BsonDocument getInsertDocument(R record, BsonDocument key) {
        BsonDocument valueDocument = BsonDocument.parse((String)record.value().toString());
        valueDocument.remove((Object)"_id");
        valueDocument.append("id", key.get((Object)"id"));
        return valueDocument;
    }

    private Headers makeHeaders(List<FieldReference> additionalHeaders, Struct originalRecordValue) {
        ConnectHeaders headers = new ConnectHeaders();
        for (FieldReference fieldReference : additionalHeaders) {
            if (originalRecordValue == null) {
                if (!"op".equals(fieldReference.field)) continue;
                headers.addString(fieldReference.newFieldName, Envelope.Operation.DELETE.code());
                continue;
            }
            headers.add(fieldReference.getNewFieldName(), fieldReference.getValue(originalRecordValue), fieldReference.getSchema(originalRecordValue.schema()));
        }
        return headers;
    }

    public ConfigDef config() {
        ConfigDef config = new ConfigDef();
        io.debezium.config.Field.group((ConfigDef)config, null, (io.debezium.config.Field[])new io.debezium.config.Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER, SANITIZE_FIELD_NAMES});
        return config;
    }

    public void close() {
    }

    public void configure(Map<String, ?> map) {
        Configuration config = Configuration.from(map);
        this.smtManager = new SmtManager(config);
        Field.Set configFields = io.debezium.config.Field.setOf((io.debezium.config.Field[])new io.debezium.config.Field[]{ARRAY_ENCODING, FLATTEN_STRUCT, DELIMITER, OPERATION_HEADER, ADD_SOURCE_FIELDS, ExtractNewRecordStateConfigDefinition.HANDLE_DELETES, ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES, ExtractNewRecordStateConfigDefinition.ADD_HEADERS, ExtractNewRecordStateConfigDefinition.ADD_FIELDS, SANITIZE_FIELD_NAMES});
        if (!config.validateAndRecord((Iterable)configFields, arg_0 -> ((Logger)LOGGER).error(arg_0))) {
            throw new ConnectException("Unable to validate config.");
        }
        this.converter = new MongoDataConverter(ArrayEncoding.parse(config.getString(ARRAY_ENCODING)), (FieldNameSelector.FieldNamer<String>)FieldNameSelector.defaultNonRelationalSelector((boolean)config.getBoolean(SANITIZE_FIELD_NAMES)));
        this.addOperationHeader = config.getBoolean(OPERATION_HEADER);
        this.addSourceFields = ExtractNewDocumentState.determineAdditionalSourceField(config.getString(ADD_SOURCE_FIELDS));
        this.addFieldsPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS_PREFIX);
        String addHeadersPrefix = config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS_PREFIX);
        this.additionalHeaders = FieldReference.fromConfiguration(addHeadersPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_HEADERS));
        this.additionalFields = FieldReference.fromConfiguration(this.addFieldsPrefix, config.getString(ExtractNewRecordStateConfigDefinition.ADD_FIELDS));
        this.flattenStruct = config.getBoolean(FLATTEN_STRUCT);
        this.delimiter = config.getString(DELIMITER);
        this.dropTombstones = config.getBoolean(ExtractNewRecordStateConfigDefinition.DROP_TOMBSTONES);
        this.handleDeletes = ExtractNewRecordStateConfigDefinition.DeleteHandling.parse((String)config.getString(ExtractNewRecordStateConfigDefinition.HANDLE_DELETES));
        HashMap<String, String> afterExtractorConfig = new HashMap<String, String>();
        afterExtractorConfig.put("field", "after");
        HashMap<String, String> patchExtractorConfig = new HashMap<String, String>();
        patchExtractorConfig.put("field", "patch");
        HashMap<String, String> keyExtractorConfig = new HashMap<String, String>();
        keyExtractorConfig.put("field", "id");
        this.afterExtractor.configure(afterExtractorConfig);
        this.patchExtractor.configure(patchExtractorConfig);
        this.keyExtractor.configure(keyExtractorConfig);
        HashMap<String, String> delegateConfig = new HashMap<String, String>();
        delegateConfig.put("delimiter", this.delimiter);
        this.recordFlattener.configure(delegateConfig);
    }

    private static List<String> determineAdditionalSourceField(String addSourceFieldsConfig) {
        if (Strings.isNullOrEmpty((String)addSourceFieldsConfig)) {
            return Collections.emptyList();
        }
        return Arrays.stream(addSourceFieldsConfig.split(",")).map(String::trim).collect(Collectors.toList());
    }

    private static class FieldReference {
        private final String struct;
        private final String field;
        private final String newFieldName;

        private FieldReference(String prefix, String field) {
            String[] parts = FIELD_SEPARATOR.split(field);
            if (parts.length == 1) {
                this.struct = FieldReference.determineStruct(parts[0]);
                this.field = parts[0];
                this.newFieldName = prefix + field;
            } else if (parts.length == 2) {
                this.struct = parts[0];
                if (!this.struct.equals("source") && !this.struct.equals("transaction")) {
                    throw new IllegalArgumentException("Unexpected field name: " + field);
                }
                this.field = parts[1];
                this.newFieldName = prefix + this.struct + "_" + this.field;
            } else {
                throw new IllegalArgumentException("Unexpected field value: " + field);
            }
        }

        private static String determineStruct(String simpleFieldName) {
            if (simpleFieldName.equals("op") || simpleFieldName.equals("ts_ms") || simpleFieldName.equals("patch")) {
                return null;
            }
            if (simpleFieldName.equals("id") || simpleFieldName.equals("data_collection_order") || simpleFieldName.equals("total_order")) {
                return "transaction";
            }
            return "source";
        }

        static List<FieldReference> fromConfiguration(String fieldPrefix, String addHeadersConfig) {
            if (Strings.isNullOrEmpty((String)addHeadersConfig)) {
                return Collections.emptyList();
            }
            return Arrays.stream(addHeadersConfig.split(",")).map(String::trim).map(field -> new FieldReference(fieldPrefix, (String)field)).collect(Collectors.toList());
        }

        String getNewFieldName() {
            return this.newFieldName;
        }

        Object getValue(Struct originalRecordValue) {
            Struct parentStruct = this.struct != null ? (Struct)originalRecordValue.get(this.struct) : originalRecordValue;
            return parentStruct != null ? parentStruct.get(this.field) : null;
        }

        Schema getSchema(Schema originalRecordSchema) {
            Schema parentSchema = this.struct != null ? originalRecordSchema.field(this.struct).schema() : originalRecordSchema;
            Field schemaField = parentSchema.field(this.field);
            if (schemaField == null) {
                throw new IllegalArgumentException("Unexpected field name: " + this.field);
            }
            return SchemaUtil.copySchemaBasics((Schema)schemaField.schema()).optional().build();
        }
    }

    public static enum ArrayEncoding implements EnumeratedValue
    {
        ARRAY("array"),
        DOCUMENT("document");

        private final String value;

        private ArrayEncoding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static ArrayEncoding parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (ArrayEncoding option : ArrayEncoding.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static ArrayEncoding parse(String value, String defaultValue) {
            ArrayEncoding mode = ArrayEncoding.parse(value);
            if (mode == null && defaultValue != null) {
                mode = ArrayEncoding.parse(defaultValue);
            }
            return mode;
        }
    }
}

