/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.AbstractMongoConnectorIT;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.junit.logging.LogInterceptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class FieldRenamesIT
extends AbstractMongoConnectorIT {
    private static final String DATABASE_NAME = "dbA";
    private static final String COLLECTION_NAME = "c1";
    private static final String SERVER_NAME = "serverX";
    private static final String PATCH = "patch";
    private static final String ID = "_id";

    @Test
    public void shouldNotRenameMissingFieldsForReadEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        SourceRecord record = this.getReadRecord("*.c1.missing:new_missing", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(MongoDbSchema.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForReadEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        SourceRecord record = this.getReadRecord("*.c1.address.missing:new_missing", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(MongoDbSchema.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldNotRenameMissingFieldsForInsertEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        SourceRecord record = this.getInsertRecord("*.c1.missing:new_missing", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(MongoDbSchema.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForInsertEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        SourceRecord record = this.getInsertRecord("*.c1.address.missing:new_missing", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(MongoDbSchema.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        SourceRecord record = this.getUpdateRecord("*.c1.address.missing:new_missing", obj, updateObj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Map)FieldRenamesIT.getDocumentFromPatch(value)).isEqualTo((Object)updateObj);
    }

    @Test
    public void shouldNotRenameFieldsForEventOfOtherCollection() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        SourceRecord record = this.getReadRecord("*.c2.name:new_name,*.c2.active:new_active", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(MongoDbSchema.COMPACT_JSON_SETTINGS));
    }

    @Test
    public void shouldRenameFieldsForReadEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}";
        SourceRecord record = this.getReadRecord("*.c1.name:new_name,*.c1.active:new_active", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForReadEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}";
        SourceRecord record = this.getReadRecord("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedFieldsToExistingNamesForReadEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertShouldNotRenameDuringRead("*.c1.address.street:city", obj, "city");
    }

    @Test
    public void shouldRenameFieldsForInsertEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}";
        SourceRecord record = this.getInsertRecord("*.c1.name:new_name,*.c1.active:new_active", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForInsertEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        String expected = "{\"_id\": {\"$oid\": \"" + objId + "\"},\"phone\": {\"$numberLong\": \"123\"},\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}";
        SourceRecord record = this.getInsertRecord("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number", obj);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedFieldsToExistingNamesForInsertEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertShouldNotRenameDuringInsert("*.c1.address.street:city", obj, "city");
    }

    @Test
    public void shouldRenameFieldsForUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        String expected = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.active:new_active", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameMissingFieldsForUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        String expected = "{\"$v\": 1,\"$set\": {\"active\": true,\"name\": \"Sally\",\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6]}}";
        SourceRecord record = this.getUpdateRecord("*.c1.missing:new_missing", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)56L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        String expected = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\",\"new_active\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameNestedFieldsToExistingNamesForUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        this.assertShouldNotRenameDuringUpdate("*.c1.address.street:city", obj, updateObj, false, "city");
    }

    @Test
    public void shouldRenameNestedFieldsForUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)56L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        String expected = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\",\"new_number\": {\"$numberLong\": \"7\"}}],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameNestedFieldsForUpdateEventWithArrayOfArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense")))).append("active", (Object)false).append("scores", Arrays.asList(1.2, 3.4, 5.6, 7.8));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6)));
        String expected = "{\"$v\": 1,\"$set\": {\"active\": true,\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"},\"scores\": [1.2,3.4,5.6],\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameFieldsForSetTopLevelFieldUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L));
        String expected = "{\"$v\": 1,\"$set\": {\"phone\": {\"$numberLong\": \"123\"},\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameFieldsToExistingNamesForSetTopLevelFieldUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("name", (Object)"Sally").append("phone", (Object)123L);
        this.assertShouldNotRenameDuringUpdate("*.c1.name:phone", obj, updateObj, false, "phone");
    }

    @Test
    public void shouldRenameFieldsForUnsetTopLevelFieldUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("phone", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"phone\": true,\"new_name\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameFieldsToExistingNamesForUnsetTopLevelFieldUpdateEvent() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L);
        Document updateObj = new Document().append("name", (Object)"").append("phone", (Object)"");
        this.assertShouldNotRenameDuringUpdate("*.c1.name:phone", obj, updateObj, false, "phone");
    }

    @Test
    public void shouldRenameNestedFieldsForSetTopLevelFieldUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        String expected = "{\"$v\": 1,\"$set\": {\"address\": {\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},\"phone\": {\"$numberLong\": \"123\"},\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.address.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"), new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense")));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))));
        String expected = "{\"$v\": 1,\"$set\": {\"addresses\": [{\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\",\"new_number\": {\"$numberLong\": \"34\"}},{\"street\": \"Fragkokklisias\",\"city\": \"Athens\",\"new_number\": {\"$numberLong\": \"7\"}}],\"phone\": {\"$numberLong\": \"123\"},\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("phone", (Object)456L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")), Collections.singletonList(new Document().append("number", (Object)8L).append("street", (Object)"Fragkokklisiass").append("city", (Object)"Athense"))));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))));
        String expected = "{\"$v\": 1,\"$set\": {\"addresses\": [[{\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}],[{\"number\": {\"$numberLong\": \"7\"},\"street\": \"Fragkokklisias\",\"city\": \"Athens\"}]],\"phone\": {\"$numberLong\": \"123\"},\"new_name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("address.number", (Object)34L).append("address.street", (Object)"Claude Debussylaan").append("address.city", (Object)"Amsterdam"));
        String expected = "{\"$v\": 1,\"$set\": {\"address.city\": \"Amsterdam\",\"address.street\": \"Claude Debussylaan\",\"new_name\": \"Sally\",\"address.new_number\": {\"$numberLong\": \"34\"}}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.address.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        String expected = "{\"$v\": 1,\"$set\": {\"addresses.0.city\": \"Amsterdam\",\"addresses.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\",\"addresses.0.new_number\": {\"$numberLong\": \"34\"}}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameNestedFieldsToExistingNamesForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam");
        this.assertShouldNotRenameDuringUpdate("*.c1.addresses.street:city", obj, updateObj, false, "addresses.0.city");
    }

    @Test
    public void shouldNotRenameNestedFieldsForSetNestedFieldUpdateEventWithArrayOfArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"))));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam"));
        String expected = "{\"$v\": 1,\"$set\": {\"addresses.0.0.city\": \"Amsterdam\",\"addresses.0.0.number\": {\"$numberLong\": \"34\"},\"addresses.0.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithSeveralArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonMap("second", new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"))));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.second.0.number", (Object)34L).append("addresses.0.second.0.street", (Object)"Claude Debussylaan").append("addresses.0.second.0.city", (Object)"Amsterdam"));
        String expected = "{\"$v\": 1,\"$set\": {\"addresses.0.second.0.city\": \"Amsterdam\",\"addresses.0.second.0.street\": \"Claude Debussylaan\",\"name\": \"Sally\",\"addresses.0.second.0.new_number\": {\"$numberLong\": \"34\"}}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.second.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        String expected = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\",\"new_addresses.0.city\": \"Amsterdam\",\"new_addresses.0.number\": {\"$numberLong\": \"34\"},\"new_addresses.0.street\": \"Claude Debussylaan\"}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses:new_addresses", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameFieldsForSetToArrayFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        String expected = "{\"$v\": 1,\"$set\": {\"name\": \"Sally\",\"new_addresses.0\": {\"number\": {\"$numberLong\": \"34\"},\"street\": \"Claude Debussylaan\",\"city\": \"Amsterdam\"}}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses:new_addresses", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithEmbeddedDocument() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("address", (Object)new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"));
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("address.number", (Object)"").append("address.street", (Object)"").append("address.city", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"address.city\": true,\"address.street\": true,\"new_name\": true,\"address.new_number\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.name:new_name,*.c1.address.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"addresses.0.city\": true,\"addresses.0.street\": true,\"name\": true,\"addresses.0.new_number\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldNotRenameNestedFieldsToExistingNamesForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)"");
        this.assertShouldNotRenameDuringUpdate("*.c1.addresses.street:city", obj, updateObj, true, "addresses.0.city");
    }

    @Test
    public void shouldNotRenameNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame"))));
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.0.number", (Object)"").append("addresses.0.0.street", (Object)"").append("addresses.0.0.city", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"addresses.0.0.city\": true,\"addresses.0.0.number\": true,\"addresses.0.0.street\": true,\"name\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithSeveralArrays() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(Collections.singletonMap("second", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")))));
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.second.0.number", (Object)"").append("addresses.0.second.0.street", (Object)"").append("addresses.0.second.0.city", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"addresses.0.second.0.city\": true,\"addresses.0.second.0.street\": true,\"name\": true,\"addresses.0.second.0.new_number\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses.second.number:new_number", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws Exception {
        ObjectId objId = new ObjectId();
        Document obj = new Document().append(ID, (Object)objId).append("name", (Object)"Sally May").append("addresses", Arrays.asList(new Document().append("number", (Object)45L).append("street", (Object)"Claude Debussylaann").append("city", (Object)"Amsterdame")));
        Document updateObj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        String expected = "{\"$v\": 1,\"$unset\": {\"name\": true,\"new_addresses.0.city\": true,\"new_addresses.0.number\": true,\"new_addresses.0.street\": true}}";
        SourceRecord record = this.getUpdateRecord("*.c1.addresses:new_addresses", obj, updateObj);
        Struct value = (Struct)record.value();
        Document actualDoc = TestHelper.getDocumentWithoutLanguageVersion(value.getString(PATCH));
        Document expectedDoc = TestHelper.getDocumentWithoutLanguageVersion(expected);
        Assertions.assertThat((Map)actualDoc).isEqualTo((Object)expectedDoc);
    }

    @Test
    public void shouldRenameFieldsForDeleteEvent() throws Exception {
        this.config = FieldRenamesIT.getConfiguration("*.c1.name:new_name,*.c1.active:new_active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
        ObjectId objId = new ObjectId();
        Document obj = new Document(ID, (Object)objId);
        this.dropAndInsertDocuments(DATABASE_NAME, COLLECTION_NAME, obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.deleteDocuments(DATABASE_NAME, COLLECTION_NAME, FieldRenamesIT.getFilterFromId(objId));
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(0);
        Struct value = (Struct)record.value();
        String json = value.getString("after");
        if (json == null) {
            json = value.getString(PATCH);
        }
        Assertions.assertThat((String)json).isNull();
    }

    @Test
    public void shouldRenameFieldsForDeleteTombstoneEvent() throws Exception {
        this.config = FieldRenamesIT.getConfiguration("*.c1.name:new_name,*.c1.active:new_active");
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
        ObjectId objId = new ObjectId();
        Document obj = new Document(ID, (Object)objId);
        this.dropAndInsertDocuments(DATABASE_NAME, COLLECTION_NAME, obj);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)snapshotRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)snapshotRecords.allRecordsInOrder().size()).isEqualTo(1);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.deleteDocuments(DATABASE_NAME, COLLECTION_NAME, FieldRenamesIT.getFilterFromId(objId));
        AbstractConnectorTest.SourceRecords deleteRecords = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)deleteRecords.topics().size()).isEqualTo(1);
        Assertions.assertThat((int)deleteRecords.allRecordsInOrder().size()).isEqualTo(2);
        SourceRecord record = (SourceRecord)deleteRecords.allRecordsInOrder().get(1);
        Struct value = (Struct)record.value();
        Assertions.assertThat((Object)value).isNull();
    }

    private static Document getFilterFromId(ObjectId id) {
        return Document.parse((String)("{\"_id\": {\"$oid\": \"" + id + "\"}}"));
    }

    private static Document getDocumentFromPatch(Struct value) {
        Assertions.assertThat((Object)value).isNotNull();
        String patch = value.getString(PATCH);
        Assertions.assertThat((String)patch).isNotNull();
        Document parsed = Document.parse((String)patch);
        parsed.remove((Object)"$v");
        return parsed;
    }

    private static Configuration getConfiguration(String fieldRenames) {
        return FieldRenamesIT.getConfiguration(fieldRenames, DATABASE_NAME, COLLECTION_NAME);
    }

    private static Configuration getConfiguration(String fieldRenames, String database, String collection) {
        Configuration.Builder builder = (Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST, database + "." + collection)).with(MongoDbConnectorConfig.LOGICAL_NAME, SERVER_NAME);
        if (fieldRenames != null && !"".equals(fieldRenames.trim())) {
            builder = (Configuration.Builder)builder.with(MongoDbConnectorConfig.FIELD_RENAMES, fieldRenames);
        }
        return builder.build();
    }

    private SourceRecord getReadRecord(String fieldRenames, Document document) throws Exception {
        return this.getReadRecord(DATABASE_NAME, COLLECTION_NAME, fieldRenames, document);
    }

    private SourceRecord getReadRecord(String database, String collection, String fieldRenames, Document document) throws Exception {
        this.config = FieldRenamesIT.getConfiguration(fieldRenames, database, collection);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), database);
        this.dropAndInsertDocuments(database, collection, document);
        this.logInterceptor = new LogInterceptor();
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)sourceRecords.allRecordsInOrder().size()).isEqualTo(1);
        return (SourceRecord)sourceRecords.allRecordsInOrder().get(0);
    }

    private SourceRecord getInsertRecord(String fieldRenames, Document document) throws Exception {
        return this.getInsertRecord(DATABASE_NAME, COLLECTION_NAME, fieldRenames, document);
    }

    private SourceRecord getInsertRecord(String database, String collection, String fieldRenames, Document document) throws Exception {
        this.config = FieldRenamesIT.getConfiguration(fieldRenames, database, collection);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), database);
        this.insertDocuments(database, collection, document);
        this.logInterceptor = new LogInterceptor();
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)sourceRecords.allRecordsInOrder().size()).isEqualTo(1);
        return (SourceRecord)sourceRecords.allRecordsInOrder().get(0);
    }

    private SourceRecord getUpdateRecord(String fieldRenames, Document snapshot, Document document) throws Exception {
        return this.getUpdateRecord(DATABASE_NAME, COLLECTION_NAME, fieldRenames, snapshot, document);
    }

    private SourceRecord getUpdateRecord(String database, String collection, String fieldRenames, Document snapshot, Document document) throws Exception {
        SourceRecord readRecord = this.getReadRecord(database, collection, fieldRenames, snapshot);
        this.updateDocument(database, collection, FieldRenamesIT.getFilterFromId(snapshot.getObjectId((Object)ID)), document);
        AbstractConnectorTest.SourceRecords sourceRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)sourceRecords.allRecordsInOrder().size()).isEqualTo(1);
        return (SourceRecord)sourceRecords.allRecordsInOrder().get(0);
    }

    private void assertDocumentContainsFieldError(String fieldName) {
        this.stopConnector(value -> {
            String message = "IllegalArgumentException: Document already contains field : " + fieldName;
            Assertions.assertThat((boolean)this.logInterceptor.containsStacktraceElement(message)).isTrue();
        });
    }

    private void assertShouldNotRenameDuringRead(String renamesList, Document snapshot, String fieldName) throws Exception {
        this.config = FieldRenamesIT.getConfiguration(renamesList);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
        this.dropAndInsertDocuments(DATABASE_NAME, COLLECTION_NAME, snapshot);
        this.logInterceptor = new LogInterceptor();
        this.start(MongoDbConnector.class, this.config);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.assertNoRecordsToConsume();
        this.assertDocumentContainsFieldError(fieldName);
    }

    private void assertShouldNotRenameDuringInsert(String renamesList, Document document, String fieldName) throws Exception {
        this.config = FieldRenamesIT.getConfiguration(renamesList);
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), DATABASE_NAME);
        this.logInterceptor = new LogInterceptor();
        this.start(MongoDbConnector.class, this.config);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.insertDocuments(DATABASE_NAME, COLLECTION_NAME, document);
        this.assertNoRecordsToConsume();
        this.assertDocumentContainsFieldError(fieldName);
    }

    private void assertShouldNotRenameDuringUpdate(String renamesList, Document snapshot, Document update, boolean unset, String fieldName) throws Exception {
        SourceRecord snapshotRecord = this.getReadRecord(DATABASE_NAME, COLLECTION_NAME, null, snapshot);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        this.stopConnector();
        this.config = FieldRenamesIT.getConfiguration(renamesList, DATABASE_NAME, COLLECTION_NAME);
        this.context = new MongoDbTaskContext(this.config);
        this.logInterceptor = new LogInterceptor();
        this.start(MongoDbConnector.class, this.config);
        FieldRenamesIT.waitForStreamingRunning((String)"mongodb", (String)SERVER_NAME);
        Document document = new Document().append(unset ? "$unset" : "$set", (Object)update);
        this.updateDocument(DATABASE_NAME, COLLECTION_NAME, FieldRenamesIT.getFilterFromId(snapshot.getObjectId((Object)ID)), document);
        this.assertNoRecordsToConsume();
        this.assertDocumentContainsFieldError(fieldName);
    }
}

