/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.Bytes;
import com.mongodb.util.AbstractObjectSerializer;
import com.mongodb.util.ObjectSerializer;
import java.util.Iterator;
import java.util.List;
import org.bson.util.ClassMap;

class ClassMapBasedObjectSerializer
extends AbstractObjectSerializer {
    private final ClassMap<ObjectSerializer> _serializers = new ClassMap();

    ClassMapBasedObjectSerializer() {
    }

    void addObjectSerializer(Class c, ObjectSerializer serializer) {
        this._serializers.put(c, (Object)serializer);
    }

    @Override
    public void serialize(Object obj, StringBuilder buf) {
        Class ancestor;
        Object objectToSerialize = obj;
        if ((objectToSerialize = Bytes.applyEncodingHooks((Object)objectToSerialize)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List ancestors = ClassMap.getAncestry(objectToSerialize.getClass());
        Iterator iterator = ancestors.iterator();
        while (iterator.hasNext() && (serializer = (ObjectSerializer)this._serializers.get((Object)(ancestor = (Class)iterator.next()))) == null) {
        }
        if (serializer == null && objectToSerialize.getClass().isArray()) {
            serializer = (ObjectSerializer)this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + objectToSerialize.getClass());
        }
        serializer.serialize(objectToSerialize, buf);
    }
}

