/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.schema.TopicSelector;
import java.util.StringJoiner;

@ThreadSafe
public class MongoDbTopicSelector {
    public static TopicSelector<CollectionId> defaultSelector(String prefix, String heartbeatPrefix) {
        return TopicSelector.defaultSelector((String)prefix, (String)heartbeatPrefix, (String)".", (id, pref, delimiter) -> MongoDbTopicSelector.getTopicName(id, pref, delimiter));
    }

    private static String getTopicName(CollectionId collectionId, String prefix, String delimiter) {
        StringJoiner sb = new StringJoiner(delimiter);
        if (prefix != null && prefix.trim().length() > 0) {
            String trimmedPrefix = prefix.trim();
            sb.add(trimmedPrefix);
        }
        sb.add(collectionId.dbName());
        sb.add(collectionId.name());
        return sb.toString();
    }
}

