/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.common.BaseSourceInfo;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.bson.BsonTimestamp;
import org.bson.Document;

@NotThreadSafe
public final class SourceInfo
extends BaseSourceInfo {
    public static final int SCHEMA_VERSION = 1;
    public static final String SERVER_ID_KEY = "server_id";
    public static final String REPLICA_SET_NAME = "rs";
    public static final String NAMESPACE = "ns";
    public static final String TIMESTAMP = "sec";
    public static final String ORDER = "ord";
    public static final String OPERATION_ID = "h";
    public static final String TX_ORD = "tord";
    public static final String INITIAL_SYNC = "initsync";
    public static final String COLLECTION = "collection";
    private static final BsonTimestamp INITIAL_TIMESTAMP = new BsonTimestamp();
    private static final Position INITIAL_POSITION = new Position(INITIAL_TIMESTAMP, null, 0L);
    private final ConcurrentMap<String, Map<String, String>> sourcePartitionsByReplicaSetName = new ConcurrentHashMap<String, Map<String, String>>();
    private final ConcurrentMap<String, Position> positionsByReplicaSetName = new ConcurrentHashMap<String, Position>();
    private final Set<String> initialSyncReplicaSets = Collections.newSetFromMap(new ConcurrentHashMap());
    private String replicaSetName;
    private CollectionId collectionId;
    private Position position;

    public static String replicaSetNameForPartition(Map<String, ?> partition) {
        return partition != null ? (String)partition.get(REPLICA_SET_NAME) : null;
    }

    public SourceInfo(MongoDbConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
    }

    CollectionId collectionId() {
        return this.collectionId;
    }

    Position position() {
        return this.position;
    }

    public Map<String, String> partition(String replicaSetName) {
        if (replicaSetName == null) {
            throw new IllegalArgumentException("Replica set name may not be null");
        }
        return this.sourcePartitionsByReplicaSetName.computeIfAbsent(replicaSetName, rsName -> Collect.hashMapOf((Object)SERVER_ID_KEY, (Object)this.serverName(), (Object)REPLICA_SET_NAME, (Object)rsName));
    }

    public BsonTimestamp lastOffsetTimestamp(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        return existing != null ? existing.ts : INITIAL_TIMESTAMP;
    }

    public OptionalLong lastOffsetTxOrder(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        return existing != null ? existing.getTxOrder() : OptionalLong.empty();
    }

    public Map<String, ?> lastOffset(String replicaSetName) {
        Position existing = (Position)this.positionsByReplicaSetName.get(replicaSetName);
        if (existing == null) {
            existing = INITIAL_POSITION;
        }
        if (this.isInitialSyncOngoing(replicaSetName)) {
            return Collect.hashMapOf((Object)TIMESTAMP, (Object)existing.getTime(), (Object)ORDER, (Object)existing.getInc(), (Object)OPERATION_ID, (Object)existing.getOperationId(), (Object)INITIAL_SYNC, (Object)true);
        }
        Map offset = Collect.hashMapOf((Object)TIMESTAMP, (Object)existing.getTime(), (Object)ORDER, (Object)existing.getInc(), (Object)OPERATION_ID, (Object)existing.getOperationId());
        existing.getTxOrder().ifPresent(txOrder -> offset.put(TX_ORD, txOrder));
        return offset;
    }

    public void collectionEvent(String replicaSetName, CollectionId collectionId) {
        this.onEvent(replicaSetName, collectionId, (Position)this.positionsByReplicaSetName.get(replicaSetName));
    }

    public void opLogEvent(String replicaSetName, Document oplogEvent, Document masterEvent, long orderInTx) {
        Position position = INITIAL_POSITION;
        String namespace = "";
        if (oplogEvent != null) {
            BsonTimestamp ts = SourceInfo.extractEventTimestamp(masterEvent);
            Long opId = masterEvent.getLong((Object)OPERATION_ID);
            position = new Position(ts, opId, orderInTx);
            namespace = oplogEvent.getString((Object)NAMESPACE);
        }
        this.positionsByReplicaSetName.put(replicaSetName, position);
        this.onEvent(replicaSetName, CollectionId.parse(replicaSetName, namespace), position);
    }

    public void opLogEvent(String replicaSetName, Document oplogEvent) {
        this.opLogEvent(replicaSetName, oplogEvent, oplogEvent, 0L);
    }

    protected static BsonTimestamp extractEventTimestamp(Document oplogEvent) {
        return oplogEvent != null ? (BsonTimestamp)oplogEvent.get((Object)"ts", BsonTimestamp.class) : null;
    }

    private void onEvent(String replicaSetName, CollectionId collectionId, Position position) {
        this.replicaSetName = replicaSetName;
        this.position = position == null ? INITIAL_POSITION : position;
        this.collectionId = collectionId;
    }

    public boolean hasOffset(String replicaSetName) {
        return this.positionsByReplicaSetName.containsKey(replicaSetName);
    }

    public boolean setOffsetFor(String replicaSetName, Map<String, ?> sourceOffset) {
        if (replicaSetName == null) {
            throw new IllegalArgumentException("The replica set name may not be null");
        }
        if (sourceOffset == null) {
            return false;
        }
        boolean initSync = SourceInfo.booleanOffsetValue(sourceOffset, INITIAL_SYNC);
        if (initSync) {
            return false;
        }
        int time = SourceInfo.intOffsetValue(sourceOffset, TIMESTAMP);
        int order = SourceInfo.intOffsetValue(sourceOffset, ORDER);
        long operationId = SourceInfo.longOffsetValue(sourceOffset, OPERATION_ID);
        long txOrder = SourceInfo.longOffsetValue(sourceOffset, TX_ORD);
        this.positionsByReplicaSetName.put(replicaSetName, new Position(time, order, operationId, txOrder));
        return true;
    }

    public boolean setOffsetFor(Map<String, String> partition, Map<String, ?> sourceOffset) {
        String replicaSetName = partition.get(REPLICA_SET_NAME);
        return this.setOffsetFor(replicaSetName, sourceOffset);
    }

    public void startInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.add(replicaSetName);
    }

    public void stopInitialSync(String replicaSetName) {
        this.initialSyncReplicaSets.remove(replicaSetName);
    }

    public boolean isInitialSyncOngoing(String replicaSetName) {
        return this.initialSyncReplicaSets.contains(replicaSetName);
    }

    public boolean isSnapshotRunning() {
        return !this.initialSyncReplicaSets.isEmpty();
    }

    private static int intOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to an integer");
        }
    }

    private static long longOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        try {
            return Long.parseLong(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new ConnectException("Source offset '" + key + "' parameter value " + obj + " could not be converted to a long");
        }
    }

    private static boolean booleanOffsetValue(Map<String, ?> values, String key) {
        Object obj = values.get(key);
        if (obj != null && obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    protected Instant timestamp() {
        return Instant.ofEpochSecond(this.position().getTime());
    }

    protected SnapshotRecord snapshot() {
        return this.isInitialSyncOngoing(this.replicaSetName) ? SnapshotRecord.TRUE : SnapshotRecord.FALSE;
    }

    protected String database() {
        return this.collectionId != null ? this.collectionId.dbName() : null;
    }

    String replicaSetName() {
        return this.replicaSetName;
    }

    protected OptionalLong transactionPosition() {
        return this.position.getTxOrder();
    }

    @Immutable
    protected static final class Position {
        private final Long opId;
        private final BsonTimestamp ts;
        private final long txOrder;

        public Position(int ts, int order, Long opId, long txOrder) {
            this(new BsonTimestamp(ts, order), opId, txOrder);
        }

        public Position(BsonTimestamp ts, Long opId, long txOrder) {
            this.ts = ts;
            this.opId = opId;
            this.txOrder = txOrder;
            assert (this.ts != null);
        }

        public BsonTimestamp getTimestamp() {
            return this.ts;
        }

        public int getTime() {
            return this.ts.getTime();
        }

        public int getInc() {
            return this.ts.getInc();
        }

        public Long getOperationId() {
            return this.opId;
        }

        public OptionalLong getTxOrder() {
            return this.txOrder == 0L ? OptionalLong.empty() : OptionalLong.of(this.txOrder);
        }
    }
}

