/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.util.JSON;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.converters.CloudEventsConverterTest;
import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.util.Collect;
import io.debezium.util.IoUtil;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MongoDbConnectorIT
extends AbstractConnectorTest {
    private Configuration config;
    private MongoDbTaskContext context;

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            if (this.context != null) {
                this.context.getConnectionContext().shutdown();
            }
        }
    }

    @Test
    public void shouldNotStartWithInvalidConfiguration() {
        this.config = ((Configuration.Builder)Configuration.create().with(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, "true")).build();
        this.logger.info("Attempting to start the connector with an INVALID configuration, so MULTIPLE error messages & one exceptions will appear in the log");
        this.start(MongoDbConnector.class, this.config, (success, msg, error) -> {
            Assertions.assertThat((boolean)success).isFalse();
            Assertions.assertThat((Throwable)error).isNotNull();
        });
        this.assertConnectorNotRunning();
    }

    @Test
    public void shouldFailToValidateInvalidConfiguration() {
        Configuration config = Configuration.create().build();
        MongoDbConnector connector = new MongoDbConnector();
        Config result = connector.validate(config.asMap());
        this.assertConfigurationErrors(result, MongoDbConnectorConfig.HOSTS, 1);
        this.assertConfigurationErrors(result, MongoDbConnectorConfig.LOGICAL_NAME, 1);
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_COPY_THREADS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_INITIAL_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_MAX_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.SSL_ENABLED});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.SSL_ALLOW_INVALID_HOSTNAMES});
        this.assertNoConfigurationErrors(result, new Field[]{CommonConnectorConfig.TOMBSTONES_ON_DELETE});
    }

    @Test
    public void shouldValidateAcceptableConfiguration() {
        this.config = TestHelper.getConfiguration();
        this.context = new MongoDbTaskContext(this.config);
        this.storeDocuments("dbval", "validationColl1", "simple_objects.json");
        this.storeDocuments("dbval2", "validationColl2", "restaurants1.json");
        MongoDbConnector connector = new MongoDbConnector();
        Config result = connector.validate(this.config.asMap());
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.HOSTS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.LOGICAL_NAME});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.USER});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.PASSWORD});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.DATABASE_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_WHITELIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.COLLECTION_BLACKLIST});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_COPY_THREADS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_QUEUE_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_BATCH_SIZE});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.POLL_INTERVAL_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_INITIAL_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.CONNECT_BACKOFF_MAX_DELAY_MS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.SSL_ENABLED});
        this.assertNoConfigurationErrors(result, new Field[]{MongoDbConnectorConfig.SSL_ALLOW_INVALID_HOSTNAMES});
        this.assertNoConfigurationErrors(result, new Field[]{CommonConnectorConfig.TOMBSTONES_ON_DELETE});
    }

    @Test
    public void shouldConsumeAllEventsFromDatabase() throws InterruptedException, IOException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocuments("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(4);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyNotFromTransaction((SourceRecord)record);
        });
        this.stopConnector();
        this.storeDocuments("dbit", "restaurants", "restaurants3.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records3 = this.consumeRecordsByTopic(5);
        Assertions.assertThat((int)records3.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(5);
        Assertions.assertThat((int)records3.topics().size()).isEqualTo(1);
        records3.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        this.storeDocuments("dbit", "restaurants", "restaurants4.json");
        AbstractConnectorTest.SourceRecords records4 = this.consumeRecordsByTopic(8);
        Assertions.assertThat((int)records4.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(8);
        Assertions.assertThat((int)records4.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        AtomicReference id = new AtomicReference();
        this.primary().execute("create", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("arbitrary");
            coll.drop();
            Document doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            id.set(doc.getObjectId((Object)"_id").toString());
            Testing.debug((Object)("Document ID: " + (String)id.get()));
        });
        this.primary().execute("update", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("arbitrary");
            Document doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
            Document filter = Document.parse((String)"{\"a\": 1}");
            Document operation = Document.parse((String)"{ \"$set\": { \"b\": 10 } }");
            coll.updateOne((Bson)filter, (Bson)operation);
            doc = (Document)coll.find().first();
            Testing.debug((Object)("Document: " + doc));
        });
        AbstractConnectorTest.SourceRecords insertAndUpdate = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)insertAndUpdate.recordsForTopic("mongo.dbit.arbitrary").size()).isEqualTo(2);
        Assertions.assertThat((int)insertAndUpdate.topics().size()).isEqualTo(1);
        records4.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
        });
        SourceRecord insertRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(0);
        SourceRecord updateRecord = (SourceRecord)insertAndUpdate.allRecordsInOrder().get(1);
        Testing.debug((Object)("Insert event: " + insertRecord));
        Testing.debug((Object)("Update event: " + updateRecord));
        Struct insertKey = (Struct)insertRecord.key();
        Struct updateKey = (Struct)updateRecord.key();
        String insertId = JSON.parse((String)insertKey.getString("id")).toString();
        String updateId = JSON.parse((String)updateKey.getString("id")).toString();
        Assertions.assertThat((String)insertId).isEqualTo(id.get());
        Assertions.assertThat((String)updateId).isEqualTo(id.get());
    }

    @Test
    @FixFor(value={"DBZ-1168"})
    public void shouldConsumeAllEventsFromDatabaseWithCustomAuthSource() throws InterruptedException, IOException {
        String authDbName = "authdb";
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.primary().execute("Create auth database", client -> {
            MongoDatabase db = client.getDatabase("authdb");
            try {
                db.runCommand((Bson)BsonDocument.parse((String)"{dropUser: \"dbz\"}"));
            }
            catch (Exception e) {
                this.logger.info("Expected error while dropping user", (Throwable)e);
            }
            db.runCommand((Bson)BsonDocument.parse((String)"{createUser: \"dbz\", pwd: \"pass\", roles: [{role: \"readAnyDatabase\", db: \"admin\"}]}"));
        });
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.USER, "dbz")).with(MongoDbConnectorConfig.PASSWORD, "pass")).with(MongoDbConnectorConfig.AUTH_SOURCE, "authdb")).with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocuments("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(4);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyNotFromTransaction((SourceRecord)record);
        });
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-865 and DBZ-1242"})
    public void shouldConsumeEventsFromCollectionWithReplacedTopicName() throws InterruptedException, IOException {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.dbz865.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.primary().execute("create", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("dbz865_my@collection");
            coll.drop();
            Document doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
        });
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((List)records.recordsForTopic("mongo.dbit.dbz865_my_collection")).hasSize(1);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(1);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isFalse());
    }

    @Test
    @FixFor(value={"DBZ-1242"})
    public void testEmptySchemaWarningAfterApplyingCollectionFilters() throws Exception {
        LogInterceptor logInterceptor = new LogInterceptor();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.dbz865.my_products")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.primary().execute("create", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("dbz865_my@collection");
            coll.drop();
            Document doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
        });
        this.start(MongoDbConnector.class, this.config);
        this.consumeRecordsByTopic(12);
        this.stopConnector(value -> Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("After applying blacklist/whitelist filters there are no tables to monitor, please check your configuration")).isTrue());
    }

    protected void verifyFromInitialSync(SourceRecord record, AtomicBoolean foundLast) {
        if (record.sourceOffset().containsKey("initsync")) {
            Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isTrue();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"true");
        } else {
            Assertions.assertThat((boolean)foundLast.getAndSet(true)).isFalse();
            Struct value = (Struct)record.value();
            Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isEqualTo((Object)"last");
        }
        this.verifyNotFromTransaction(record);
    }

    @Test
    @FixFor(value={"DBZ-1215"})
    public void shouldConsumeTransaction() throws InterruptedException, IOException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        if (!TestHelper.transactionsSupported(this.primary(), "dbit")) {
            this.logger.info("Test not executed, transactions not supported in the server");
            return;
        }
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocumentsInTx("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(4);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        AtomicLong txOrder = new AtomicLong(0L);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyFromTransaction((SourceRecord)record, txOrder.incrementAndGet());
        });
        this.stopConnector();
        this.storeDocumentsInTx("dbit", "restaurants", "restaurants3.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records3 = this.consumeRecordsByTopic(5);
        Assertions.assertThat((int)records3.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(5);
        Assertions.assertThat((int)records3.topics().size()).isEqualTo(1);
        txOrder.set(0L);
        records3.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyFromTransaction((SourceRecord)record, txOrder.incrementAndGet());
        });
    }

    @Test
    @FixFor(value={"DBZ-1215"})
    public void shouldResumeTransactionInMiddle() throws InterruptedException, IOException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        if (!TestHelper.transactionsSupported(this.primary(), "dbit")) {
            this.logger.info("Test not executed, transactions not supported in the server");
            return;
        }
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.storeDocuments("dbit", "simpletons", "simple_objects.json");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config, record -> {
            Struct struct = (Struct)record.value();
            Long txOrder = struct.getStruct("source").getInt64("tord");
            return txOrder != null && txOrder.equals(3L);
        });
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        records.topics().forEach(System.out::println);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.simpletons").size()).isEqualTo(6);
        Assertions.assertThat((int)records.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(6);
        Assertions.assertThat((int)records.topics().size()).isEqualTo(2);
        AtomicBoolean foundLast = new AtomicBoolean(false);
        records.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyFromInitialSync((SourceRecord)record, foundLast);
            this.verifyReadOperation((SourceRecord)record);
        });
        Assertions.assertThat((boolean)foundLast.get()).isTrue();
        this.storeDocumentsInTx("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records2.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(2);
        Assertions.assertThat((int)records2.topics().size()).isEqualTo(1);
        AtomicLong txOrder = new AtomicLong(0L);
        records2.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyFromTransaction((SourceRecord)record, txOrder.incrementAndGet());
        });
        this.stopConnector();
        this.storeDocumentsInTx("dbit", "restaurants", "restaurants3.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records3 = this.consumeRecordsByTopic(7);
        Assertions.assertThat((int)records3.recordsForTopic("mongo.dbit.restaurants").size()).isEqualTo(7);
        Assertions.assertThat((int)records3.topics().size()).isEqualTo(1);
        List expectedTxOrd = Collect.arrayListOf((Object)3L, (Object[])new Long[]{4L, 1L, 2L, 3L, 4L, 5L});
        records3.forEach(record -> {
            this.validate((SourceRecord)record);
            this.verifyNotFromInitialSync((SourceRecord)record);
            this.verifyCreateOperation((SourceRecord)record);
            this.verifyFromTransaction((SourceRecord)record, (Long)expectedTxOrd.remove(0));
        });
    }

    protected void verifyNotFromInitialSync(SourceRecord record) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("initsync")).isFalse();
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getStruct("source").getString("snapshot")).isNull();
    }

    protected void verifyFromTransaction(SourceRecord record, long order) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("tord")).isTrue();
        Struct value = (Struct)record.value();
        Assertions.assertThat((Long)value.getStruct("source").getInt64("tord")).isEqualTo(order);
    }

    protected void verifyNotFromTransaction(SourceRecord record) {
        Assertions.assertThat((boolean)record.sourceOffset().containsKey("tord")).isFalse();
    }

    protected void verifyCreateOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.CREATE);
    }

    protected void verifyReadOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.READ);
    }

    protected void verifyUpdateOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.UPDATE);
    }

    protected void verifyDeleteOperation(SourceRecord record) {
        this.verifyOperation(record, Envelope.Operation.DELETE);
    }

    protected void verifyOperation(SourceRecord record, Envelope.Operation expected) {
        Struct value = (Struct)record.value();
        Assertions.assertThat((String)value.getString("op")).isEqualTo((Object)expected.code());
    }

    protected ConnectionContext.MongoPrimary primary() {
        ReplicaSet replicaSet = ReplicaSet.parse((String)this.context.getConnectionContext().hosts());
        return this.context.getConnectionContext().primaryFor(replicaSet, this.context.filters(), this.connectionErrorHandler(3));
    }

    protected void storeDocuments(String dbName, String collectionName, String pathOnClasspath) {
        this.primary().execute("storing documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = mongo.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            this.storeDocuments((MongoCollection<Document>)coll, pathOnClasspath);
        });
    }

    protected void storeDocuments(MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            collection.insertOne(doc, insertOptions);
        });
    }

    protected void storeDocumentsInTx(String dbName, String collectionName, String pathOnClasspath) {
        this.primary().execute("storing documents", mongo -> {
            Testing.debug((Object)("Storing in '" + dbName + "." + collectionName + "' documents loaded from from '" + pathOnClasspath + "'"));
            MongoDatabase db1 = mongo.getDatabase(dbName);
            MongoCollection coll = db1.getCollection(collectionName);
            coll.drop();
            db1.createCollection(collectionName);
            ClientSession session = mongo.startSession();
            session.startTransaction();
            this.storeDocuments(session, (MongoCollection<Document>)coll, pathOnClasspath);
            session.commitTransaction();
        });
    }

    protected void storeDocuments(ClientSession session, MongoCollection<Document> collection, String pathOnClasspath) {
        InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
        this.loadTestDocuments(pathOnClasspath).forEach(doc -> {
            Assertions.assertThat((Map)doc).isNotNull();
            Assertions.assertThat((int)doc.size()).isGreaterThan(0);
            if (session == null) {
                collection.insertOne(doc, insertOptions);
            } else {
                collection.insertOne(session, doc, insertOptions);
            }
        });
    }

    protected List<Document> loadTestDocuments(String pathOnClasspath) {
        ArrayList<Document> results = new ArrayList<Document>();
        try (InputStream stream = Testing.Files.readResourceAsStream((String)pathOnClasspath);){
            Assertions.assertThat((Object)stream).isNotNull();
            IoUtil.readLines((InputStream)stream, line -> {
                Document doc = Document.parse((String)line);
                Assertions.assertThat((int)doc.size()).isGreaterThan(0);
                results.add(doc);
            });
        }
        catch (IOException e) {
            Assert.fail((String)("Unable to find or read file '" + pathOnClasspath + "': " + e.getMessage()));
        }
        return results;
    }

    protected BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            this.logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }

    @Test(expected=ConnectException.class)
    public void shouldUseSSL() throws InterruptedException, IOException {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).with(MongoDbConnectorConfig.MAX_FAILED_CONNECTIONS, 0)).with(MongoDbConnectorConfig.SSL_ENABLED, true)).build();
        this.context = new MongoDbTaskContext(this.config);
        this.primary().executeBlocking("Try SSL connection", mongo -> mongo.getDatabase("dbit"));
    }

    @Test
    @FixFor(value={"DBZ-1198"})
    public void shouldEmitHeartbeatMessages() throws InterruptedException, IOException {
        Testing.Print.enable();
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.mhb")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).with(Heartbeat.HEARTBEAT_INTERVAL, "1")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.primary().execute("create", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll1 = db1.getCollection("mhb");
            coll1.drop();
            Document doc = Document.parse((String)"{\"a\": 1, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll1.insertOne((Object)doc, insertOptions);
            MongoCollection coll2 = db1.getCollection("nmhb");
            coll2.drop();
        });
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((List)records.allRecordsInOrder()).hasSize(1);
        Assertions.assertThat((List)records.recordsForTopic("mongo.dbit.mhb")).hasSize(1);
        this.primary().execute("insert-monitored", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("mhb");
            Document doc = Document.parse((String)"{\"a\": 2, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
        });
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((List)records.recordsForTopic("mongo.dbit.mhb")).hasSize(1);
        Map monitoredOffset = ((SourceRecord)records.recordsForTopic("mongo.dbit.mhb").get(0)).sourceOffset();
        Integer monitoredTs = (Integer)monitoredOffset.get("sec");
        Integer monitoredOrd = (Integer)monitoredOffset.get("ord");
        Assertions.assertThat((List)records.recordsForTopic("__debezium-heartbeat.mongo")).hasSize(1);
        Map hbAfterMonitoredOffset = ((SourceRecord)records.recordsForTopic("__debezium-heartbeat.mongo").get(0)).sourceOffset();
        Assertions.assertThat((Integer)monitoredTs).isEqualTo((Object)((Integer)hbAfterMonitoredOffset.get("sec")));
        Assertions.assertThat((Integer)monitoredOrd).isEqualTo((Object)((Integer)hbAfterMonitoredOffset.get("ord")));
        this.primary().execute("insert-nonmonitored", mongo -> {
            MongoDatabase db1 = mongo.getDatabase("dbit");
            MongoCollection coll = db1.getCollection("nmhb");
            Document doc = Document.parse((String)"{\"a\": 3, \"b\": 2}");
            InsertOneOptions insertOptions = new InsertOneOptions().bypassDocumentValidation(Boolean.valueOf(true));
            coll.insertOne((Object)doc, insertOptions);
        });
        records = this.consumeRecordsByTopic(2);
        List heartbeatRecords = records.recordsForTopic("__debezium-heartbeat.mongo");
        Assertions.assertThat((int)heartbeatRecords.size()).isGreaterThanOrEqualTo(1);
        heartbeatRecords.forEach(record -> {
            Map offset = record.sourceOffset();
            Integer ts = (Integer)offset.get("sec");
            Integer ord = (Integer)offset.get("ord");
            Assertions.assertThat((ts > monitoredTs || ts == monitoredTs && ord > monitoredOrd ? 1 : 0) != 0);
        });
        this.stopConnector();
    }

    @Test
    @FixFor(value={"DBZ-1292"})
    public void shouldOutputRecordsInCloudEventsFormat() throws Exception {
        this.config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "dbit.*")).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(this.config);
        TestHelper.cleanDatabase(this.primary(), "dbit");
        this.storeDocuments("dbit", "restaurants", "restaurants1.json");
        this.start(MongoDbConnector.class, this.config);
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(12);
        List topicRecords = records.recordsForTopic("mongo.dbit.restaurants");
        for (SourceRecord record : topicRecords) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)record);
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)record);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)record, (String)"mongodb", (String)"mongo");
        }
        this.storeDocuments("dbit", "restaurants", "restaurants2.json");
        AbstractConnectorTest.SourceRecords records2 = this.consumeRecordsByTopic(4);
        List topicRecords2 = records2.recordsForTopic("mongo.dbit.restaurants");
        for (SourceRecord record : topicRecords2) {
            CloudEventsConverterTest.shouldConvertToCloudEventsInJson((SourceRecord)record);
            CloudEventsConverterTest.shouldConvertToCloudEventsInJsonWithDataAsAvro((SourceRecord)record);
            CloudEventsConverterTest.shouldConvertToCloudEventsInAvro((SourceRecord)record, (String)"mongodb", (String)"mongo");
        }
        this.stopConnector();
    }
}

