/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.client.MongoDatabase;
import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    protected static final Logger logger = LoggerFactory.getLogger(TestHelper.class);

    public static Configuration getConfiguration() {
        return ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.fromSystemProperties((String)"connector.").edit().withDefault(MongoDbConnectorConfig.HOSTS, "rs0/localhost:27017")).withDefault(MongoDbConnectorConfig.AUTO_DISCOVER_MEMBERS, false)).withDefault(MongoDbConnectorConfig.LOGICAL_NAME, "mongo1")).build();
    }

    public static void cleanDatabase(ConnectionContext.MongoPrimary primary, String dbName) {
        primary.execute("clean-db", mongo -> {
            MongoDatabase db1 = mongo.getDatabase(dbName);
            db1.listCollectionNames().forEach(x -> {
                logger.info("Removing collection '{}' from database '{}'", x, (Object)dbName);
                db1.getCollection(x).drop();
            });
        });
    }

    public static Document databaseInformation(ConnectionContext.MongoPrimary primary, String dbName) {
        AtomicReference ret = new AtomicReference();
        primary.execute("clean-db", mongo -> {
            MongoDatabase db1 = mongo.getDatabase(dbName);
            BsonDocument command = new BsonDocument();
            command.put("buildinfo", (BsonValue)new BsonString(""));
            ret.set(db1.runCommand((Bson)command));
        });
        return (Document)ret.get();
    }

    public static boolean transactionsSupported(ConnectionContext.MongoPrimary primary, String dbName) {
        Document serverInfo = TestHelper.databaseInformation(primary, dbName);
        List version = (List)serverInfo.get((Object)"versionArray");
        return (Integer)version.get(0) >= 4;
    }

    public static String lines(String ... lines) {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(lines).forEach(line -> sb.append((String)line).append(System.lineSeparator()));
        return sb.toString();
    }
}

