/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Field;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Connector;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MongoDbConnectorTest {
    @Test
    public void shouldReturnConfigurationDefinition() {
        MongoDbConnectorTest.assertConfigDefIsValid((Connector)new MongoDbConnector(), MongoDbConnectorConfig.ALL_FIELDS);
    }

    protected static void assertConfigDefIsValid(Connector connector, Field.Set fields) {
        ConfigDef configDef = connector.config();
        Assertions.assertThat((Object)configDef).isNotNull();
        fields.forEach(expected -> {
            Assertions.assertThat((Collection)configDef.names()).contains(new Object[]{expected.name()});
            ConfigDef.ConfigKey key = (ConfigDef.ConfigKey)configDef.configKeys().get(expected.name());
            Assertions.assertThat((Object)key).isNotNull();
            Assertions.assertThat((String)key.name).isEqualTo((Object)expected.name());
            Assertions.assertThat((String)key.displayName).isEqualTo((Object)expected.displayName());
            Assertions.assertThat((Object)key.importance).isEqualTo((Object)expected.importance());
            Assertions.assertThat((String)key.documentation).isEqualTo((Object)expected.description());
            Assertions.assertThat((Object)key.type).isEqualTo((Object)expected.type());
            Assertions.assertThat((Object)key.defaultValue).isEqualTo(expected.defaultValue());
            Assertions.assertThat((List)key.dependents).isEqualTo((Object)expected.dependents());
            Assertions.assertThat((Object)key.width).isNotNull();
            Assertions.assertThat((String)key.group).isNotNull();
            Assertions.assertThat((int)key.orderInGroup).isGreaterThan(0);
            Assertions.assertThat((Object)key.validator).isNull();
            Assertions.assertThat((Object)key.recommender).isNull();
        });
    }
}

