/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.ThreadSafe;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.ReplicaSets;
import io.debezium.connector.mongodb.Replicator;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.function.BlockingConsumer;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.util.LoggingContext;
import io.debezium.util.Threads;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MongoDbConnectorTask
extends BaseSourceTask {
    private static final String CONTEXT_NAME = "mongodb-connector-task";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final Deque<Replicator> replicators = new ConcurrentLinkedDeque<Replicator>();
    private final RecordBatchSummarizer recordSummarizer = new RecordBatchSummarizer();
    private volatile ChangeEventQueue<SourceRecord> queue;
    private volatile String taskName;
    private volatile MongoDbTaskContext taskContext;
    private volatile Throwable replicatorError;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator start(Configuration config) {
        MongoDbTaskContext taskContext;
        if (!this.running.compareAndSet(false, true)) {
            return null;
        }
        this.taskName = "task" + config.getInteger(MongoDbConnectorConfig.TASK_ID);
        this.taskContext = taskContext = new MongoDbTaskContext(config);
        LoggingContext.PreviousContext previousLogContext = taskContext.configureLoggingContext(this.taskName);
        try {
            String hosts = config.getString(MongoDbConnectorConfig.HOSTS);
            ReplicaSets replicaSets = ReplicaSets.parse(hosts);
            if (replicaSets.validReplicaSetCount() == 0) {
                throw new ConnectException("Unable to start MongoDB connector task since no replica sets were found at " + hosts);
            }
            MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(this::getLoggingContext).build();
            SourceInfo source = taskContext.source();
            ArrayList partitions = new ArrayList();
            replicaSets.onEachReplicaSet(replicaSet -> {
                String replicaSetName = replicaSet.replicaSetName();
                if (replicaSetName != null) {
                    partitions.add(source.partition(replicaSetName));
                }
            });
            this.context.offsetStorageReader().offsets(partitions).forEach(source::setOffsetFor);
            int numThreads = replicaSets.replicaSetCount();
            ExecutorService executor = Threads.newFixedThreadPool(MongoDbConnector.class, (String)taskContext.serverName(), (String)"replicator", (int)numThreads);
            AtomicInteger stillRunning = new AtomicInteger(numThreads);
            this.logger.info("Ignoring unnamed replica sets: {}", replicaSets.unnamedReplicaSets());
            this.logger.info("Starting {} thread(s) to replicate replica sets: {}", (Object)numThreads, (Object)replicaSets);
            replicaSets.validReplicaSets().forEach(replicaSet -> {
                Replicator replicator = new Replicator(taskContext, (ReplicaSet)replicaSet, (BlockingConsumer<SourceRecord>)((BlockingConsumer)arg_0 -> this.queue.enqueue(arg_0)), this::failedReplicator);
                this.replicators.add(replicator);
                executor.submit(() -> {
                    try {
                        taskContext.configureLoggingContext(replicaSet.replicaSetName());
                        replicator.run();
                    }
                    finally {
                        try {
                            this.replicators.remove(replicator);
                        }
                        finally {
                            if (stillRunning.decrementAndGet() == 0) {
                                try {
                                    executor.shutdown();
                                }
                                finally {
                                    taskContext.getConnectionContext().shutdown();
                                }
                            }
                        }
                    }
                });
            });
            this.logger.info("Successfully started MongoDB connector task with {} thread(s) for replica sets {}", (Object)numThreads, (Object)replicaSets);
        }
        finally {
            previousLogContext.restore();
        }
        return null;
    }

    public List<SourceRecord> poll() throws InterruptedException {
        if (this.replicatorError != null) {
            throw new ConnectException("Failing connector task, at least one of the replicators has failed", this.replicatorError);
        }
        List records = this.queue.poll();
        this.recordSummarizer.accept(records);
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            if (this.running.compareAndSet(true, false)) {
                this.logger.info("Stopping MongoDB task");
                Replicator replicator = null;
                int counter = 0;
                while ((replicator = this.replicators.poll()) != null) {
                    replicator.stop();
                    ++counter;
                }
                this.logger.info("Stopped MongoDB replication task by stopping {} replicator threads", (Object)counter);
            }
        }
        catch (Throwable e) {
            this.logger.error("Unexpected error shutting down the MongoDB replication task", e);
        }
        finally {
            previousLogContext.restore();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MongoDbConnectorConfig.ALL_FIELDS;
    }

    private LoggingContext.PreviousContext getLoggingContext() {
        return this.taskContext.configureLoggingContext(CONTEXT_NAME);
    }

    private void failedReplicator(Throwable t) {
        this.replicatorError = t;
        this.stop();
    }

    protected static final class ReplicaSetSummary {
        private int numRecords = 0;
        private Map<String, ?> lastOffset;

        protected ReplicaSetSummary() {
        }

        public void add(SourceRecord record) {
            ++this.numRecords;
            this.lastOffset = record.sourceOffset();
        }

        public int recordCount() {
            return this.numRecords;
        }

        public Map<String, ?> lastOffset() {
            return this.lastOffset;
        }
    }

    protected final class RecordBatchSummarizer
    implements Consumer<List<SourceRecord>> {
        private final Map<String, ReplicaSetSummary> summaryByReplicaSet = new HashMap<String, ReplicaSetSummary>();

        protected RecordBatchSummarizer() {
        }

        @Override
        public void accept(List<SourceRecord> records) {
            if (records.isEmpty()) {
                return;
            }
            if (!MongoDbConnectorTask.this.logger.isInfoEnabled()) {
                return;
            }
            this.summaryByReplicaSet.clear();
            records.forEach(record -> {
                String replicaSetName = SourceInfo.replicaSetNameForPartition(record.sourcePartition());
                if (replicaSetName != null) {
                    this.summaryByReplicaSet.computeIfAbsent(replicaSetName, rsName -> new ReplicaSetSummary()).add((SourceRecord)record);
                }
            });
            if (!this.summaryByReplicaSet.isEmpty()) {
                LoggingContext.PreviousContext prevContext = MongoDbConnectorTask.this.taskContext.configureLoggingContext("task");
                try {
                    this.summaryByReplicaSet.forEach((rsName, summary) -> MongoDbConnectorTask.this.logger.info("{} records sent for replica set '{}', last offset: {}", new Object[]{summary.recordCount(), rsName, summary.lastOffset()}));
                }
                finally {
                    prevContext.restore();
                }
            }
        }
    }
}

