/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms.UpdateOperators;

import io.debezium.connector.mongodb.transforms.UpdateOperators.AbstractUnwrapFromMongoDbEnvelopeUpdateOperatorsTestIT;
import io.debezium.data.VerifyRecord;
import java.util.Arrays;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class UnwrapFromMongoDbEnvelopeUpdateArrayOperatorTestIT
extends AbstractUnwrapFromMongoDbEnvelopeUpdateOperatorsTestIT {
    @Test
    public void shouldTransformOperationAddToSet() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$addToSet': {dataArrayOfStr: 'b'}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataArrayOfStr", (Schema)valueSchema.field("dataArrayOfStr").schema(), (Schema)SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataArrayOfStr")).isEqualTo(Arrays.asList("a", "c", "e", "b"));
    }

    @Test
    public void shouldTransformOperationPop() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$pop': {dataArrayOfStr: -1}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataArrayOfStr", (Schema)valueSchema.field("dataArrayOfStr").schema(), (Schema)SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataArrayOfStr")).isEqualTo(Arrays.asList("c", "e"));
    }

    @Test
    public void shouldTransformOperationPull() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$pull': {dataArrayOfStr: {$in: ['c']}}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataArrayOfStr", (Schema)valueSchema.field("dataArrayOfStr").schema(), (Schema)SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataArrayOfStr")).isEqualTo(Arrays.asList("a", "e"));
    }

    @Test
    public void shouldTransformOperationPullAll() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$pullAll': {dataArrayOfStr: ['c']}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataArrayOfStr", (Schema)valueSchema.field("dataArrayOfStr").schema(), (Schema)SchemaBuilder.array((Schema)Schema.OPTIONAL_STRING_SCHEMA).optional().build());
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataArrayOfStr")).isEqualTo(Arrays.asList("a", "e"));
    }

    @Test
    public void shouldTransformOperationPush() throws InterruptedException {
        SourceRecord updateRecord = this.executeSimpleUpdateOperation("{'$push': {dataArrayOfStr: 'g'}}");
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Schema valueSchema = transformedUpdate.valueSchema();
        VerifyRecord.assertConnectSchemasAreEqual((String)"id", (Schema)valueSchema.field("id").schema(), (Schema)Schema.OPTIONAL_INT32_SCHEMA);
        VerifyRecord.assertConnectSchemasAreEqual((String)"dataArrayOfStr.3", (Schema)valueSchema.field("dataArrayOfStr.3").schema(), (Schema)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataArrayOfStr.3")).isEqualTo((Object)"g");
    }
}

