/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.connector.mongodb.transforms.AbstractUnwrapFromMongoDbEnvelopeTestIT;
import io.debezium.data.Envelope;
import io.debezium.data.SchemaUtil;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import java.io.IOException;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class UnwrapFromMongoDbEnvelopeTestIT
extends AbstractUnwrapFromMongoDbEnvelopeTestIT {
    private static final String CONFIG_DROP_TOMBSTONES = "drop.tombstones";
    private static final String HANDLE_DELETES = "delete.handling.mode";

    @Override
    protected String getCollectionName() {
        return "functional";
    }

    @Test
    @FixFor(value={"DBZ-563"})
    public void shouldDropTombstoneByDefault() throws InterruptedException {
        this.primary().execute("insert", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).insertOne((Object)Document.parse((String)"{'_id': 1, 'dataStr': 'hello', 'dataInt': 123, 'dataLong': 80000000000}")));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        this.primary().execute("delete", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).deleteOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}")));
        SourceRecord firstRecord = this.getRecordByOperation(Envelope.Operation.DELETE);
        SourceRecord transformedDelete = (SourceRecord)this.transformation.apply((ConnectRecord)firstRecord);
        Assertions.assertThat((Object)transformedDelete).isNull();
        SourceRecord tombstoneRecord = this.getNextRecord();
        Assertions.assertThat((Object)tombstoneRecord).isNotNull();
        SourceRecord transformedTombstone = (SourceRecord)this.transformation.apply((ConnectRecord)tombstoneRecord);
        Assertions.assertThat((Object)transformedTombstone).isNull();
    }

    @Test
    public void shouldTransformEvents() throws InterruptedException, IOException {
        HashMap<String, String> transformationConfig = new HashMap<String, String>();
        transformationConfig.put(CONFIG_DROP_TOMBSTONES, "false");
        transformationConfig.put(HANDLE_DELETES, "none");
        this.transformation.configure(transformationConfig);
        this.primary().execute("insert", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).insertOne((Object)Document.parse((String)"{'_id': 1, 'dataStr': 'hello', 'dataInt': 123, 'dataLong': 80000000000}")));
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        SourceRecord insertRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedInsert = (SourceRecord)this.transformation.apply((ConnectRecord)insertRecord);
        Struct transformedInsertValue = (Struct)transformedInsert.value();
        Assertions.assertThat((Object)transformedInsert.valueSchema().field("id").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedInsert.valueSchema().field("dataStr").schema()).isEqualTo((Object)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedInsert.valueSchema().field("dataInt").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedInsert.valueSchema().field("dataLong").schema()).isEqualTo((Object)Schema.OPTIONAL_INT64_SCHEMA);
        Assertions.assertThat((Object)transformedInsertValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedInsertValue.get("dataStr")).isEqualTo((Object)"hello");
        Assertions.assertThat((Object)transformedInsertValue.get("dataInt")).isEqualTo((Object)123);
        Assertions.assertThat((Object)transformedInsertValue.get("dataLong")).isEqualTo((Object)80000000000L);
        this.primary().execute("update", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}"), (Bson)RawBsonDocument.parse((String)"{'$set': {'dataStr': 'bye'}}")));
        records = this.consumeRecordsByTopic(1);
        SourceRecord candidateUpdateRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        if (((Struct)candidateUpdateRecord.value()).get("op").equals("c")) {
            records = this.consumeRecordsByTopic(1);
        }
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        SourceRecord updateRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateRecord);
        Struct transformedUpdateValue = (Struct)transformedUpdate.value();
        Assertions.assertThat((Object)transformedUpdate.valueSchema().field("id").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUpdate.valueSchema().field("dataStr").schema()).isEqualTo((Object)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUpdateValue.get("dataStr")).isEqualTo((Object)"bye");
        this.primary().execute("update", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}"), (Bson)RawBsonDocument.parse((String)"{'$set': {'newStr': 'hello', 'dataInt': 456}}")));
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        SourceRecord updateMultipleRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedMultipleUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateMultipleRecord);
        Struct transformedMultipleUpdateValue = (Struct)transformedMultipleUpdate.value();
        Assertions.assertThat((Object)transformedMultipleUpdate.valueSchema().field("id").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedMultipleUpdate.valueSchema().field("newStr").schema()).isEqualTo((Object)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedMultipleUpdate.valueSchema().field("dataInt").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedMultipleUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedMultipleUpdateValue.get("newStr")).isEqualTo((Object)"hello");
        Assertions.assertThat((Object)transformedMultipleUpdateValue.get("dataInt")).isEqualTo((Object)456);
        this.primary().execute("update", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}"), (Bson)RawBsonDocument.parse((String)"{'$unset': {'newStr': ''}}")));
        records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        SourceRecord updateUnsetRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedUnsetUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)updateUnsetRecord);
        Struct transformedUnsetUpdateValue = (Struct)transformedUnsetUpdate.value();
        Assertions.assertThat((Object)transformedUnsetUpdate.valueSchema().field("id").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedUnsetUpdate.valueSchema().field("newStr").schema()).isEqualTo((Object)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedUnsetUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedUnsetUpdateValue.get("newStr")).isEqualTo(null);
        this.primary().execute("update", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).updateOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}"), (Bson)RawBsonDocument.parse((String)"{'dataStr': 'Hi again'}")));
        records = this.consumeRecordsByTopic(1);
        SourceRecord candidateFullUpdateRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        if (((Struct)candidateFullUpdateRecord.value()).get("op").equals("c")) {
            records = this.consumeRecordsByTopic(1);
        }
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        SourceRecord FullUpdateRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedFullUpdate = (SourceRecord)this.transformation.apply((ConnectRecord)FullUpdateRecord);
        Struct transformedFullUpdateValue = (Struct)transformedFullUpdate.value();
        Assertions.assertThat((Object)transformedFullUpdate.valueSchema().field("id").schema()).isEqualTo((Object)Schema.OPTIONAL_INT32_SCHEMA);
        Assertions.assertThat((Object)transformedFullUpdate.valueSchema().field("dataStr").schema()).isEqualTo((Object)Schema.OPTIONAL_STRING_SCHEMA);
        Assertions.assertThat((Object)transformedFullUpdateValue.get("id")).isEqualTo((Object)1);
        Assertions.assertThat((Object)transformedFullUpdateValue.get("dataStr")).isEqualTo((Object)"Hi again");
        this.primary().execute("delete", client -> client.getDatabase("transform_operations").getCollection(this.getCollectionName()).deleteOne((Bson)RawBsonDocument.parse((String)"{'_id' : 1}")));
        records = this.consumeRecordsByTopic(2);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(2);
        SourceRecord deleteRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
        SourceRecord transformedDelete = (SourceRecord)this.transformation.apply((ConnectRecord)deleteRecord);
        Struct transformedDeleteValue = (Struct)transformedDelete.value();
        Assertions.assertThat((Object)transformedDeleteValue).isNull();
        SourceRecord tombstoneRecord = (SourceRecord)records.recordsForTopic(this.topicName()).get(1);
        SourceRecord transformedTombstone = (SourceRecord)this.transformation.apply((ConnectRecord)tombstoneRecord);
        Assertions.assertThat((Object)transformedTombstone.value()).isNull();
        Assertions.assertThat((String)SchemaUtil.asString((Schema)transformedDelete.keySchema())).isEqualTo((Object)SchemaUtil.asString((Schema)transformedTombstone.keySchema()));
        Assertions.assertThat((String)transformedDelete.key().toString()).isEqualTo((Object)transformedTombstone.key().toString());
    }
}

