/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.transforms;

import io.debezium.config.Configuration;
import io.debezium.connector.mongodb.ConnectionContext;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.ReplicaSet;
import io.debezium.connector.mongodb.TestHelper;
import io.debezium.connector.mongodb.transforms.UnwrapFromMongoDbEnvelope;
import io.debezium.data.Envelope;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.util.Testing;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class AbstractUnwrapFromMongoDbEnvelopeTestIT
extends AbstractConnectorTest {
    protected static final String DB_NAME = "transform_operations";
    private MongoDbTaskContext context;
    protected UnwrapFromMongoDbEnvelope<SourceRecord> transformation;

    protected abstract String getCollectionName();

    protected String topicName() {
        return String.format("mongo.%s.%s", DB_NAME, this.getCollectionName());
    }

    @Before
    public void beforeEach() {
        Testing.Debug.disable();
        Testing.Print.disable();
        this.stopConnector();
        this.initializeConnectorTestFramework();
        this.transformation = new UnwrapFromMongoDbEnvelope();
        this.transformation.configure(Collections.emptyMap());
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)TestHelper.getConfiguration().edit().with(MongoDbConnectorConfig.POLL_INTERVAL_MS, 10)).with(MongoDbConnectorConfig.COLLECTION_WHITELIST, "transform_operations." + this.getCollectionName())).with(MongoDbConnectorConfig.LOGICAL_NAME, "mongo")).build();
        this.context = new MongoDbTaskContext(config);
        TestHelper.cleanDatabase(this.primary(), DB_NAME);
        this.start(MongoDbConnector.class, config);
    }

    @After
    public void afterEach() {
        try {
            this.stopConnector();
        }
        finally {
            if (this.context != null) {
                this.context.getConnectionContext().shutdown();
            }
        }
        this.transformation.close();
    }

    SourceRecord getRecordByOperation(Envelope.Operation operation) throws InterruptedException {
        SourceRecord candidateRecord = this.getNextRecord();
        if (!((Struct)candidateRecord.value()).get("op").equals(operation.code())) {
            return this.getRecordByOperation(operation);
        }
        return candidateRecord;
    }

    SourceRecord getNextRecord() throws InterruptedException {
        AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
        Assertions.assertThat((int)records.recordsForTopic(this.topicName()).size()).isEqualTo(1);
        return (SourceRecord)records.recordsForTopic(this.topicName()).get(0);
    }

    protected SourceRecord getUpdateRecord() throws InterruptedException {
        return this.getRecordByOperation(Envelope.Operation.UPDATE);
    }

    protected ConnectionContext.MongoPrimary primary() {
        ReplicaSet replicaSet = ReplicaSet.parse((String)this.context.getConnectionContext().hosts());
        return this.context.getConnectionContext().primaryFor(replicaSet, this.context.filters(), this.connectionErrorHandler(3));
    }

    private BiConsumer<String, Throwable> connectionErrorHandler(int numErrorsBeforeFailing) {
        AtomicInteger attempts = new AtomicInteger();
        return (desc, error) -> {
            if (attempts.incrementAndGet() > numErrorsBeforeFailing) {
                Assert.fail((String)("Unable to connect to primary after " + numErrorsBeforeFailing + " errors trying to " + desc + ": " + error));
            }
            this.logger.error("Error while attempting to {}: {}", new Object[]{desc, error.getMessage(), error});
        };
    }
}

