/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Configurator;
import io.debezium.connector.mongodb.Filters;
import io.debezium.connector.mongodb.MongoDbTopicSelector;
import io.debezium.connector.mongodb.RecordMakers;
import io.debezium.connector.mongodb.SourceInfo;
import io.debezium.schema.TopicSelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.bson.types.ObjectId;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class FieldRenamesTest {
    private static final String SERVER_NAME = "serverX";
    private static final String PATCH = "patch";
    private static final JsonWriterSettings WRITER_SETTINGS = new JsonWriterSettings(JsonMode.STRICT, "", "");
    private Configurator build;
    private SourceInfo source;
    private TopicSelector<CollectionId> topicSelector;

    @Before
    public void setup() {
        this.build = new Configurator();
        this.source = new SourceInfo(SERVER_NAME);
        this.topicSelector = MongoDbTopicSelector.defaultSelector((String)SERVER_NAME, (String)"__debezium-heartbeat");
    }

    @Test
    public void shouldNotRenameFieldsForEventOfOtherCollection() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c2.name:new_name,*.c2.active:new_active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameMissingFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameNestedFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"address\" : {\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameNestedFieldsToExistingNamesForReadEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.street:city").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordObject(collectionId, obj, 1002L);
    }

    @Test
    public void shouldRenameFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameMissingFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameNestedFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"address\" : {\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get("after")).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameNestedFieldsToExistingNamesForInsertEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.street:city").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "i"), 1002L);
    }

    @Test
    public void shouldRenameFieldsForUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameMissingFieldsForUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameNestedFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"address\" : {\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}},\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\",\"new_active\" : true}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedMissingFieldsForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.missing:new_missing").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameNestedFieldsToExistingNamesForUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.address.street:city").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
    }

    @Test
    public void shouldRenameNestedFieldsForUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"addresses\" : [{\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}}, {\"street\" : \"Fragkokklisias\",\"city\" : \"Athens\",\"new_number\" : {\"$numberLong\" : \"7\"}}],\"active\" : true,\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\"}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedFieldsForUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("_id", (Object)objId).append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))).append("active", (Object)true).append("scores", Arrays.asList(1.2, 3.4, 5.6));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"_id\" : {\"$oid\" : \"" + objId + "\"},\"phone\" : {\"$numberLong\" : \"123\"},\"addresses\" : [[{\"number\" : {\"$numberLong\" : \"34\"},\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\"}], [{\"number\" : {\"$numberLong\" : \"7\"},\"street\" : \"Fragkokklisias\",\"city\" : \"Athens\"}]],\"active\" : true,\"scores\" : [1.2, 3.4, 5.6],\"new_name\" : \"Sally\"}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameFieldsForSetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L));
        Filters filters = this.build.renameFields("*.c1.name:new_name").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"phone\" : {\"$numberLong\" : \"123\"},\"new_name\" : \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameFieldsToExistingNamesForSetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L));
        Filters filters = this.build.renameFields("*.c1.name:phone").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
    }

    @Test
    public void shouldRenameFieldsForUnsetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("phone", (Object)""));
        Filters filters = this.build.renameFields("*.c1.name:new_name").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\" : {\"phone\" : \"\",\"new_name\" : \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameFieldsToExistingNamesForUnsetTopLevelFieldUpdateEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("phone", (Object)""));
        Filters filters = this.build.renameFields("*.c1.name:phone").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
    }

    @Test
    public void shouldRenameNestedFieldsForSetTopLevelFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("address", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"phone\" : {\"$numberLong\" : \"123\"},\"address\" : {\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}},\"new_name\" : \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam"), new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens"))));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"phone\" : {\"$numberLong\" : \"123\"},\"addresses\" : [{\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\",\"new_number\" : {\"$numberLong\" : \"34\"}}, {\"street\" : \"Fragkokklisias\",\"city\" : \"Athens\",\"new_number\" : {\"$numberLong\" : \"7\"}}],\"new_name\" : \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldNotRenameNestedFieldsForSetTopLevelFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("phone", (Object)123L).append("addresses", Arrays.asList(Collections.singletonList(new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")), Collections.singletonList(new Document().append("number", (Object)7L).append("street", (Object)"Fragkokklisias").append("city", (Object)"Athens")))));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"phone\" : {\"$numberLong\" : \"123\"},\"addresses\" : [[{\"number\" : {\"$numberLong\" : \"34\"},\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\"}], [{\"number\" : {\"$numberLong\" : \"7\"},\"street\" : \"Fragkokklisias\",\"city\" : \"Athens\"}]],\"new_name\" : \"Sally\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("address.number", (Object)34L).append("address.street", (Object)"Claude Debussylaan").append("address.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"address.street\" : \"Claude Debussylaan\",\"address.city\" : \"Amsterdam\",\"new_name\" : \"Sally\",\"address.new_number\" : {\"$numberLong\" : \"34\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"name\" : \"Sally\",\"addresses.0.street\" : \"Claude Debussylaan\",\"addresses.0.city\" : \"Amsterdam\",\"addresses.0.new_number\" : {\"$numberLong\" : \"34\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameNestedFieldsToExistingNamesForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.addresses.street:city").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
    }

    @Test
    public void shouldNotRenameNestedFieldsForSetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.0.number", (Object)34L).append("addresses.0.0.street", (Object)"Claude Debussylaan").append("addresses.0.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameNestedFieldsForSetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.second.0.number", (Object)34L).append("addresses.0.second.0.street", (Object)"Claude Debussylaan").append("addresses.0.second.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.addresses.second.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"name\" : \"Sally\",\"addresses.0.second.0.street\" : \"Claude Debussylaan\",\"addresses.0.second.0.city\" : \"Amsterdam\",\"addresses.0.second.0.new_number\" : {\"$numberLong\" : \"34\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameFieldsForSetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0.number", (Object)34L).append("addresses.0.street", (Object)"Claude Debussylaan").append("addresses.0.city", (Object)"Amsterdam"));
        Filters filters = this.build.renameFields("*.c1.addresses:new_addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"name\" : \"Sally\",\"new_addresses.0.number\" : {\"$numberLong\" : \"34\"},\"new_addresses.0.street\" : \"Claude Debussylaan\",\"new_addresses.0.city\" : \"Amsterdam\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameFieldsForSetToArrayFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$set", (Object)new Document().append("name", (Object)"Sally").append("addresses.0", (Object)new Document().append("number", (Object)34L).append("street", (Object)"Claude Debussylaan").append("city", (Object)"Amsterdam")));
        Filters filters = this.build.renameFields("*.c1.addresses:new_addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$set\" : {\"name\" : \"Sally\",\"new_addresses.0\" : {\"number\" : {\"$numberLong\" : \"34\"},\"street\" : \"Claude Debussylaan\",\"city\" : \"Amsterdam\"}}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithEmbeddedDocument() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("address.number", (Object)"").append("address.street", (Object)"").append("address.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.address.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\" : {\"address.street\" : \"\",\"address.city\" : \"\",\"new_name\" : \"\",\"address.new_number\" : \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\" : {\"name\" : \"\",\"addresses.0.street\" : \"\",\"addresses.0.city\" : \"\",\"addresses.0.new_number\" : \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotRenameNestedFieldsToExistingNamesForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.addresses.street:city").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
    }

    @Test
    public void shouldNotRenameNestedFieldsForUnsetNestedFieldUpdateEventWithArrayOfArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.0.number", (Object)"").append("addresses.0.0.street", (Object)"").append("addresses.0.0.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.addresses.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)obj.toJson(WRITER_SETTINGS));
    }

    @Test
    public void shouldRenameNestedFieldsForUnsetNestedFieldUpdateEventWithSeveralArrays() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.second.0.number", (Object)"").append("addresses.0.second.0.street", (Object)"").append("addresses.0.second.0.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.addresses.second.number:new_number").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\" : {\"name\" : \"\",\"addresses.0.second.0.street\" : \"\",\"addresses.0.second.0.city\" : \"\",\"addresses.0.second.0.new_number\" : \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameFieldsForUnsetNestedFieldUpdateEventWithArrayOfEmbeddedDocuments() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document().append("$unset", (Object)new Document().append("name", (Object)"").append("addresses.0.number", (Object)"").append("addresses.0.street", (Object)"").append("addresses.0.city", (Object)""));
        Filters filters = this.build.renameFields("*.c1.addresses:new_addresses").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createUpdateEvent(obj, objId), 1002L);
        String expected = "{\"$unset\" : {\"name\" : \"\",\"new_addresses.0.number\" : \"\",\"new_addresses.0.street\" : \"\",\"new_addresses.0.city\" : \"\"}}";
        Struct value = this.getValue(produced);
        Assertions.assertThat((Object)value.get(PATCH)).isEqualTo((Object)expected);
    }

    @Test
    public void shouldRenameFieldsForDeleteEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active").createFilters();
        ArrayList<SourceRecord> produced = new ArrayList<SourceRecord>();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "d"), 1002L);
        Struct value = this.getValue(produced);
        String json = value.getString("after");
        if (json == null) {
            json = value.getString(PATCH);
        }
        Assertions.assertThat((String)json).isNull();
    }

    @Test
    public void shouldRenameFieldsForDeleteTombstoneEvent() throws InterruptedException {
        CollectionId collectionId = new CollectionId("rs0", "dbA", "c1");
        ObjectId objId = new ObjectId();
        Document obj = new Document("_id", (Object)objId);
        Filters filters = this.build.renameFields("*.c1.name:new_name,*.c1.active:new_active").createFilters();
        ArrayList produced = new ArrayList();
        RecordMakers recordMakers = new RecordMakers(filters, this.source, this.topicSelector, produced::add, true);
        recordMakers.forCollection(collectionId).recordEvent(this.createEvent(obj, "d"), 1002L);
        SourceRecord record = (SourceRecord)produced.get(1);
        Assertions.assertThat((Object)record.value()).isNull();
    }

    private Struct getValue(List<SourceRecord> produced) {
        SourceRecord record = produced.get(0);
        return (Struct)record.value();
    }

    private Document createEvent(Document obj, String op) {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        return new Document().append("o", (Object)obj).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)op);
    }

    private Document createUpdateEvent(Document obj, ObjectId objId) {
        BsonTimestamp ts = new BsonTimestamp(1000, 1);
        return new Document().append("o", (Object)obj).append("o2", (Object)objId).append("ns", (Object)"dbA.c1").append("ts", (Object)ts).append("h", (Object)12345678L).append("op", (Object)"u");
    }
}

